<?php namespace App\Http\Controllers;

use Auth;
use Input, App\Design;
use App\Http\Requests;
use App\Services\DesignPreviewCreator;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

class DesignsController extends Controller {

	/**
	 * Display a listing of the resource.
	 *
	 * @return Response
	 */
	public function index()
	{
	    return Auth::user()->designs;
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return Response
	 */
	public function create()
	{
		//
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @return Response
	 */
	public function store(DesignPreviewCreator $preview)
	{
        $design = Input::except('previewImageData');

        $design = Design::create($design);

        $preview->create($design->id, Input::get('previewImageData'));

        return json_encode($design);
	}

	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
		return Design::findOrFail($id);
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{

	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id, DesignPreviewCreator $preview)
	{
        $input = Input::except('previewImageData');

        $design = Design::findOrFail($id);
        $design->fill($input)->save();

        $preview->create($design->id, Input::get('previewImageData'));

        return json_encode($design);
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
		//
	}

}
