<?php

return [

	/*
	|--------------------------------------------------------------------------
	| Default Filesystem Disk
	|--------------------------------------------------------------------------
	|
	| Here you may specify the default filesystem disk that should be used
	| by the framework. A "local" driver, as well as a variety of cloud
	| based drivers are available for your choosing. Just store away!
	|
	| Supported: "local", "s3", "rackspace", "dropbox"
	|
	*/

	'default' => env('FILESYSTEM_DEFAULT', 'local'),

	/*
	|--------------------------------------------------------------------------
	| Default Cloud Filesystem Disk
	|--------------------------------------------------------------------------
	|
	| Many applications store files both locally and in the cloud. For this
	| reason, you may specify a default "cloud" driver here. This driver
	| will be bound as the Cloud disk implementation in the container.
	|
	*/

	'cloud' => 's3',

	/*
	|--------------------------------------------------------------------------
	| Filesystem Disks
	|--------------------------------------------------------------------------
	|
	| Here you may configure as many filesystem "disks" as you wish, and you
	| may even configure multiple disks of the same driver. Defaults have
	| been setup for each driver as an example of the required options.
	|
	*/

	'disks' => [

		'local' => [
			'driver' => 'local',
			'root'   => str_replace('application', '', base_path()),
		],

		's3' => [
			'driver' => 's3',
			'key'    => env('S3_KEY', 'your-key'),
			'secret' => env('S3_SECRET', 'your-secret'),
			'region' => env('S3_REGION', 'your-region'),
			'bucket' => env('S3_BUCKET', 'your-bucket'),
		],

		'rackspace' => [
			'driver'    => 'rackspace',
			'username'  => env('RACKSPACE_USERNAME', 'your-username'),
			'key'       => env('RACKSPACE_KEY', 'your-key'),
			'container' => env('RACKSPACE_CONTAINER', 'your-container'),
			'endpoint'  => 'https://identity.api.rackspacecloud.com/v2.0/',
			'region'    => env('RACKSPACE_REGION', 'IAD'),
			'url_type'  => 'publicURL'
		],

		'dropbox' => [
            'driver'           => 'dropbox',
			'accessToken'      => env('DROPBOX_ACCESS_TOKEN', 'your-token'),
			'clientIdentifier' => env('DROPBOX_CLIENT_IDENTIFIER', 'your-identifier'),
		]
	],

];
