/*!
 * Angular Material Design
 * https://github.com/angular/material
 * @license MIT
 * v0.10.1
 */
 !function(e,t,n){"use strict";!function(){t.module("ngMaterial",["ng","ngAnimate","ngAria","material.core","material.core.gestures","material.core.theming.palette","material.core.theming","material.components.backdrop","material.components.autocomplete","material.components.button","material.components.bottomSheet","material.components.card","material.components.checkbox","material.components.chips","material.components.content","material.components.dialog","material.components.divider","material.components.fabActions","material.components.fabSpeedDial","material.components.fabToolbar","material.components.fabTrigger","material.components.gridList","material.components.icon","material.components.input","material.components.list","material.components.menu","material.components.progressCircular","material.components.progressLinear","material.components.radioButton","material.components.select","material.components.sidenav","material.components.slider","material.components.sticky","material.components.subheader","material.components.swipe","material.components.switch","material.components.tabs","material.components.toast","material.components.tooltip","material.components.virtualRepeat","material.components.whiteframe","material.components.toolbar"])}(),function(){function e(e,t){e.decorator("$$rAF",["$delegate",n]),t.theme("default").primaryPalette("indigo").accentPalette("pink").warnPalette("red").backgroundPalette("grey")}function n(e){return e.throttle=function(t){var n,o,r,i;return function(){n=arguments,i=this,r=t,o||(o=!0,e(function(){r.apply(i,Array.prototype.slice.call(n)),o=!1}))}},e}t.module("material.core",["material.core.gestures","material.core.theming"]).config(e),e.$inject=["$provide","$mdThemingProvider"]}(),function(){function e(e,n,o,r,i){var a;return a={translate3d:function(e,t,o,r){function i(n){return e.removeClass(r.transitionInClass).addClass(r.transitionOutClass).css(n||t),a.waitTransitionEnd(e)}return e.css(t),n(function(){e.css(o).addClass(r.transitionInClass)}),a.waitTransitionEnd(e).then(function(){return i})},waitTransitionEnd:function(e,t){var n=3e3;return o(function(o,a){function d(t){t&&t.target!==e[0]||(t&&r.cancel(c),e.off(i.CSS.TRANSITIONEND,d),o())}t=t||{};var c=r(d,t.timeout||n);e.on(i.CSS.TRANSITIONEND,d)})},calculateZoomToOrigin:function(n,o){var r=o.element,i="translate3d( {centerX}px, {centerY}px, 0 ) scale( {scaleX}, {scaleY} )",d=t.bind(null,e.supplant,i),c=d({centerX:0,centerY:0,scaleX:.5,scaleY:.5});if(r){var l=a.clientRect(r)||a.copyRect(o.bounds),m=a.copyRect(n[0].getBoundingClientRect()),s=a.centerPointFor(m),u=a.centerPointFor(l);c=d({centerX:u.x-s.x,centerY:u.y-s.y,scaleX:Math.min(.5,l.width/m.width),scaleY:Math.min(.5,l.height/m.height)})}return c},toTransformCss:function(e,n){var o={};return t.forEach(i.CSS.TRANSFORM.split(" "),function(t){o[t]=e}),n&&(o.transition="all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1) !important"),o},copyRect:function(e,n){return e?(n=n||{},t.forEach("left top right bottom width height".split(" "),function(t){n[t]=Math.round(e[t])}),n.width=n.width||n.right-n.left,n.height=n.height||n.bottom-n.top,n):null},clientRect:function(e){var n=t.element(e)[0].getBoundingClientRect(),o=function(e){return e&&e.width>0&&e.height>0};return o(n)?a.copyRect(n):null},centerPointFor:function(e){return{x:Math.round(e.left+e.width/2),y:Math.round(e.top+e.height/2)}}}}t.module("material.core").factory("$$mdAnimate",["$$rAF","$q","$timeout","$mdConstant",function(t,n,o,r){return function(i){return e(i,t,n,o,r)}}])}(),function(){function e(e){function t(e){return n?"webkit"+e.charAt(0).toUpperCase()+e.substring(1):e}var n=/webkit/i.test(e.vendorPrefix);return{KEY_CODE:{ENTER:13,ESCAPE:27,SPACE:32,LEFT_ARROW:37,UP_ARROW:38,RIGHT_ARROW:39,DOWN_ARROW:40,TAB:9,BACKSPACE:8,DELETE:46},CSS:{TRANSITIONEND:"transitionend"+(n?" webkitTransitionEnd":""),ANIMATIONEND:"animationend"+(n?" webkitAnimationEnd":""),TRANSFORM:t("transform"),TRANSFORM_ORIGIN:t("transformOrigin"),TRANSITION:t("transition"),TRANSITION_DURATION:t("transitionDuration"),ANIMATION_PLAY_STATE:t("animationPlayState"),ANIMATION_DURATION:t("animationDuration"),ANIMATION_NAME:t("animationName"),ANIMATION_TIMING:t("animationTimingFunction"),ANIMATION_DIRECTION:t("animationDirection")},MEDIA:{sm:"(max-width: 599px)","gt-sm":"(min-width: 600px)",md:"(min-width: 600px) and (max-width: 959px)","gt-md":"(min-width: 960px)",lg:"(min-width: 960px) and (max-width: 1199px)","gt-lg":"(min-width: 1200px)"},MEDIA_PRIORITY:["gt-lg","lg","gt-md","md","gt-sm","sm"]}}t.module("material.core").factory("$mdConstant",e),e.$inject=["$sniffer"]}(),function(){function e(e,n){function o(){return[].concat(E)}function r(){return E.length}function i(e){return E.length&&e>-1&&e<E.length}function a(e){return e?i(u(e)+1):!1}function d(e){return e?i(u(e)-1):!1}function c(e){return i(e)?E[e]:null}function l(e,t){return E.filter(function(n){return n[e]===t})}function m(e,n){return e?(t.isNumber(n)||(n=E.length),E.splice(n,0,e),u(e)):-1}function s(e){p(e)&&E.splice(u(e),1)}function u(e){return E.indexOf(e)}function p(e){return e&&u(e)>-1}function f(){return E.length?E[0]:null}function h(){return E.length?E[E.length-1]:null}function b(e,o,r,a){r=r||g;for(var d=u(o);;){if(!i(d))return null;var c=d+(e?-1:1),l=null;if(i(c)?l=E[c]:n&&(l=e?h():f(),c=u(l)),null===l||c===a)return null;if(r(l))return l;t.isUndefined(a)&&(a=c),d=c}}var g=function(){return!0};e&&!t.isArray(e)&&(e=Array.prototype.slice.call(e)),n=!!n;var E=e||[];return{items:o,count:r,inRange:i,contains:p,indexOf:u,itemAt:c,findBy:l,add:m,remove:s,first:f,last:h,next:t.bind(null,b,!1),previous:t.bind(null,b,!0),hasPrevious:d,hasNext:a}}t.module("material.core").config(["$provide",function(t){t.decorator("$mdUtil",["$delegate",function(t){return t.iterator=e,t}])}])}(),function(){function e(e,n,o){function r(e){var n=u[e];t.isUndefined(n)&&(n=u[e]=i(e));var o=f[n];return t.isUndefined(o)&&(o=a(n)),o}function i(t){return e.MEDIA[t]||("("!==t.charAt(0)?"("+t+")":t)}function a(e){var t=p[e]=o.matchMedia(e);return t.addListener(d),f[t.media]=!!t.matches}function d(e){n.$evalAsync(function(){f[e.media]=!!e.matches})}function c(e){return p[e]}function l(t,n){for(var o=0;o<e.MEDIA_PRIORITY.length;o++){var r=e.MEDIA_PRIORITY[o];if(p[u[r]].matches){var i=s(t,n+"-"+r);if(t[i])return t[i]}}return t[s(t,n)]}function m(n,o,r){var i=[];return n.forEach(function(n){var a=s(o,n);o[a]&&i.push(o.$observe(a,t.bind(void 0,r,null)));for(var d in e.MEDIA){if(a=s(o,n+"-"+d),!o[a])return;i.push(o.$observe(a,t.bind(void 0,r,d)))}}),function(){i.forEach(function(e){e()})}}function s(e,t){return h[t]||(h[t]=e.$normalize(t))}var u={},p={},f={},h={};return r.getResponsiveAttribute=l,r.getQuery=c,r.watchResponsiveAttributes=m,r}t.module("material.core").factory("$mdMedia",e),e.$inject=["$mdConstant","$rootScope","$window"]}(),function(){var o=0;t.module("material.core").factory("$mdUtil",["$cacheFactory","$document","$timeout","$q","$compile","$window","$mdConstant","$$rAF","$rootScope","$$mdAnimate",function(r,i,a,d,c,l,m,s,u,p){function f(e){return e[0]||e}var h={dom:{},now:e.performance?t.bind(e.performance,e.performance.now):Date.now,clientRect:function(e,t,n){var o=f(e);t=f(t||o.offsetParent||document.body);var r=o.getBoundingClientRect(),i=n?t.getBoundingClientRect():{left:0,top:0,width:0,height:0};return{left:r.left-i.left,top:r.top-i.top,width:r.width,height:r.height}},offsetRect:function(e,t){return h.clientRect(e,t,!0)},nodesToArray:function(e){e=e||[];for(var t=[],n=0;n<e.length;++n)t.push(e.item(n));return t},scrollTop:function(e){e=t.element(e||i[0].body);var o=e[0]==i[0].body?i[0].body:n,r=o?o.scrollTop+o.parentElement.scrollTop:0;return r||Math.abs(e[0].getBoundingClientRect().top)},disableScrollAround:function(e,n){function o(e){function n(e){}function o(e){e.preventDefault()}e=t.element(e||d)[0];var r=50,a=t.element('<div class="md-scroll-mask" style="z-index: '+r+'">  <div class="md-scroll-mask-bar"></div></div>');return e.appendChild(a[0]),a.on("wheel",o),a.on("touchmove",o),i.on("keydown",n),function(){a.off("wheel"),a.off("touchmove"),a[0].parentNode.removeChild(a[0]),i.off("keydown",n),delete h.disableScrollAround._enableScrolling}}function r(){var e=d.parentNode,t=e.getAttribute("style")||"",n=d.getAttribute("style")||"",o=h.scrollTop(d),r=d.clientWidth;return d.scrollHeight>d.clientHeight&&(a(d,{position:"fixed",width:"100%",top:-o+"px"}),a(e,{overflowY:"scroll"})),d.clientWidth<r&&a(d,{overflow:"hidden"}),function(){d.setAttribute("style",n),e.setAttribute("style",t),d.scrollTop=o}}function a(e,t){for(var n in t)e.style[n]=t[n]}if(h.disableScrollAround._count=h.disableScrollAround._count||0,++h.disableScrollAround._count,h.disableScrollAround._enableScrolling)return h.disableScrollAround._enableScrolling;e=t.element(e);var d=i[0].body,c=r(),l=o(n);return h.disableScrollAround._enableScrolling=function(){--h.disableScrollAround._count||(c(),l(),delete h.disableScrollAround._enableScrolling)}},enableScrolling:function(){var e=this.disableScrollAround._enableScrolling;e&&e()},floatingScrollbars:function(){if(this.floatingScrollbars.cached===n){var e=t.element('<div style="width: 100%; z-index: -1; position: absolute; height: 35px; overflow-y: scroll"><div style="height: 60;"></div></div>');i[0].body.appendChild(e[0]),this.floatingScrollbars.cached=e[0].offsetWidth==e[0].childNodes[0].offsetWidth,e.remove()}return this.floatingScrollbars.cached},forceFocus:function(t){var n=t[0]||t;document.addEventListener("click",function r(e){e.target===n&&e.$focus&&(n.focus(),e.stopImmediatePropagation(),e.preventDefault(),n.removeEventListener("click",r))},!0);var o=document.createEvent("MouseEvents");o.initMouseEvent("click",!1,!0,e,{},0,0,0,0,!1,!1,!1,!1,0,null),o.$material=!0,o.$focus=!0,n.dispatchEvent(o)},createBackdrop:function(e,t){return c(h.supplant('<md-backdrop class="{0}">',[t]))(e)},supplant:function(e,t,n){return n=n||/\{([^\{\}]*)\}/g,e.replace(n,function(e,n){var o=n.split("."),r=t;try{for(var i in o)r=r[o[i]]}catch(a){r=e}return"string"==typeof r||"number"==typeof r?r:e})},fakeNgModel:function(){return{$fake:!0,$setTouched:t.noop,$setViewValue:function(e){this.$viewValue=e,this.$render(e),this.$viewChangeListeners.forEach(function(e){e()})},$isEmpty:function(e){return 0===(""+e).length},$parsers:[],$formatters:[],$viewChangeListeners:[],$render:t.noop}},debounce:function(e,t,o,r){var i;return function(){var d=o,c=Array.prototype.slice.call(arguments);a.cancel(i),i=a(function(){i=n,e.apply(d,c)},t||10,r)}},throttle:function(e,t){var n;return function(){var o=this,r=arguments,i=h.now();(!n||i-n>t)&&(e.apply(o,r),n=i)}},time:function(e){var t=h.now();return e(),h.now()-t},nextUid:function(){return""+o++},disconnectScope:function(e){if(e&&e.$root!==e&&!e.$$destroyed){var t=e.$parent;e.$$disconnected=!0,t.$$childHead===e&&(t.$$childHead=e.$$nextSibling),t.$$childTail===e&&(t.$$childTail=e.$$prevSibling),e.$$prevSibling&&(e.$$prevSibling.$$nextSibling=e.$$nextSibling),e.$$nextSibling&&(e.$$nextSibling.$$prevSibling=e.$$prevSibling),e.$$nextSibling=e.$$prevSibling=null}},reconnectScope:function(e){if(e&&e.$root!==e&&e.$$disconnected){var t=e,n=t.$parent;t.$$disconnected=!1,t.$$prevSibling=n.$$childTail,n.$$childHead?(n.$$childTail.$$nextSibling=t,n.$$childTail=t):n.$$childHead=n.$$childTail=t}},getClosest:function(e,n,o){if(e instanceof t.element&&(e=e[0]),n=n.toUpperCase(),o&&(e=e.parentNode),!e)return null;do if(e.nodeName===n)return e;while(e=e.parentNode);return null},extractElementByName:function(e,n){for(var o=0,r=e.length;r>o;o++)if(e[o].nodeName.toLowerCase()===n)return t.element(e[o]);return e},initOptionalProperties:function(e,n,o){o=o||{},t.forEach(e.$$isolateBindings,function(r,i){if(r.optional&&t.isUndefined(e[i])){var a=t.isDefined(n[r.attrName]);e[i]=t.isDefined(o[i])?o[i]:a}})},nextTick:function(e,t){function n(){var e=o.queue,t=o.digest;o.queue=[],o.timeout=null,o.digest=!1,e.forEach(function(e){e()}),t&&u.$digest()}var o=h.nextTick,r=o.timeout,i=o.queue||[];return i.push(e),null==t&&(t=!0),o.digest=o.digest||t,o.queue=i,r||(o.timeout=a(n,0,!1))}};return h.dom.animator=p(h),h}]),t.element.prototype.focus=t.element.prototype.focus||function(){return this.length&&this[0].focus(),this},t.element.prototype.blur=t.element.prototype.blur||function(){return this.length&&this[0].blur(),this}}(),function(){function e(e,n,o){function r(e,o,r){var i=e[0]||e;!i||i.hasAttribute(o)&&0!==i.getAttribute(o).length||c(i,o)||(r=t.isString(r)?r.trim():"",r.length?e.attr(o,r):n.warn('ARIA: Attribute "',o,'", required for accessibility, is missing on node:',i))}function i(t,n,o){e(function(){r(t,n,o())})}function a(e,t){i(e,t,function(){return d(e)})}function d(e){return e.text().trim()}function c(e,t){function n(e){var t=e.currentStyle?e.currentStyle:o.getComputedStyle(e);return"none"===t.display}var r=e.hasChildNodes(),i=!1;if(r)for(var a=e.childNodes,d=0;d<a.length;d++){var c=a[d];1===c.nodeType&&c.hasAttribute(t)&&(n(c)||(i=!0))}return i}return{expect:r,expectAsync:i,expectWithText:a}}t.module("material.core").service("$mdAria",e),e.$inject=["$$rAF","$log","$window"]}(),function(){function e(e,n,o,r,i,a){this.compile=function(d){var c=d.templateUrl,l=d.template||"",m=d.controller,s=d.controllerAs,u=t.extend({},d.resolve||{}),p=t.extend({},d.locals||{}),f=d.transformTemplate||t.identity,h=d.bindToController;return t.forEach(u,function(e,n){u[n]=t.isString(e)?o.get(e):o.invoke(e)}),t.extend(u,p),u.$template=c?n.get(c,{cache:a}).then(function(e){return e.data}):e.when(l),e.all(u).then(function(e){var n=f(e.$template),o=d.element||t.element("<div>").html(n.trim()).contents(),a=r(o);return{locals:e,element:o,link:function(n){if(e.$scope=n,m){var r=i(m,e,!0);h&&t.extend(r.instance,e);var d=r();o.data("$ngControllerController",d),o.children().data("$ngControllerController",d),s&&(n[s]=d)}return a(n)}}})}}t.module("material.core").service("$mdCompiler",e),e.$inject=["$q","$http","$injector","$compile","$controller","$templateCache"]}(),function(){function n(){}function o(n,o,r){function i(e,t,n){var o=p[t.replace(/^\$md./,"")];if(!o)throw new Error("Failed to register element with handler "+t+". Available handlers: "+Object.keys(p).join(", "));return o.registerElement(e,n)}function a(e,o){var r=new n(e);return t.extend(r,o),p[e]=r,h}var c=navigator.userAgent||navigator.vendor||e.opera,m=c.match(/ipad|iphone|ipod/i),s=c.match(/android/i),u="undefined"!=typeof e.jQuery&&t.element===e.jQuery,h={handler:a,register:i,isHijackingClicks:(m||s)&&!u&&!f};return h.isHijackingClicks&&h.handler("click",{options:{maxDistance:6},onEnd:function(e,t){t.distance<this.state.options.maxDistance&&this.dispatchEvent(e,"click")}}),h.handler("press",{onStart:function(e,t){this.dispatchEvent(e,"$md.pressdown")},onEnd:function(e,t){this.dispatchEvent(e,"$md.pressup")}}).handler("hold",{options:{maxDistance:6,delay:500},onCancel:function(){r.cancel(this.state.timeout)},onStart:function(e,n){return this.state.registeredParent?(this.state.pos={x:n.x,y:n.y},void(this.state.timeout=r(t.bind(this,function(){this.dispatchEvent(e,"$md.hold"),this.cancel()}),this.state.options.delay,!1))):this.cancel()},onMove:function(e,t){e.preventDefault();var n=this.state.pos.x-t.x,o=this.state.pos.y-t.y;Math.sqrt(n*n+o*o)>this.options.maxDistance&&this.cancel()},onEnd:function(){this.onCancel()}}).handler("drag",{options:{minDistance:6,horizontal:!0,cancelMultiplier:1.5},onStart:function(e){this.state.registeredParent||this.cancel()},onMove:function(e,t){var n,o;e.preventDefault(),this.state.dragPointer?this.dispatchDragMove(e):(this.state.options.horizontal?(n=Math.abs(t.distanceX)>this.state.options.minDistance,o=Math.abs(t.distanceY)>this.state.options.minDistance*this.state.options.cancelMultiplier):(n=Math.abs(t.distanceY)>this.state.options.minDistance,o=Math.abs(t.distanceX)>this.state.options.minDistance*this.state.options.cancelMultiplier),n?(this.state.dragPointer=d(e),l(e,this.state.dragPointer),this.dispatchEvent(e,"$md.dragstart",this.state.dragPointer)):o&&this.cancel())},dispatchDragMove:o.throttle(function(e){this.state.isRunning&&(l(e,this.state.dragPointer),this.dispatchEvent(e,"$md.drag",this.state.dragPointer))}),onEnd:function(e,t){this.state.dragPointer&&(l(e,this.state.dragPointer),this.dispatchEvent(e,"$md.dragend",this.state.dragPointer))}}).handler("swipe",{options:{minVelocity:.65,minDistance:10},onEnd:function(e,t){if(Math.abs(t.velocityX)>this.state.options.minVelocity&&Math.abs(t.distanceX)>this.state.options.minDistance){var n="left"==t.directionX?"$md.swipeleft":"$md.swiperight";this.dispatchEvent(e,n)}}})}function r(e){this.name=e,this.state={}}function i(){function n(e,n,o){o=o||s;var r=new t.element.Event(n);r.$material=!0,r.pointer=o,r.srcEvent=e,t.extend(r,{clientX:o.x,clientY:o.y,screenX:o.x,screenY:o.y,pageX:o.x,pageY:o.y,ctrlKey:e.ctrlKey,altKey:e.altKey,shiftKey:e.shiftKey,metaKey:e.metaKey}),t.element(o.target).trigger(r)}function o(t,n,o){o=o||s;var r;"click"===n?(r=document.createEvent("MouseEvents"),r.initMouseEvent("click",!0,!0,e,t.detail,o.x,o.y,o.x,o.y,t.ctrlKey,t.altKey,t.shiftKey,t.metaKey,t.button,t.relatedTarget||null)):(r=document.createEvent("CustomEvent"),r.initCustomEvent(n,!0,!0,{})),r.$material=!0,r.pointer=o,r.srcEvent=t,o.target.dispatchEvent(r)}var i="undefined"!=typeof e.jQuery&&t.element===e.jQuery;return r.prototype={options:{},dispatchEvent:i?n:o,onStart:t.noop,onMove:t.noop,onEnd:t.noop,onCancel:t.noop,start:function(e,n){if(!this.state.isRunning){var o=this.getNearestParent(e.target),r=o&&o.$mdGesture[this.name]||{};this.state={isRunning:!0,options:t.extend({},this.options,r),registeredParent:o},this.onStart(e,n)}},move:function(e,t){this.state.isRunning&&this.onMove(e,t)},end:function(e,t){this.state.isRunning&&(this.onEnd(e,t),this.state.isRunning=!1)},cancel:function(e,t){this.onCancel(e,t),this.state={}},getNearestParent:function(e){for(var t=e;t;){if((t.$mdGesture||{})[this.name])return t;t=t.parentNode}return null},registerElement:function(e,t){function n(){delete e[0].$mdGesture[o.name],e.off("$destroy",n)}var o=this;return e[0].$mdGesture=e[0].$mdGesture||{},e[0].$mdGesture[this.name]=t||{},e.on("$destroy",n),n}},r}function a(e,n){function o(e,t){var o;for(var r in p)o=p[r],o instanceof n&&("start"===e&&o.cancel(),o[e](t,s))}function r(e){if(!s){var t=+Date.now();u&&!c(e,u)&&t-u.endTime<1500||(s=d(e),o("start",e))}}function i(e){s&&c(e,s)&&(l(e,s),o("move",e))}function a(e){s&&c(e,s)&&(l(e,s),s.endTime=+Date.now(),o("end",e),u=s,s=null)}document.contains||(document.contains=function(e){return document.body.contains(e)}),!h&&e.isHijackingClicks&&(document.addEventListener("click",function(e){var t=0===e.clientX&&0===e.clientY;t||e.$material||e.isIonicTap||(e.preventDefault(),e.stopPropagation())},!0),h=!0);var m="mousedown touchstart pointerdown",f="mousemove touchmove pointermove",b="mouseup mouseleave touchend touchcancel pointerup pointercancel";t.element(document).on(m,r).on(f,i).on(b,a).on("$$mdGestureReset",function(){u=s=null})}function d(e){var t=m(e),n={startTime:+Date.now(),target:e.target,type:e.type.charAt(0)};return n.startX=n.x=t.pageX,n.startY=n.y=t.pageY,n}function c(e,t){return e&&t&&e.type.charAt(0)===t.type}function l(e,t){var n=m(e),o=t.x=n.pageX,r=t.y=n.pageY;t.distanceX=o-t.startX,t.distanceY=r-t.startY,t.distance=Math.sqrt(t.distanceX*t.distanceX+t.distanceY*t.distanceY),t.directionX=t.distanceX>0?"right":t.distanceX<0?"left":"",t.directionY=t.distanceY>0?"up":t.distanceY<0?"down":"",t.duration=+Date.now()-t.startTime,t.velocityX=t.distanceX/t.duration,t.velocityY=t.distanceY/t.duration}function m(e){return e=e.originalEvent||e,e.touches&&e.touches[0]||e.changedTouches&&e.changedTouches[0]||e}var s,u,p={},f=!1,h=!1;t.module("material.core.gestures",[]).provider("$mdGesture",n).factory("$$MdGestureHandler",i).run(a),n.prototype={skipClickHijack:function(){return f=!0},$get:["$$MdGestureHandler","$$rAF","$timeout",function(e,t,n){return new o(e,t,n)}]},o.$inject=["$$MdGestureHandler","$$rAF","$timeout"],a.$inject=["$mdGesture","$$MdGestureHandler"]}(),function(){function e(){function e(e){function n(e){return c.optionsFactory=e.options,c.methods=(e.methods||[]).concat(a),l}function o(e,t){return d[e]=t,l}function r(t,n){if(n=n||{},n.methods=n.methods||[],n.options=n.options||function(){return{}},/^cancel|hide|show$/.test(t))throw new Error("Preset '"+t+"' in "+e+" is reserved!");if(n.methods.indexOf("_options")>-1)throw new Error("Method '_options' in "+e+" is reserved!");return c.presets[t]={methods:n.methods.concat(a),optionsFactory:n.options,argOption:n.argOption},l}function i(n,o){function r(e){return e=e||{},e._options&&(e=e._options),m.show(t.extend({},l,e))}function i(t,n){var r={};return r[e]=s,o.invoke(t||function(){return n},{},r)}var a,l,m=n(),s={hide:m.hide,cancel:m.cancel,show:r};return a=c.methods||[],l=i(c.optionsFactory,{}),t.forEach(d,function(e,t){s[t]=e}),t.forEach(c.presets,function(e,n){function o(e){this._options=t.extend({},r,e)}var r=i(e.optionsFactory,{}),d=(e.methods||[]).concat(a);if(t.extend(r,{$type:n}),t.forEach(d,function(e){o.prototype[e]=function(t){return this._options[e]=t,this}}),e.argOption){var c="show"+n.charAt(0).toUpperCase()+n.slice(1);s[c]=function(e){var t=s[n](e);return s.show(t)}}s[n]=function(n){return arguments.length&&e.argOption&&!t.isObject(n)&&!t.isArray(n)?(new o)[e.argOption](n):new o(n)}}),s}var a=["onHide","onShow","onRemove"],d={},c={presets:{}},l={setDefaults:n,addPreset:r,addMethod:o,$get:i};return l.addPreset("build",{methods:["controller","controllerAs","resolve","template","templateUrl","themable","transformTemplate","parent"]}),i.$inject=["$$interimElement","$injector"],l}function o(e,o,r,i,a,d,c,l,m,s){function u(e){return e&&t.isString(e)?e.replace(/\{\{/g,p).replace(/}}/g,f):e}var p=c.startSymbol(),f=c.endSymbol(),h="{{"===p&&"}}"===f,b=h?t.identity:u;return function(){function c(e){var t=new p(e),n=E.length?f.hide():o.when(!0);return n["finally"](function(){E.push(t),t.show()["catch"](function(e){})}),t.deferred.promise}function s(e){var t=E.shift();return t?(t.remove(e||g,!1)["catch"](function(e){}),t.deferred.promise):o.when(e)}function u(e){var t=E.shift();return t?(t.remove(e||h,!0)["catch"](function(e){}),t.deferred.promise):o.when(e)}function p(c){function s(){return o(function(e,t){function n(e){A.deferred.reject(e),t(e)}h(c).then(function(t){T=g(t,c),C=M(T,c).then(e,n)})})}function u(e,t){return c.cancelAutoHide&&c.cancelAutoHide(),o(function(n,r){function i(){A.deferred.resolve(e),n(e)}function a(e){A.deferred.reject(e),r(e)}o.when(C)["finally"](function(){$(c.element,c).then(function(){t&&a(e)||i()},a)})})}function p(e){return e=e||{},e.template&&(e.template=b(e.template)),t.extend({preserveScope:!1,cancelAutoHide:t.noop,scope:e.scope||r.$new(e.isolateScope),onShow:function(e,t,n){return d.enter(t,n.parent)},onRemove:function(e,t){return t&&d.leave(t)||o.when()}},e)}function h(e){var t=e.skipCompile?null:l.compile(e);return t||o(function(t){t({locals:{},link:function(){return e.element}})})}function g(e,n){t.extend(e.locals,n);var o=e.link(n.scope);return n.element=o,n.parent=E(o,n),n.themable&&m(o),o}function E(n,o){var r=o.parent;if(r=t.isFunction(r)?r(o.scope,n,o):t.element(t.isString(r)?e[0].querySelector(r):r),!(r||{}).length){var i;return a[0]&&a[0].querySelector&&(i=a[0].querySelector(":not(svg) > body")),i||(i=a[0]),"#comment"==i.nodeName&&(i=e[0].body),t.element(i)}return r}function v(){var e,o=t.noop;c.hideDelay&&(e=i(f.hide,c.hideDelay),o=function(){i.cancel(e)}),c.cancelAutoHide=function(){o(),c.cancelAutoHide=n}}function M(e,n){var r=n.onComplete||t.noop;return o(function(t,i){try{o.when(n.onShow(n.scope,e,n)).then(function(){r(n.scope,e,n),v(),t(e)},i)}catch(a){i(a.message)}})}function $(e,n){var r=n.onRemoving||t.noop;return o(function(t,i){try{var a=o.when(e?n.onRemove(n.scope,e,n):!0);r(e,a),a.then(function(){!n.preserveScope&&n.scope.$destroy(),t(e)},i)}catch(d){i(d.message)}})}var A,T,C=o.when(!0);return c=p(c),A={options:c,deferred:o.defer(),show:s,remove:u}}var f,h=!1,g=!0,E=[];return f={show:c,hide:s,cancel:u}}}return e.$get=o,o.$inject=["$document","$q","$rootScope","$timeout","$rootElement","$animate","$interpolate","$mdCompiler","$mdTheming","$log"],e}t.module("material.core").provider("$$interimElement",e)}(),function(){function e(e,n){function o(e){return e&&""!==e}var r,i=[],a={};return r={notFoundError:function(t){e.error("No instance found for handle",t)},getInstances:function(){return i},get:function(e){if(!o(e))return null;var t,n,r;for(t=0,n=i.length;n>t;t++)if(r=i[t],r.$$mdHandle===e)return r;return null},register:function(e,n){function o(){var t=i.indexOf(e);-1!==t&&i.splice(t,1)}function r(){var t=a[n];t&&(t.resolve(e),delete a[n])}return n?(e.$$mdHandle=n,i.push(e),r(),o):t.noop},when:function(e){if(o(e)){var t=n.defer(),i=r.get(e);return i?t.resolve(i):a[e]=t,t.promise}return n.reject("Invalid `md-component-id` value.")}}}t.module("material.core").factory("$mdComponentRegistry",e),e.$inject=["$log","$q"]}(),function(){t.module("material.core.theming.palette",[]).constant("$mdColorPalette",{red:{50:"#ffebee",100:"#ffcdd2",200:"#ef9a9a",300:"#e57373",400:"#ef5350",500:"#f44336",600:"#e53935",700:"#d32f2f",800:"#c62828",900:"#b71c1c",A100:"#ff8a80",A200:"#ff5252",A400:"#ff1744",A700:"#d50000",contrastDefaultColor:"light",contrastDarkColors:"50 100 200 300 400 A100",contrastStrongLightColors:"500 600 700 A200 A400 A700"},pink:{50:"#fce4ec",100:"#f8bbd0",200:"#f48fb1",300:"#f06292",400:"#ec407a",500:"#e91e63",600:"#d81b60",700:"#c2185b",800:"#ad1457",900:"#880e4f",A100:"#ff80ab",A200:"#ff4081",A400:"#f50057",A700:"#c51162",contrastDefaultColor:"light",contrastDarkColors:"50 100 200 300 400 A100",contrastStrongLightColors:"500 600 A200 A400 A700"},purple:{50:"#f3e5f5",100:"#e1bee7",200:"#ce93d8",300:"#ba68c8",400:"#ab47bc",500:"#9c27b0",600:"#8e24aa",700:"#7b1fa2",800:"#6a1b9a",900:"#4a148c",A100:"#ea80fc",A200:"#e040fb",A400:"#d500f9",A700:"#aa00ff",contrastDefaultColor:"light",contrastDarkColors:"50 100 200 A100",contrastStrongLightColors:"300 400 A200 A400 A700"},"deep-purple":{50:"#ede7f6",100:"#d1c4e9",200:"#b39ddb",300:"#9575cd",400:"#7e57c2",500:"#673ab7",600:"#5e35b1",700:"#512da8",800:"#4527a0",900:"#311b92",A100:"#b388ff",A200:"#7c4dff",A400:"#651fff",A700:"#6200ea",contrastDefaultColor:"light",contrastDarkColors:"50 100 200 A100",contrastStrongLightColors:"300 400 A200"},indigo:{50:"#e8eaf6",100:"#c5cae9",200:"#9fa8da",300:"#7986cb",400:"#5c6bc0",500:"#3f51b5",600:"#3949ab",700:"#303f9f",800:"#283593",900:"#1a237e",A100:"#8c9eff",A200:"#536dfe",A400:"#3d5afe",A700:"#304ffe",contrastDefaultColor:"light",contrastDarkColors:"50 100 200 A100",contrastStrongLightColors:"300 400 A200 A400"},blue:{50:"#e3f2fd",100:"#bbdefb",200:"#90caf9",300:"#64b5f6",400:"#42a5f5",500:"#2196f3",600:"#1e88e5",700:"#1976d2",800:"#1565c0",900:"#0d47a1",A100:"#82b1ff",A200:"#448aff",A400:"#2979ff",A700:"#2962ff",contrastDefaultColor:"light",contrastDarkColors:"100 200 300 400 A100",contrastStrongLightColors:"500 600 700 A200 A400 A700"},"light-blue":{50:"#e1f5fe",100:"#b3e5fc",200:"#81d4fa",300:"#4fc3f7",400:"#29b6f6",500:"#03a9f4",600:"#039be5",700:"#0288d1",800:"#0277bd",900:"#01579b",A100:"#80d8ff",A200:"#40c4ff",A400:"#00b0ff",A700:"#0091ea",contrastDefaultColor:"dark",contrastLightColors:"500 600 700 800 900 A700",contrastStrongLightColors:"500 600 700 800 A700"},cyan:{50:"#e0f7fa",100:"#b2ebf2",200:"#80deea",300:"#4dd0e1",400:"#26c6da",500:"#00bcd4",600:"#00acc1",700:"#0097a7",800:"#00838f",900:"#006064",A100:"#84ffff",A200:"#18ffff",A400:"#00e5ff",A700:"#00b8d4",contrastDefaultColor:"dark",contrastLightColors:"500 600 700 800 900",contrastStrongLightColors:"500 600 700 800"},teal:{50:"#e0f2f1",100:"#b2dfdb",200:"#80cbc4",300:"#4db6ac",400:"#26a69a",500:"#009688",600:"#00897b",700:"#00796b",800:"#00695c",900:"#004d40",A100:"#a7ffeb",A200:"#64ffda",A400:"#1de9b6",A700:"#00bfa5",contrastDefaultColor:"dark",contrastLightColors:"500 600 700 800 900",contrastStrongLightColors:"500 600 700"},green:{50:"#e8f5e9",100:"#c8e6c9",200:"#a5d6a7",300:"#81c784",400:"#66bb6a",500:"#4caf50",600:"#43a047",700:"#388e3c",800:"#2e7d32",900:"#1b5e20",A100:"#b9f6ca",A200:"#69f0ae",A400:"#00e676",A700:"#00c853",contrastDefaultColor:"dark",contrastLightColors:"500 600 700 800 900",contrastStrongLightColors:"500 600 700"},"light-green":{50:"#f1f8e9",100:"#dcedc8",200:"#c5e1a5",300:"#aed581",400:"#9ccc65",500:"#8bc34a",600:"#7cb342",700:"#689f38",800:"#558b2f",900:"#33691e",A100:"#ccff90",A200:"#b2ff59",A400:"#76ff03",A700:"#64dd17",contrastDefaultColor:"dark",contrastLightColors:"800 900",contrastStrongLightColors:"800 900"},lime:{50:"#f9fbe7",100:"#f0f4c3",200:"#e6ee9c",300:"#dce775",400:"#d4e157",500:"#cddc39",600:"#c0ca33",700:"#afb42b",800:"#9e9d24",900:"#827717",A100:"#f4ff81",A200:"#eeff41",A400:"#c6ff00",A700:"#aeea00",contrastDefaultColor:"dark",contrastLightColors:"900",contrastStrongLightColors:"900"},yellow:{50:"#fffde7",100:"#fff9c4",200:"#fff59d",300:"#fff176",400:"#ffee58",500:"#ffeb3b",600:"#fdd835",700:"#fbc02d",800:"#f9a825",900:"#f57f17",A100:"#ffff8d",A200:"#ffff00",A400:"#ffea00",A700:"#ffd600",contrastDefaultColor:"dark"},amber:{50:"#fff8e1",100:"#ffecb3",200:"#ffe082",300:"#ffd54f",400:"#ffca28",500:"#ffc107",600:"#ffb300",700:"#ffa000",800:"#ff8f00",900:"#ff6f00",A100:"#ffe57f",A200:"#ffd740",A400:"#ffc400",A700:"#ffab00",contrastDefaultColor:"dark"},orange:{50:"#fff3e0",100:"#ffe0b2",200:"#ffcc80",300:"#ffb74d",400:"#ffa726",500:"#ff9800",600:"#fb8c00",700:"#f57c00",800:"#ef6c00",900:"#e65100",A100:"#ffd180",A200:"#ffab40",A400:"#ff9100",A700:"#ff6d00",contrastDefaultColor:"dark",contrastLightColors:"800 900",contrastStrongLightColors:"800 900"},"deep-orange":{50:"#fbe9e7",100:"#ffccbc",200:"#ffab91",300:"#ff8a65",400:"#ff7043",500:"#ff5722",600:"#f4511e",700:"#e64a19",800:"#d84315",900:"#bf360c",A100:"#ff9e80",A200:"#ff6e40",A400:"#ff3d00",A700:"#dd2c00",contrastDefaultColor:"light",contrastDarkColors:"50 100 200 300 400 A100 A200",contrastStrongLightColors:"500 600 700 800 900 A400 A700"},brown:{50:"#efebe9",100:"#d7ccc8",200:"#bcaaa4",300:"#a1887f",400:"#8d6e63",500:"#795548",600:"#6d4c41",700:"#5d4037",800:"#4e342e",900:"#3e2723",A100:"#d7ccc8",A200:"#bcaaa4",A400:"#8d6e63",A700:"#5d4037",contrastDefaultColor:"light",contrastDarkColors:"50 100 200",contrastStrongLightColors:"300 400"},grey:{50:"#fafafa",100:"#f5f5f5",200:"#eeeeee",300:"#e0e0e0",400:"#bdbdbd",500:"#9e9e9e",600:"#757575",700:"#616161",800:"#424242",900:"#212121",1000:"#000000",A100:"#ffffff",A200:"#eeeeee",A400:"#bdbdbd",A700:"#616161",contrastDefaultColor:"dark",contrastLightColors:"600 700 800 900"},"blue-grey":{50:"#eceff1",100:"#cfd8dc",200:"#b0bec5",300:"#90a4ae",400:"#78909c",500:"#607d8b",600:"#546e7a",700:"#455a64",800:"#37474f",900:"#263238",A100:"#cfd8dc",A200:"#b0bec5",A400:"#78909c",A700:"#455a64",contrastDefaultColor:"light",contrastDarkColors:"50 100 200 300",contrastStrongLightColors:"400 500"}})}(),function(){function e(e){function o(e,t){return t=t||{},m[e]=a(e,t),g}function r(e,n){return a(e,t.extend({},m[e]||{},n))}function a(e,t){var n=C.filter(function(e){return!t[e]});if(n.length)throw new Error("Missing colors %1 in palette %2!".replace("%1",n.join(", ")).replace("%2",e));return t}function d(e,n){if(s[e])return s[e];n=n||"default";var o="string"==typeof n?s[n]:n,r=new c(e);return o&&t.forEach(o.colors,function(e,n){r.colors[n]={name:e.name,hues:t.extend({},e.hues)}}),s[e]=r,r}function c(e){function n(e){if(e=0===arguments.length?!0:!!e,e!==o.isDark){o.isDark=e,o.foregroundPalette=o.isDark?f:p,o.foregroundShadow=o.isDark?h:b;var n=o.isDark?T:A,r=o.isDark?A:T;return t.forEach(n,function(e,t){var n=o.colors[t],i=r[t];if(n)for(var a in n.hues)n.hues[a]===i[a]&&(n.hues[a]=e[a])}),o}}var o=this;o.name=e,o.colors={},o.dark=n,n(!1),M.forEach(function(e){var n=(o.isDark?T:A)[e];o[e+"Palette"]=function(r,i){var a=o.colors[e]={name:r,hues:t.extend({},n,i)
};return Object.keys(a.hues).forEach(function(e){if(!n[e])throw new Error("Invalid hue name '%1' in theme %2's %3 color %4. Available hue names: %4".replace("%1",e).replace("%2",o.name).replace("%3",r).replace("%4",Object.keys(n).join(", ")))}),Object.keys(a.hues).map(function(e){return a.hues[e]}).forEach(function(t){if(-1==C.indexOf(t))throw new Error("Invalid hue value '%1' in theme %2's %3 color %4. Available hue values: %5".replace("%1",t).replace("%2",o.name).replace("%3",e).replace("%4",r).replace("%5",C.join(", ")))}),o},o[e+"Color"]=function(){var t=Array.prototype.slice.call(arguments);return console.warn("$mdThemingProviderTheme."+e+"Color() has been deprecated. Use $mdThemingProviderTheme."+e+"Palette() instead."),o[e+"Palette"].apply(o,t)}})}function u(e,o){function r(e){return e===n||""===e?!0:i.THEMES[e]!==n}function i(t,o){o===n&&(o=t,t=n),t===n&&(t=e),i.inherit(o,o)}return i.inherit=function(n,i){function a(e){r(e)||o.warn("Attempted to use unregistered theme '"+e+"'. Register it with $mdThemingProvider.theme().");var t=n.data("$mdThemeName");t&&n.removeClass("md-"+t+"-theme"),n.addClass("md-"+e+"-theme"),n.data("$mdThemeName",e),d&&n.data("$mdThemeController",d)}var d=i.controller("mdTheme"),c=n.attr("md-theme-watch");if((v||t.isDefined(c))&&"false"!=c){var l=e.$watch(function(){return d&&d.$mdTheme||E},a);n.on("$destroy",l)}else{var m=d&&d.$mdTheme||E;a(m)}},i.THEMES=t.extend({},s),i.defaultTheme=function(){return E},i.registered=r,i}m={},s={};var g,E="default",v=!1;return t.extend(m,e),u.$inject=["$rootScope","$log"],g={definePalette:o,extendPalette:r,theme:d,setDefaultTheme:function(e){E=e},alwaysWatchTheme:function(e){v=e},$get:u,_LIGHT_DEFAULT_HUES:A,_DARK_DEFAULT_HUES:T,_PALETTES:m,_THEMES:s,_parseRules:i,_rgba:l}}function o(e,t,n){return{priority:100,link:{pre:function(o,r,i){var a={$setTheme:function(t){e.registered(t)||n.warn("attempted to use unregistered theme '"+t+"'"),a.$mdTheme=t}};r.data("$mdThemeController",a),a.$setTheme(t(i.mdTheme)(o)),i.$observe("mdTheme",a.$setTheme)}}}}function r(e){return e}function i(e,n,o){d(e,n),o=o.replace(/THEME_NAME/g,e.name);var r=[],i=e.colors[n],a=new RegExp(".md-"+e.name+"-theme","g"),c=new RegExp("('|\")?{{\\s*("+n+")-(color|contrast)-?(\\d\\.?\\d*)?\\s*}}(\"|')?","g"),s=/'?"?\{\{\s*([a-zA-Z]+)-(A?\d+|hue\-[0-3]|shadow)-?(\d\.?\d*)?\s*\}\}'?"?/g,u=m[i.name];return o=o.replace(s,function(t,n,o,r){return"foreground"===n?"shadow"==o?e.foregroundShadow:e.foregroundPalette[o]||e.foregroundPalette[1]:(0===o.indexOf("hue")&&(o=e.colors[n].hues[o]),l((m[e.colors[n].name][o]||"").value,r))}),t.forEach(i.hues,function(t,n){var i=o.replace(c,function(e,n,o,r,i){return l(u[t]["color"===r?"value":"contrast"],i)});"default"!==n&&(i=i.replace(a,".md-"+e.name+"-theme.md-"+n)),"default"==e.name&&(i=i.replace(/\.md-default-theme/g,"")),r.push(i)}),r}function a(e){function n(e){var n=e.contrastDefaultColor,o=e.contrastLightColors||[],r=e.contrastStrongLightColors||[],i=e.contrastDarkColors||[];"string"==typeof o&&(o=o.split(" ")),"string"==typeof r&&(r=r.split(" ")),"string"==typeof i&&(i=i.split(" ")),delete e.contrastDefaultColor,delete e.contrastLightColors,delete e.contrastStrongLightColors,delete e.contrastDarkColors,t.forEach(e,function(a,d){function l(){return"light"===n?i.indexOf(d)>-1?g:r.indexOf(d)>-1?v:E:o.indexOf(d)>-1?r.indexOf(d)>-1?v:E:g}if(!t.isObject(a)){var m=c(a);if(!m)throw new Error("Color %1, in palette %2's hue %3, is invalid. Hex or rgb(a) color expected.".replace("%1",a).replace("%2",e.name).replace("%3",d));e[d]={value:m,contrast:l()}}})}var o=document.getElementsByTagName("head")[0],r=o?o.firstElementChild:null,a=e.has("$MD_THEME_CSS")?e.get("$MD_THEME_CSS"):"";if(r&&0!==a.length){t.forEach(m,n);var d={},l=a.split(/\}(?!(\}|'|"|;))/).filter(function(e){return e&&e.length}).map(function(e){return e.trim()+"}"}),p=new RegExp("md-("+M.join("|")+")","g");M.forEach(function(e){d[e]=""}),l.forEach(function(e){for(var t,n=(e.match(p),0);t=M[n];n++)if(e.indexOf(".md-"+t)>-1)return d[t]+=e;for(n=0;t=M[n];n++)if(e.indexOf(t)>-1)return d[t]+=e;return d[$]+=e}),t.forEach(s,function(e){u[e.name]||(M.forEach(function(t){for(var n=i(e,t,d[t]);n.length;){var a=document.createElement("style");a.setAttribute("type","text/css"),a.appendChild(document.createTextNode(n.shift())),o.insertBefore(a,r)}}),e.colors.primary.name==e.colors.accent.name&&console.warn("$mdThemingProvider: Using the same palette for primary and accent. This violates the material design spec."),u[e.name]=!0)})}}function d(e,t){if(!m[(e.colors[t]||{}).name])throw new Error("You supplied an invalid color palette for theme %1's %2 palette. Available palettes: %3".replace("%1",e.name).replace("%2",t).replace("%3",Object.keys(m).join(", ")))}function c(e){if(t.isArray(e)&&3==e.length)return e;if(/^rgb/.test(e))return e.replace(/(^\s*rgba?\(|\)\s*$)/g,"").split(",").map(function(e,t){return 3==t?parseFloat(e,10):parseInt(e,10)});if("#"==e.charAt(0)&&(e=e.substring(1)),/^([a-fA-F0-9]{3}){1,2}$/g.test(e)){var n=e.length/3,o=e.substr(0,n),r=e.substr(n,n),i=e.substr(2*n);return 1===n&&(o+=o,r+=r,i+=i),[parseInt(o,16),parseInt(r,16),parseInt(i,16)]}}function l(e,n){return e?(4==e.length&&(e=t.copy(e),n?e.pop():n=e.pop()),n&&("number"==typeof n||"string"==typeof n&&n.length)?"rgba("+e.join(",")+","+n+")":"rgb("+e.join(",")+")"):"rgb('0,0,0')"}t.module("material.core.theming",["material.core.theming.palette"]).directive("mdTheme",o).directive("mdThemable",r).provider("$mdTheming",e).run(a);var m,s,u={},p={name:"dark",1:"rgba(0,0,0,0.87)",2:"rgba(0,0,0,0.54)",3:"rgba(0,0,0,0.26)",4:"rgba(0,0,0,0.12)"},f={name:"light",1:"rgba(255,255,255,1.0)",2:"rgba(255,255,255,0.7)",3:"rgba(255,255,255,0.3)",4:"rgba(255,255,255,0.12)"},h="1px 1px 0px rgba(0,0,0,0.4), -1px -1px 0px rgba(0,0,0,0.4)",b="",g=c("rgba(0,0,0,0.87)"),E=c("rgba(255,255,255,0.87"),v=c("rgb(255,255,255)"),M=["primary","accent","warn","background"],$="primary",A={accent:{"default":"A200","hue-1":"A100","hue-2":"A400","hue-3":"A700"},background:{"default":"A100","hue-1":"300","hue-2":"800","hue-3":"900"}},T={background:{"default":"800","hue-1":"300","hue-2":"600","hue-3":"900"}};M.forEach(function(e){var t={"default":"500","hue-1":"300","hue-2":"800","hue-3":"A100"};A[e]||(A[e]=t),T[e]||(T[e]=t)});var C=["50","100","200","300","400","500","600","700","800","900","A100","A200","A400","A700"];e.$inject=["$mdColorPalette"],o.$inject=["$mdTheming","$interpolate","$log"],r.$inject=["$mdTheming"],a.$inject=["$injector"]}(),function(){!function(){function e(e){function n(n,r,i){var a=o(r);return e.attach(n,r,t.extend(a,i))}function o(e){return e.hasClass("md-icon-button")?{isMenuItem:e.hasClass("md-menu-item"),fitRipple:!0,center:!0}:{isMenuItem:e.hasClass("md-menu-item"),dimBackground:!0}}return{attach:n}}t.module("material.core").factory("$mdButtonInkRipple",e),e.$inject=["$mdInkRipple"]}()}(),function(){!function(){function e(e){function n(n,o,r){return e.attach(n,o,t.extend({center:!0,dimBackground:!1,fitRipple:!0},r))}return{attach:n}}t.module("material.core").factory("$mdCheckboxInkRipple",e),e.$inject=["$mdInkRipple"]}()}(),function(){!function(){function e(e){function n(n,o,r){return e.attach(n,o,t.extend({center:!1,dimBackground:!0,outline:!1,rippleSize:"full"},r))}return{attach:n}}t.module("material.core").factory("$mdListInkRipple",e),e.$inject=["$mdInkRipple"]}()}(),function(){function e(e,n){return{controller:t.noop,link:function(t,o,r){r.hasOwnProperty("mdInkRippleCheckbox")?n.attach(t,o):e.attach(t,o)}}}function n(e,n,o){function r(r,i,a){function d(){var e=i.data("$mdRippleContainer");return e?e:(e=t.element('<div class="md-ripple-container">'),i.append(e),i.data("$mdRippleContainer",e),e)}function c(e){function t(e){var t="#"===e.charAt(0)?e.substr(1):e,n=t.length/3,o=t.substr(0,n),r=t.substr(n,n),i=t.substr(2*n);return 1===n&&(o+=o,r+=r,i+=i),"rgba("+parseInt(o,16)+","+parseInt(r,16)+","+parseInt(i,16)+",0.1)"}function n(e){return e.replace(")",", 0.1)").replace("(","a(")}if(e)return 0===e.indexOf("rgba")?e.replace(/\d?\.?\d*\s*\)\s*$/,"0.1)"):0===e.indexOf("rgb")?n(e):0===e.indexOf("#")?t(e):void 0}function l(e,t){E.splice(E.indexOf(e),1),0===E.length&&d().css({backgroundColor:""}),n(function(){e.remove()},t,!1)}function m(e){var t=E.indexOf(e),n=v[t]||{},o=E.length>1?!1:$,r=E.length>1?!1:A;o||n.animating||r?e.addClass("md-ripple-visible"):e&&(e.removeClass("md-ripple-visible"),a.outline&&e.css({width:h+"px",height:h+"px",marginLeft:-1*h+"px",marginTop:-1*h+"px"}),l(e,a.outline?450:650))}function s(r,l){function s(e){var n=t.element('<div class="md-ripple" data-counter="'+g++ +'">');return E.unshift(n),v.unshift({animating:!0}),f.append(n),e&&n.css(e),n}function u(e,t){var n,o,r,i=f.prop("offsetWidth"),d=f.prop("offsetHeight");return a.isMenuItem?o=Math.sqrt(Math.pow(i,2)+Math.pow(d,2)):a.outline?(r=T.getBoundingClientRect(),e-=r.left,t-=r.top,i=Math.max(e,i-e),d=Math.max(t,d-t),o=2*Math.sqrt(Math.pow(i,2)+Math.pow(d,2))):(n=a.fullRipple?1.1:.8,o=Math.sqrt(Math.pow(i,2)+Math.pow(d,2))*n,a.fitRipple&&(o=Math.min(d,i,o))),o}function p(e,t,n){function o(e){return e.replace("rgba","rgb").replace(/,[^\),]+\)/,")")}var r=T.getBoundingClientRect(),i={backgroundColor:o(y),borderColor:o(y),width:e+"px",height:e+"px"};return a.outline?(i.width=0,i.height=0):i.marginLeft=i.marginTop=e*-.5+"px",a.center?i.left=i.top="50%":(i.left=Math.round((t-r.left)/f.prop("offsetWidth")*100)+"%",i.top=Math.round((n-r.top)/f.prop("offsetHeight")*100)+"%"),i}y=c(i.attr("md-ink-ripple"))||c(e.getComputedStyle(a.colorElement[0]).color||"rgb(0, 0, 0)");var f=d(),b=u(r,l),M=p(b,r,l),$=s(M),A=E.indexOf($),C=v[A]||{};return h=b,C.animating=!0,o.nextTick(function(){a.dimBackground&&f.css({backgroundColor:y}),$.addClass("md-ripple-placed md-ripple-scaled"),$.css(a.outline?{borderWidth:.5*b+"px",marginLeft:b*-.5+"px",marginTop:b*-.5+"px"}:{left:"50%",top:"50%"}),m($),n(function(){C.animating=!1,m($)},a.outline?450:225,!1)}),$}function u(e){f()&&(s(e.pointer.x,e.pointer.y),A=!0)}function p(){A=!1;var e=E[E.length-1];o.nextTick(function(){m(e)})}function f(){function e(e){return e&&e.hasAttribute&&e.hasAttribute("disabled")}var t=T.parentNode,n=t&&t.parentNode,o=n&&n.parentNode;return!(e(T)||e(t)||e(n)||e(o))}if(i.controller("mdNoInk"))return t.noop;a=t.extend({colorElement:i,mousedown:!0,hover:!0,focus:!0,center:!1,mousedownPauseTime:150,dimBackground:!1,outline:!1,fullRipple:!0,isMenuItem:!1,fitRipple:!1},a);var h,b=i.controller("mdInkRipple")||{},g=0,E=[],v=[],M=i.attr("md-highlight"),$=!1,A=!1,T=i[0],C=i.attr("md-ripple-size"),y=c(i.attr("md-ink-ripple"))||c(a.colorElement.length&&e.getComputedStyle(a.colorElement[0]).color||"rgb(0, 0, 0)");switch(C){case"full":a.fullRipple=!0;break;case"partial":a.fullRipple=!1}return a.mousedown&&i.on("$md.pressdown",u).on("$md.pressup",p),b.createRipple=s,M&&r.$watch(M,function(e){$=e,$&&!E.length&&o.nextTick(function(){s(0,0)}),t.forEach(E,m)}),function(){i.off("$md.pressdown",u).off("$md.pressup",p),d().remove()}}return{attach:r}}function o(){return function(){return{controller:t.noop}}}t.module("material.core").factory("$mdInkRipple",n).directive("mdInkRipple",e).directive("mdNoInk",o()).directive("mdNoBar",o()).directive("mdNoStretch",o()),e.$inject=["$mdButtonInkRipple","$mdCheckboxInkRipple"],n.$inject=["$window","$timeout","$mdUtil"]}(),function(){!function(){function e(e){function n(n,o,r){return e.attach(n,o,t.extend({center:!1,dimBackground:!0,outline:!1,rippleSize:"full"},r))}return{attach:n}}t.module("material.core").factory("$mdTabInkRipple",e),e.$inject=["$mdInkRipple"]}()}(),function(){t.module("material.components.backdrop",["material.core"]).directive("mdBackdrop",["$mdTheming","$animate","$rootElement","$window","$log","$$rAF","$document",function(e,t,n,o,r,i,a){function d(d,l,m){var s=o.getComputedStyle(a[0].body);if("fixed"==s.position){var u=parseInt(s.height,10)+Math.abs(parseInt(s.top,10));l.css({height:u+"px"})}t.pin&&t.pin(l,n),i(function(){var t=l.parent()[0];if(t){var n=o.getComputedStyle(t);"static"==n.position&&r.warn(c)}e.inherit(l,l.parent())})}var c="<md-backdrop> may not work properly in a scrolled, static-positioned parent container.";return{restrict:"E",link:d}}])}(),function(){t.module("material.components.autocomplete",["material.core","material.components.icon"])}(),function(){function e(e,n,o,r){function i(e){return t.isDefined(e.href)||t.isDefined(e.ngHref)||t.isDefined(e.ngLink)||t.isDefined(e.uiSref)}function a(e,t){return i(t)?'<a class="md-button" ng-transclude></a>':'<button class="md-button" ng-transclude></button>'}function d(a,d,c){var l=d[0];n(d),e.attach(a,d);var m=l.textContent.trim();m||o.expect(d,"aria-label"),i(c)&&t.isDefined(c.ngDisabled)&&a.$watch(c.ngDisabled,function(e){d.attr("tabindex",e?-1:0)}),d.on("click",function(e){c.disabled===!0&&(e.preventDefault(),e.stopImmediatePropagation())}),a.mouseActive=!1,d.on("mousedown",function(){a.mouseActive=!0,r(function(){a.mouseActive=!1},100)}).on("focus",function(){a.mouseActive===!1&&d.addClass("md-focused")}).on("blur",function(){d.removeClass("md-focused")})}return{restrict:"EA",replace:!0,transclude:!0,template:a,link:d}}t.module("material.components.button",["material.core"]).directive("mdButton",e),e.$inject=["$mdButtonInkRipple","$mdTheming","$mdAria","$timeout"]}(),function(){function e(){return{restrict:"E"}}function n(e){function n(e,n,i,a,d,c,l){function m(o,r,l){r=i.extractElementByName(r,"md-bottom-sheet"),p=i.createBackdrop(o,"md-bottom-sheet-backdrop md-opaque"),p.on("click",function(){i.nextTick(d.cancel,!0)}),a.inherit(p,l.parent),e.enter(p,l.parent,null);var m=new u(r,l.parent);return l.bottomSheet=m,l.targetEvent&&t.element(l.targetEvent.target).blur(),a.inherit(m.element,l.parent),l.disableParentScroll&&(l.lastOverflow=l.parent.css("overflow"),l.parent.css("overflow","hidden")),e.enter(m.element,l.parent).then(function(){var e=t.element(r[0].querySelector("button")||r[0].querySelector("a")||r[0].querySelector("[ng-click]"));e.focus(),l.escapeToClose&&(l.rootElementKeyupCallback=function(e){e.keyCode===n.KEY_CODE.ESCAPE&&i.nextTick(d.cancel,!0)},c.on("keyup",l.rootElementKeyupCallback))})}function s(n,o,r){var i=r.bottomSheet;return e.leave(p),e.leave(i.element).then(function(){r.disableParentScroll&&(r.parent.css("overflow",r.lastOverflow),delete r.lastOverflow),i.cleanup(),r.targetEvent&&t.element(r.targetEvent.target).focus()})}function u(e,t){function a(t){e.css(n.CSS.TRANSITION_DURATION,"0ms")}function c(t){var o=t.pointer.distanceY;5>o&&(o=Math.max(-r,o/2)),e.css(n.CSS.TRANSFORM,"translate3d(0,"+(r+o)+"px,0)")}function m(t){if(t.pointer.distanceY>0&&(t.pointer.distanceY>20||Math.abs(t.pointer.velocityY)>o)){var r=e.prop("offsetHeight")-t.pointer.distanceY,a=Math.min(r/t.pointer.velocityY*.75,500);e.css(n.CSS.TRANSITION_DURATION,a+"ms"),i.nextTick(d.cancel,!0)}else e.css(n.CSS.TRANSITION_DURATION,""),e.css(n.CSS.TRANSFORM,"")}var s=l.register(t,"drag",{horizontal:!1});return t.on("$md.dragstart",a).on("$md.drag",c).on("$md.dragend",m),{element:e,cleanup:function(){s(),t.off("$md.dragstart",a).off("$md.drag",c).off("$md.dragend",m)}}}var p;return{themable:!0,targetEvent:null,onShow:m,onRemove:s,escapeToClose:!0,disableParentScroll:!0}}var o=.5,r=80;return n.$inject=["$animate","$mdConstant","$mdUtil","$mdTheming","$mdBottomSheet","$rootElement","$mdGesture"],e("$mdBottomSheet").setDefaults({methods:["disableParentScroll","escapeToClose","targetEvent"],options:n})}t.module("material.components.bottomSheet",["material.core","material.components.backdrop"]).directive("mdBottomSheet",e).provider("$mdBottomSheet",n),n.$inject=["$$interimElementProvider"]}(),function(){function e(e){return{restrict:"E",link:function(t,n,o){e(n)}}}t.module("material.components.card",["material.core"]).directive("mdCard",e),e.$inject=["$mdTheming"]}(),function(){function e(e,n,o,r,i,a,d){function c(n,c){return c.type="checkbox",c.tabindex=c.tabindex||"0",n.attr("role",c.type),function(n,c,m,s){function u(e,t,o){m[e]&&n.$watch(m[e],function(e){o[e]&&c.attr(t,o[e])})}function p(e){var t=e.which||e.keyCode;(t===r.KEY_CODE.SPACE||t===r.KEY_CODE.ENTER)&&(e.preventDefault(),c.hasClass("md-focused")||c.addClass("md-focused"),f(e))}function f(e){c[0].hasAttribute("disabled")||n.$apply(function(){var t=m.ngChecked?m.checked:!s.$viewValue;s.$setViewValue(t,e&&e.type),s.$render()})}function h(){s.$viewValue?c.addClass(l):c.removeClass(l)}s=s||a.fakeNgModel(),i(c),m.ngChecked&&n.$watch(n.$eval.bind(n,m.ngChecked),s.$setViewValue.bind(s)),u("ngDisabled","tabindex",{"true":"-1","false":m.tabindex}),o.expectWithText(c,"aria-label"),e.link.pre(n,{on:t.noop,0:{}},m,[s]),n.mouseActive=!1,c.on("click",f).on("keypress",p).on("mousedown",function(){n.mouseActive=!0,d(function(){n.mouseActive=!1},100)}).on("focus",function(){n.mouseActive===!1&&c.addClass("md-focused")}).on("blur",function(){c.removeClass("md-focused")}),s.$render=h}}e=e[0];var l="md-checked";return{restrict:"E",transclude:!0,require:"?ngModel",priority:210,template:'<div class="md-container" md-ink-ripple md-ink-ripple-checkbox><div class="md-icon"></div></div><div ng-transclude class="md-label"></div>',compile:c}}t.module("material.components.checkbox",["material.core"]).directive("mdCheckbox",e),e.$inject=["inputDirective","$mdInkRipple","$mdAria","$mdConstant","$mdTheming","$mdUtil","$timeout"]}(),function(){t.module("material.components.chips",["material.core","material.components.autocomplete"])}(),function(){function e(e){function t(e,t){this.$scope=e,this.$element=t}return{restrict:"E",controller:["$scope","$element",t],link:function(t,o,r){o[0];e(o),t.$broadcast("$mdContentLoaded",o),n(o[0])}}}function n(e){t.element(e).on("$md.pressdown",function(t){"t"===t.pointer.type&&(t.$materialScrollFixed||(t.$materialScrollFixed=!0,0===e.scrollTop?e.scrollTop=1:e.scrollHeight===e.scrollTop+e.offsetHeight&&(e.scrollTop-=1)))})}t.module("material.components.content",["material.core"]).directive("mdContent",e),e.$inject=["$mdTheming"]}(),function(){function e(e,n){return{restrict:"E",link:function(o,r,i){n(r),e(function(){function e(){r.toggleClass("md-content-overflow",o.scrollHeight>o.clientHeight)}var n,o=r[0].querySelector("md-dialog-content");o&&(n=o.getElementsByTagName("img"),e(),t.element(n).on("load",e))})}}}function n(e){function n(e,t){return{template:['<md-dialog md-theme="{{ dialog.theme }}" aria-label="{{ dialog.ariaLabel }}">',' <md-dialog-content role="document" tabIndex="-1">','   <h2 class="md-title">{{ dialog.title }}</h2>',"   <p>{{ dialog.content }}</p>"," </md-dialog-content>",' <div class="md-actions">','   <md-button ng-if="dialog.$type == \'confirm\'"     ng-click="dialog.abort()" class="md-primary">',"     {{ dialog.cancel }}","   </md-button>",'   <md-button ng-click="dialog.hide()" class="md-primary">',"     {{ dialog.ok }}","   </md-button>"," </div>","</md-dialog>"].join("").replace(/\s\s+/g,""),controller:function(){this.hide=function(){e.hide(!0)},this.abort=function(){e.cancel()}},controllerAs:"dialog",bindToController:!0,theme:t.defaultTheme()}}function o(e,n,o,r,i,a,d,c){function l(e,n,r){function i(){function e(){var e=n[0].querySelector(".dialog-close");if(!e){var o=n[0].querySelectorAll(".md-actions button");e=o[o.length-1]}return t.element(e)}if(r.focusOnOpen){var o="alert"===r.$type?n.find("md-dialog-content"):e();o.focus()}}return n=o.extractElementByName(n,"md-dialog"),t.element(a[0].body).addClass("md-dialog-is-showing"),s(n,r),f(n.find("md-dialog"),r),p(e,n,r),g(n,r).then(function(){u(n,r),h(n,r),i()})}function m(e,n,o){return o.deactivateListeners(),o.unlockScreenReader(),o.hideBackdrop(),E(n,o)["finally"](function(){t.element(a[0].body).removeClass("md-dialog-is-showing"),n.remove(),o.origin.focus()})}function s(e,n){var r={element:null,bounds:null,focus:t.noop};n.origin=t.extend({},r,n.origin||{});var i=t.element((n.targetEvent||{}).target);i&&i.length&&(n.origin.element=i,n.origin.bounds=i[0].getBoundingClientRect(),n.origin.focus=function(){i.focus()}),n.parent=t.element(n.parent||c),n.disableParentScroll&&(n.restoreScroll=o.disableScrollAround(e,n.parent))}function u(t,n){var i=[],a=function(){var t="alert"==n.$type?e.hide:e.cancel;o.nextTick(t,!0)};if(n.escapeToClose){var d=n.parent,c=function(e){e.keyCode===r.KEY_CODE.ESCAPE&&(e.stopPropagation(),e.preventDefault(),a())};t.on("keyup",c),d.on("keyup",c),i.push(function(){t.off("keyup",c),d.off("keyup",c)})}if(n.clickOutsideToClose){var d=t,l=function(e){e.target===d[0]&&(e.stopPropagation(),e.preventDefault(),a())};d.on("click",l),i.push(function(){d.off("click",l)})}n.deactivateListeners=function(){i.forEach(function(e){e()}),n.deactivateListeners=null}}function p(e,t,n){n.hasBackdrop&&(n.backdrop=o.createBackdrop(e,"md-dialog-backdrop md-opaque"),i.enter(n.backdrop,n.parent)),n.hideBackdrop=function(){n.backdrop&&i.leave(n.backdrop),n.disableParentScroll&&n.restoreScroll(),n.hideBackdrop=null}}function f(e,t){var r="alert"===t.$type?"alertdialog":"dialog",i=e.find("md-dialog-content"),a=e.attr("id")||"dialog_"+o.nextUid();e.attr({role:r,tabIndex:"-1"}),0===i.length&&(i=e),i.attr("id",a),e.attr("aria-describedby",a),t.ariaLabel?n.expect(e,"aria-label",t.ariaLabel):n.expectAsync(e,"aria-label",function(){var e=i.text().split(/\s+/);return e.length>3&&(e=e.slice(0,3).concat("...")),e.join(" ")})}function h(e,t){function n(e){for(;e.parentNode;){if(e===document.body)return;for(var t=e.parentNode.children,r=0;r<t.length;r++)e===t[r]||v(t[r],["SCRIPT","STYLE"])||t[r].setAttribute("aria-hidden",o);n(e=e.parentNode)}}var o=!0;n(e[0]),t.unlockScreenReader=function(){o=!1,n(e[0]),t.unlockScreenReader=null}}function b(e,t){var n="fixed"==d.getComputedStyle(a[0].body).position,r=t.backdrop?d.getComputedStyle(t.backdrop[0]):null,i=r?Math.ceil(Math.abs(parseInt(r.height,10))):0;return e.css({top:(n?o.scrollTop(t.parent)/2:0)+"px",height:i?i+"px":"100%"}),e}function g(e,t){t.parent.append(e),b(e,t);var n=e.find("md-dialog"),r=o.dom.animator,i=r.calculateZoomToOrigin,a={transitionInClass:"md-transition-in",transitionOutClass:"md-transition-out"},d=r.toTransformCss(i(n,t.origin)),c=r.toTransformCss("");return r.translate3d(n,d,c,a).then(function(e){return t.reverseAnimate=function(){return delete t.reverseAnimate,e(r.toTransformCss(i(n,t.origin)))},!0})}function E(e,t){return t.reverseAnimate()}function v(e,t){return-1!==t.indexOf(e.nodeName)?!0:void 0}return{hasBackdrop:!0,isolateScope:!0,onShow:l,onRemove:m,clickOutsideToClose:!1,escapeToClose:!0,targetEvent:null,focusOnOpen:!0,disableParentScroll:!0,transformTemplate:function(e){return'<div class="md-dialog-container">'+e+"</div>"}}}return n.$inject=["$mdDialog","$mdTheming"],o.$inject=["$mdDialog","$mdAria","$mdUtil","$mdConstant","$animate","$document","$window","$rootElement"],e("$mdDialog").setDefaults({methods:["disableParentScroll","hasBackdrop","clickOutsideToClose","escapeToClose","targetEvent","parent"],options:o}).addPreset("alert",{methods:["title","content","ariaLabel","ok","theme"],options:n}).addPreset("confirm",{methods:["title","content","ariaLabel","ok","cancel","theme"],options:n})}t.module("material.components.dialog",["material.core","material.components.backdrop"]).directive("mdDialog",e).provider("$mdDialog",n),e.$inject=["$$rAF","$mdTheming"],n.$inject=["$$interimElementProvider"]}(),function(){function e(e){return{restrict:"E",link:e}}t.module("material.components.divider",["material.core"]).directive("mdDivider",e),e.$inject=["$mdTheming"]}(),function(){!function(){function e(){return{restrict:"E",require:["^?mdFabSpeedDial","^?mdFabToolbar"],compile:function(e,n){var o=e.children();return o.attr("ng-repeat")?o.addClass("md-fab-action-item"):o.wrap('<div class="md-fab-action-item">'),function(e,n,o,r){var i=r[0]||r[1];i&&t.forEach(n.children(),function(e){e=t.element(e).children()[0],t.element(e).on("focus",i.open),t.element(e).on("blur",i.close)})}}}}t.module("material.components.fabActions",["material.core"]).directive("mdFabActions",e)}()}(),function(){!function(){function e(){function e(e,t){t.prepend('<div class="md-css-variables"></div>')}function t(e,t,n,o){function r(){d.direction=d.direction||"down",d.isOpen=d.isOpen||!1}function i(){t.on("mouseenter",d.mouseenter),t.on("mouseleave",d.mouseleave)}function a(){e.$watch("vm.direction",function(e,o){n.removeClass(t,"md-"+o),n.addClass(t,"md-"+e)}),e.$watch("vm.isOpen",function(e){var o=e?"md-is-open":"",r=e?"":"md-is-open";n.setClass(t,o,r)})}var d=this;d.open=function(){e.$evalAsync("vm.isOpen = true")},d.close=function(){!d.moused&&e.$evalAsync("vm.isOpen = false")},d.mouseenter=function(){d.moused=!0,d.open()},d.mouseleave=function(){d.moused=!1,d.close()},r(),i(),a(),o.nextTick(function(){n.addClass(t,"md-noop")})}return t.$inject=["$scope","$element","$animate","$mdUtil"],{restrict:"E",scope:{direction:"@?mdDirection",isOpen:"=?mdOpen"},bindToController:!0,controller:t,controllerAs:"vm",link:e}}function n(){function e(e){var n=e[0],o=e.controller("mdFabSpeedDial"),r=n.querySelectorAll(".md-fab-action-item"),i=n.querySelector(".md-css-variables"),a=i.style.zIndex;t.forEach(r,function(e,t){var n=e.style;n.transform=n.webkitTransform="",n.transitionDelay="",n.opacity=1,n.zIndex=r.length-t+a}),o.isOpen||t.forEach(r,function(e,t){var n,r,i=e.style;switch(o.direction){case"up":n=e.scrollHeight*(t+1),r="Y";break;case"down":n=-e.scrollHeight*(t+1),r="Y";break;case"left":n=e.scrollWidth*(t+1),r="X";break;case"right":n=-e.scrollWidth*(t+1),r="X"}var a="translate"+r+"("+n+"px)";i.transform=i.webkitTransform=a})}return{addClass:function(t,n,o){t.hasClass("md-fling")&&(e(t),o())},removeClass:function(t,n,o){e(t),o()}}}function o(){function e(e){var o=e[0],r=e.controller("mdFabSpeedDial"),i=o.querySelectorAll(".md-fab-action-item");t.forEach(i,function(e,t){var o=e.style,a=t*n;o.opacity=r.isOpen?1:0,o.transform=o.webkitTransform=r.isOpen?"scale(1)":"scale(0)",o.transitionDelay=(r.isOpen?a:i.length-a)+"ms"})}var n=65;return{addClass:function(t,n,o){e(t),o()},removeClass:function(t,n,o){e(t),o()}}}t.module("material.components.fabSpeedDial",["material.core","material.components.fabTrigger","material.components.fabActions"]).directive("mdFabSpeedDial",e).animation(".md-fling",n).animation(".md-scale",o).service("mdFabSpeedDialFlingAnimation",n).service("mdFabSpeedDialScaleAnimation",o)}()}(),function(){!function(){function n(){function e(e,t,n){var o=this;o.isOpen=o.isOpen||!1,o.open=function(){o.isOpen=!0,e.$apply()},o.close=function(){o.isOpen=!1,e.$apply()},t.addClass("md-fab-toolbar"),t.on("mouseenter",o.open),t.on("mouseleave",o.close),e.$watch("vm.isOpen",function(e){var o=e?"md-is-open":"",r=e?"":"md-is-open";n.setClass(t,o,r)})}function t(e,t,n){t.find("md-fab-trigger").find("button").attr("tabindex","-1"),t.find("md-fab-trigger").find("button").prepend('<div class="md-fab-toolbar-background"></div>')}return e.$inject=["$scope","$element","$animate"],{restrict:"E",transclude:!0,template:'<div class="md-fab-toolbar-wrapper">  <div class="md-fab-toolbar-content" ng-transclude></div></div>',scope:{isOpen:"=?mdOpen"},bindToController:!0,controller:e,controllerAs:"vm",link:t}}function o(){function n(n,o,r){var i=n[0],a=n.controller("mdFabToolbar"),d=i.querySelector(".md-fab-toolbar-background"),c=i.querySelector("md-fab-trigger button"),l=i.querySelector("md-fab-trigger button md-icon"),m=n.find("md-fab-actions").children();if(c&&d){var s=e.getComputedStyle(c).getPropertyValue("background-color"),u=i.offsetWidth,p=(i.offsetHeight,2*u);d.style.backgroundColor=s,d.style.borderRadius=u+"px",a.isOpen?(d.style.width=p+"px",d.style.height=p+"px",d.style.top=-(p/2)+"px",n.hasClass("md-left")&&(d.style.left=-(p/2)+"px",d.style.right=null),n.hasClass("md-right")&&(d.style.right=-(p/2)+"px",d.style.left=null),d.style.transitionDelay="0ms",l&&(l.style.transitionDelay=".3s"),t.forEach(m,function(e,t){e.style.transitionDelay=25*(m.length-t)+"ms"})):(d.style.width=c.offsetWidth+"px",d.style.height=c.offsetHeight+"px",d.style.top="0px",n.hasClass("md-left")&&(d.style.left="0px",d.style.right=null),n.hasClass("md-right")&&(d.style.right="0px",d.style.left=null),d.style.transitionDelay="200ms",l&&(l.style.transitionDelay="0ms"),t.forEach(m,function(e,t){e.style.transitionDelay=25*t+"ms"}))}}return{addClass:function(e,t,o){n(e,t,o),o()},removeClass:function(e,t,o){n(e,t,o),o()}}}t.module("material.components.fabToolbar",["material.core","material.components.fabTrigger","material.components.fabActions"]).directive("mdFabToolbar",n).animation(".md-fab-toolbar",o).service("mdFabToolbarAnimation",o)}()}(),function(){!function(){function e(){return{restrict:"E",require:["^?mdFabSpeedDial","^?mdFabToolbar"],link:function(e,n,o,r){var i=r[0]||r[1];i&&t.forEach(n.children(),function(e){t.element(e).on("focus",i.open),t.element(e).on("blur",i.close)})}}}t.module("material.components.fabTrigger",["material.core"]).directive("mdFabTrigger",e)}()}(),function(){function e(e,o,r,i){function a(n,a,d,c){function l(){for(var e in o.MEDIA)i(e),i.getQuery(o.MEDIA[e]).addListener(T);return i.watchResponsiveAttributes(["md-cols","md-row-height"],d,s)}function m(){c.layoutDelegate=t.noop,C();for(var e in o.MEDIA)i.getQuery(o.MEDIA[e]).removeListener(T)}function s(e){null==e?c.invalidateLayout():i(e)&&c.invalidateLayout()}function u(e){var o=b(),i={tileSpans:g(o),colCount:E(),rowMode:$(),rowHeight:M(),gutter:v()};if(e||!t.equals(i,y)){var d=r(i.colCount,i.tileSpans,o).map(function(e,n){return{grid:{element:a,style:h(i.colCount,n,i.gutter,i.rowMode,i.rowHeight)},tiles:e.map(function(e,n){return{element:t.element(o[n]),style:f(e.position,e.spans,i.colCount,i.rowCount,i.gutter,i.rowMode,i.rowHeight)}})}}).reflow().performance();n.mdOnLayout({$event:{performance:d}}),y=i}}function p(e){return w+e+k}function f(e,t,n,o,r,i,a){var d=1/n*100,c=(n-1)/n,l=x({share:d,gutterShare:c,gutter:r}),m={left:N({unit:l,offset:e.col,gutter:r}),width:_({unit:l,span:t.col,gutter:r}),paddingTop:"",marginTop:"",top:"",height:""};switch(i){case"fixed":m.top=N({unit:a,offset:e.row,gutter:r}),m.height=_({unit:a,span:t.row,gutter:r});break;case"ratio":var s=d/a,u=x({share:s,gutterShare:c,gutter:r});m.paddingTop=_({unit:u,span:t.row,gutter:r}),m.marginTop=N({unit:u,offset:e.row,gutter:r});break;case"fit":var p=(o-1)/o,s=1/o*100,u=x({share:s,gutterShare:p,gutter:r});m.top=N({unit:u,offset:e.row,gutter:r}),m.height=_({unit:u,span:t.row,gutter:r})}return m}function h(e,t,n,o,r){var i={height:"",paddingBottom:""};switch(o){case"fixed":i.height=_({unit:r,span:t,gutter:n});break;case"ratio":var a=1===e?0:(e-1)/e,d=1/e*100,c=d*(1/r),l=x({share:c,gutterShare:a,gutter:n});i.paddingBottom=_({unit:l,span:t,gutter:n});break;case"fit":}return i}function b(){return[].filter.call(a.children(),function(e){return"MD-GRID-TILE"==e.tagName})}function g(e){return[].map.call(e,function(e){var n=t.element(e).controller("mdGridTile");return{row:parseInt(i.getResponsiveAttribute(n.$attrs,"md-rowspan"),10)||1,col:parseInt(i.getResponsiveAttribute(n.$attrs,"md-colspan"),10)||1}})}function E(){var e=parseInt(i.getResponsiveAttribute(d,"md-cols"),10);if(isNaN(e))throw"md-grid-list: md-cols attribute was not found, or contained a non-numeric value";return e}function v(){return A(i.getResponsiveAttribute(d,"md-gutter")||1)}function M(){var e=i.getResponsiveAttribute(d,"md-row-height");switch($()){case"fixed":return A(e);case"ratio":var t=e.split(":");return parseFloat(t[0])/parseFloat(t[1]);case"fit":return 0}}function $(){var e=i.getResponsiveAttribute(d,"md-row-height");return"fit"==e?"fit":-1!==e.indexOf(":")?"ratio":"fixed"}function A(e){return/\D$/.test(e)?e:e+"px"}a.attr("role","list"),c.layoutDelegate=u;var T=t.bind(c,c.invalidateLayout),C=l();n.$on("$destroy",m);var y,w=e.startSymbol(),k=e.endSymbol(),x=e(p("share")+"% - ("+p("gutter")+" * "+p("gutterShare")+")"),N=e("calc(("+p("unit")+" + "+p("gutter")+") * "+p("offset")+")"),_=e("calc(("+p("unit")+") * "+p("span")+" + ("+p("span")+" - 1) * "+p("gutter")+")")}return{restrict:"E",controller:n,
scope:{mdOnLayout:"&"},link:a}}function n(e){this.layoutInvalidated=!1,this.tilesInvalidated=!1,this.$timeout_=e.nextTick,this.layoutDelegate=t.noop}function o(e){function n(t,n){var o,a,d,c,l,m;return c=e.time(function(){a=r(t,n)}),o={layoutInfo:function(){return a},map:function(t){return l=e.time(function(){var e=o.layoutInfo();d=t(e.positioning,e.rowCount)}),o},reflow:function(t){return m=e.time(function(){var e=t||i;e(d.grid,d.tiles)}),o},performance:function(){return{tileCount:n.length,layoutTime:c,mapTime:l,reflowTime:m,totalTime:c+l+m}}}}function o(e,t){e.element.css(e.style),t.forEach(function(e){e.element.css(e.style)})}function r(e,t){function n(t,n){if(t.col>e)throw"md-grid-list: Tile at position "+n+" has a colspan ("+t.col+") that exceeds the column count ("+e+")";for(var a=0,m=0;m-a<t.col;)d>=e?o():(a=l.indexOf(0,d),-1!==a&&-1!==(m=i(a+1))?d=m+1:(a=m=0,o()));return r(a,t.col,t.row),d=a+t.col,{col:a,row:c}}function o(){d=0,c++,r(0,e,-1)}function r(e,t,n){for(var o=e;e+t>o;o++)l[o]=Math.max(l[o]+n,0)}function i(e){var t;for(t=e;t<l.length;t++)if(0!==l[t])return t;return t===l.length?t:void 0}function a(){for(var t=[],n=0;e>n;n++)t.push(0);return t}var d=0,c=0,l=a();return{positioning:t.map(function(e,t){return{spans:e,position:n(e,t)}}),rowCount:c+Math.max.apply(Math,l)}}var i=o;return n.animateWith=function(e){i=t.isFunction(e)?e:o},n}function r(e){function n(n,o,r,i){o.attr("role","listitem");var a=e.watchResponsiveAttributes(["md-colspan","md-rowspan"],r,t.bind(i,i.invalidateLayout));i.invalidateTiles(),n.$on("$destroy",function(){a(),i.invalidateLayout()}),t.isDefined(n.$parent.$index)&&n.$watch(function(){return n.$parent.$index},function(e,t){e!==t&&i.invalidateTiles()})}return{restrict:"E",require:"^mdGridList",template:"<figure ng-transclude></figure>",transclude:!0,scope:{},controller:["$attrs",function(e){this.$attrs=e}],link:n}}function i(){return{template:"<figcaption ng-transclude></figcaption>",transclude:!0}}t.module("material.components.gridList",["material.core"]).directive("mdGridList",e).directive("mdGridTile",r).directive("mdGridTileFooter",i).directive("mdGridTileHeader",i).factory("$mdGridLayout",o),e.$inject=["$interpolate","$mdConstant","$mdGridLayout","$mdMedia"],n.$inject=["$mdUtil"],n.prototype={invalidateTiles:function(){this.tilesInvalidated=!0,this.invalidateLayout()},invalidateLayout:function(){this.layoutInvalidated||(this.layoutInvalidated=!0,this.$timeout_(t.bind(this,this.layout)))},layout:function(){try{this.layoutDelegate(this.tilesInvalidated)}finally{this.layoutInvalidated=!1,this.tilesInvalidated=!1}}},o.$inject=["$mdUtil"],r.$inject=["$mdMedia"]}(),function(){function e(e,t,n){function o(o,r,i){function a(){var e=r.parent();return e.attr("aria-label")||e.text()?!0:e.parent().attr("aria-label")||e.parent().text()?!0:!1}function d(){function t(){return!o.fontIcon&&!o.fontSet&&!i.hasOwnProperty("class")}o.svgIcon||o.svgSrc||(o.fontIcon&&r.addClass("md-font "+o.fontIcon),o.fontSet&&r.addClass(e.fontSet(o.fontSet)),t()&&r.addClass(e.fontSet()))}t(r),d();var c=i.alt||o.fontIcon||o.svgIcon||r.text(),l=i.$normalize(i.$attr.mdSvgIcon||i.$attr.mdSvgSrc||"");i["aria-label"]||(""==c||a()?r.text()||n.expect(r,"aria-hidden","true"):(n.expect(r,"aria-label",c),n.expect(r,"role","img"))),l&&i.$observe(l,function(t){r.empty(),t&&e(t).then(function(e){r.append(e)})})}return{scope:{fontSet:"@mdFontSet",fontIcon:"@mdFontIcon",svgIcon:"@mdSvgIcon",svgSrc:"@mdSvgSrc"},restrict:"E",link:o}}t.module("material.components.icon",["material.core"]).directive("mdIcon",e),e.$inject=["$mdIcon","$mdTheming","$mdAria"]}(),function(){function e(){}function n(e,t){this.url=e,this.viewBoxSize=t||r.defaultViewBoxSize}function o(e,n,o,r,i){function a(e){return e=e||"",E[e]?o.when(E[e].clone()):v.test(e)?s(e).then(c(e)):(-1==e.indexOf(":")&&(e="$default:"+e),l(e)["catch"](m)["catch"](u)["catch"](p).then(c(e)))}function d(n){var o=t.isUndefined(n)||!(n&&n.length);if(o)return e.defaultFontSet;var r=n;return t.forEach(e.fontSets,function(e){e.alias==n&&(r=e.fontSet||r)}),r}function c(t){return function(n){return E[t]=f(n)?n:new h(n,e[t]),E[t].clone()}}function l(t){var n=e[t];return n?s(n.url).then(function(e){return new h(e,n)}):o.reject(t)}function m(t){function n(e){var n=t.slice(t.lastIndexOf(":")+1),r=e.querySelector("#"+n);return r?new h(r,i):o.reject(t)}var r=t.substring(0,t.lastIndexOf(":"))||"$default",i=e[r];return i?s(i.url).then(n):o.reject(t)}function s(e){return n.get(e,{cache:i}).then(function(e){return t.element("<div>").append(e.data).find("svg")[0]})}function u(e){var n;return t.isString(e)&&(n="icon "+e+" not found",r.warn(n)),o.reject(n||e)}function p(e){var n=t.isString(e)?e:e.message||e.data||e.statusText;return r.warn(n),o.reject(n)}function f(e){return t.isDefined(e.element)&&t.isDefined(e.config)}function h(e,n){"svg"!=e.tagName&&(e=t.element('<svg xmlns="http://www.w3.org/2000/svg">').append(e)[0]),e.getAttribute("xmlns")||e.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.element=e,this.config=n,this.prepare()}function b(){var n=this.config?this.config.viewBoxSize:e.defaultViewBoxSize;t.forEach({fit:"",height:"100%",width:"100%",preserveAspectRatio:"xMidYMid meet",viewBox:this.element.getAttribute("viewBox")||"0 0 "+n+" "+n},function(e,t){this.element.setAttribute(t,e)},this),t.forEach({"pointer-events":"none",display:"block"},function(e,t){this.element.style[t]=e},this)}function g(){return this.element.cloneNode(!0)}var E={},v=/[-a-zA-Z0-9@:%_\+.~#?&//=]{2,256}\.[a-z]{2,4}\b(\/[-a-zA-Z0-9@:%_\+.~#?&//=]*)?/i;return h.prototype={clone:g,prepare:b},a.fontSet=d,a}t.module("material.components.icon").provider("$mdIcon",e);var r={defaultViewBoxSize:24,defaultFontSet:"material-icons",fontSets:[]};e.prototype={icon:function(e,t,o){return-1==e.indexOf(":")&&(e="$default:"+e),r[e]=new n(t,o),this},iconSet:function(e,t,o){return r[e]=new n(t,o),this},defaultIconSet:function(e,t){var o="$default";return r[o]||(r[o]=new n(e,t)),r[o].viewBoxSize=t||r.defaultViewBoxSize,this},defaultViewBoxSize:function(e){return r.defaultViewBoxSize=e,this},fontSet:function(e,t){return r.fontSets.push({alias:e,fontSet:t||e}),this},defaultFontSet:function(e){return r.defaultFontSet=e?e:"",this},defaultIconSize:function(e){return r.defaultIconSize=e,this},preloadIcons:function(e){var t=this,n=[{id:"md-tabs-arrow",url:"md-tabs-arrow.svg",svg:'<svg version="1.1" x="0px" y="0px" viewBox="0 0 24 24"><g><polygon points="15.4,7.4 14,6 8,12 14,18 15.4,16.6 10.8,12 "/></g></svg>'},{id:"md-close",url:"md-close.svg",svg:'<svg version="1.1" x="0px" y="0px" viewBox="0 0 24 24"><g><path d="M19 6.41l-1.41-1.41-5.59 5.59-5.59-5.59-1.41 1.41 5.59 5.59-5.59 5.59 1.41 1.41 5.59-5.59 5.59 5.59 1.41-1.41-5.59-5.59z"/></g></svg>'},{id:"md-cancel",url:"md-cancel.svg",svg:'<svg version="1.1" x="0px" y="0px" viewBox="0 0 24 24"><g><path d="M12 2c-5.53 0-10 4.47-10 10s4.47 10 10 10 10-4.47 10-10-4.47-10-10-10zm5 13.59l-1.41 1.41-3.59-3.59-3.59 3.59-1.41-1.41 3.59-3.59-3.59-3.59 1.41-1.41 3.59 3.59 3.59-3.59 1.41 1.41-3.59 3.59 3.59 3.59z"/></g></svg>'},{id:"md-menu",url:"md-menu.svg",svg:'<svg version="1.1" x="0px" y="0px" viewBox="0 0 24 24"><path d="M3,6H21V8H3V6M3,11H21V13H3V11M3,16H21V18H3V16Z" /></svg>'},{id:"md-toggle-arrow",url:"md-toggle-arrow-svg",svg:'<svg version="1.1" x="0px" y="0px" viewBox="0 0 48 48"><path d="M24 16l-12 12 2.83 2.83 9.17-9.17 9.17 9.17 2.83-2.83z"/><path d="M0 0h48v48h-48z" fill="none"/></svg>'}];n.forEach(function(n){t.icon(n.id,n.url),e.put(n.url,n.svg)})},$get:["$http","$q","$log","$templateCache",function(e,t,n,i){return this.preloadIcons(i),o(r,e,t,n,i)}]}}(),function(){function e(e,t){function n(t,n,o){e(n)}function o(e,n,o){var r=this;r.isErrorGetter=o.mdIsError&&t(o.mdIsError),r.delegateClick=function(){r.input.focus()},r.element=n,r.setFocused=function(e){n.toggleClass("md-input-focused",!!e)},r.setHasValue=function(e){n.toggleClass("md-input-has-value",!!e)},r.setInvalid=function(e){n.toggleClass("md-input-invalid",!!e)},e.$watch(function(){return r.label&&r.input},function(e){e&&!r.label.attr("for")&&r.label.attr("for",r.input.attr("id"))})}return o.$inject=["$scope","$element","$attrs"],{restrict:"E",link:n,controller:o}}function n(){return{restrict:"E",require:"^?mdInputContainer",link:function(e,t,n,o){o&&!n.mdNoFloat&&(o.label=t,e.$on("$destroy",function(){o.label=null}))}}}function o(e,n,o){function r(r,i,a,d){function c(e){return s.setHasValue(!u.$isEmpty(e)),e}function l(){s.setHasValue(i.val().length>0||(i[0].validity||{}).badInput)}function m(){function o(e){return h(),e}function a(){if(m.style.height=m.offsetHeight+"px",i.addClass("md-no-flex"),isNaN(p)){l.style.height="auto",l.scrollTop=0;var e=d();e&&(l.style.height=e+"px")}else{l.setAttribute("rows",1),f||(l.style.minHeight="0",f=i.prop("clientHeight"),l.style.minHeight=null);var t=Math.max(p,Math.round(l.scrollHeight/f));l.setAttribute("rows",t)}i.removeClass("md-no-flex"),m.style.height="auto"}function d(){var e=l.scrollHeight-l.offsetHeight;return l.offsetHeight+(e>0?e:0)}function c(e){l.scrollTop=0;var t=l.scrollHeight-l.offsetHeight,n=l.offsetHeight+t;l.style.height=n+"px"}if(!t.isDefined(i.attr("md-no-autogrow"))){var l=i[0],m=s.element[0],p=0/0,f=null;l.hasAttribute("rows")&&(p=parseInt(l.getAttribute("rows")));var h=e.debounce(a,1);u?(u.$formatters.push(o),u.$viewChangeListeners.push(o)):h(),i.on("keydown input",h),isNaN(p)&&(i.attr("rows","1"),i.on("scroll",c)),t.element(n).on("resize",h),r.$on("$destroy",function(){t.element(n).off("resize",h)})}}var s=d[0],u=d[1]||e.fakeNgModel(),p=t.isDefined(a.readonly);if(s){if(s.input)throw new Error("<md-input-container> can only have *one* <input>, <textarea> or <md-select> child element!");s.input=i,s.label||o.expect(i,"aria-label",i.attr("placeholder")),i.addClass("md-input"),i.attr("id")||i.attr("id","input_"+e.nextUid()),"textarea"===i[0].tagName.toLowerCase()&&m();var f=s.isErrorGetter||function(){return u.$invalid&&u.$touched};r.$watch(f,s.setInvalid),u.$parsers.push(c),u.$formatters.push(c),i.on("input",l),p||i.on("focus",function(e){s.setFocused(!0)}).on("blur",function(e){s.setFocused(!1),l()}),r.$on("$destroy",function(){s.setFocused(!1),s.setHasValue(!1),s.input=null})}}return{restrict:"E",require:["^?mdInputContainer","?ngModel"],link:r}}function r(e){function n(n,o,r,i){function a(e){return m.text((o.val()||e||"").length+"/"+d),e}var d,c=i[0],l=i[1],m=t.element('<div class="md-char-counter">');r.$set("ngTrim","false"),l.element.append(m),c.$formatters.push(a),c.$viewChangeListeners.push(a),o.on("input keydown",function(){a()}),n.$watch(r.mdMaxlength,function(n){d=n,t.isNumber(n)&&n>0?(m.parent().length||e.enter(m,l.element,t.element(l.element[0].lastElementChild)),a()):e.leave(m)}),c.$validators["md-maxlength"]=function(e,n){return!t.isNumber(d)||0>d?!0:(e||o.val()||n||"").length<=d}}return{restrict:"A",require:["ngModel","^mdInputContainer"],link:n}}function i(e){function n(n,o,r,i){if(i&&!t.isDefined(i.element.attr("md-no-float"))){var a=r.placeholder;if(o.removeAttr("placeholder"),0==i.element.find("label").length){if(i.input&&"MD-SELECT"!=i.input[0].nodeName){var d='<label ng-click="delegateClick()">'+a+"</label>";i.element.addClass("md-icon-float"),i.element.prepend(d)}}else"MD-SELECT"!=o[0].nodeName&&e.warn("The placeholder='"+a+"' will be ignored since this md-input-container has a child label element.")}}return{restrict:"A",require:"^^?mdInputContainer",priority:200,link:n}}t.module("material.components.input",["material.core"]).directive("mdInputContainer",e).directive("label",n).directive("input",o).directive("textarea",o).directive("mdMaxlength",r).directive("placeholder",i),e.$inject=["$mdTheming","$parse"],o.$inject=["$mdUtil","$window","$mdAria"],r.$inject=["$animate"],i.$inject=["$log"]}(),function(){function e(e){return{restrict:"E",compile:function(t){return t[0].setAttribute("role","list"),e}}}function n(e,n,o){var r=["md-checkbox","md-switch"];return{restrict:"E",controller:"MdListController",compile:function(i,a){function d(){for(var e,t,n=["md-switch","md-checkbox"],o=0;t=n[o];++o)if((e=i.find(t)[0])&&!e.hasAttribute("aria-label")){var r=i.find("p")[0];if(!r)return;e.setAttribute("aria-label","Toggle "+r.textContent)}}function c(n){var o;if("div"==n)o=t.element('<div class="md-no-style md-list-item-inner">'),o.append(i.contents()),i.addClass("md-proxy-focus");else{o=t.element('<md-button class="md-no-style"><div class="md-list-item-inner"></div></md-button>');var r=["ng-click","aria-label","ng-disabled"];t.forEach(r,function(e){i[0].hasAttribute(e)&&(o[0].setAttribute(e,i[0].getAttribute(e)),i[0].removeAttribute(e))}),o.children().eq(0).append(i.contents())}if(i[0].setAttribute("tabindex","-1"),i.append(o),p&&p.hasAttribute("ng-click")){e.expect(p,"aria-label");var d=t.element('<md-button class="md-secondary-container md-icon-button">');d.attr("ng-click",p.getAttribute("ng-click")),p.removeAttribute("ng-click"),p.setAttribute("tabindex","-1"),p.classList.remove("md-secondary"),d.append(p),p=d[0]}p&&(p.hasAttribute("ng-click")||a.ngClick&&l(p))&&(i.addClass("md-with-secondary"),i.append(p))}function l(e){return-1!=r.indexOf(e.nodeName.toLowerCase())}function m(e,i,a,d){function c(){var e=i.children();e.length&&!e[0].hasAttribute("ng-click")&&t.forEach(r,function(e){t.forEach(s.querySelectorAll(e),function(e){m.push(e)})})}function l(){(m.length||u)&&(i.addClass("md-clickable"),d.attachRipple(e,t.element(i[0].querySelector(".md-no-style"))))}var m=[],s=i[0].firstElementChild,u=s&&s.hasAttribute("ng-click");c(),l(),i.hasClass("md-proxy-focus")&&m.length&&t.forEach(m,function(n){n=t.element(n),e.mouseActive=!1,n.on("mousedown",function(){e.mouseActive=!0,o(function(){e.mouseActive=!1},100)}).on("focus",function(){e.mouseActive===!1&&i.addClass("md-focused"),n.on("blur",function t(){i.removeClass("md-focused"),n.off("blur",t)})})}),u||m.length||s&&s.addEventListener("keypress",function(e){if("INPUT"!=e.target.nodeName&&"TEXTAREA"!=e.target.nodeName){var t=e.which||e.keyCode;t==n.KEY_CODE.SPACE&&s&&(s.click(),e.preventDefault(),e.stopPropagation())}}),i.off("click"),i.off("keypress"),m.length&&s&&i.children().eq(0).on("click",function(e){s.contains(e.target)&&t.forEach(m,function(n){e.target===n||n.contains(e.target)||t.element(n).triggerHandler("click")})})}var s,u,p=i[0].querySelector(".md-secondary");if(i[0].setAttribute("role","listitem"),a.ngClick)c("button");else{for(var f,h=0;f=r[h];++h)if(u=i[0].querySelector(f)){s=!0;break}s?c("div"):i[0].querySelector("md-button")||i.addClass("md-no-proxy")}return d(),m}}}function o(e,t,n){function o(e,t){var o={};n.attach(e,t,o)}var r=this;r.attachRipple=o}t.module("material.components.list",["material.core"]).controller("MdListController",o).directive("mdList",e).directive("mdListItem",n),e.$inject=["$mdTheming"],n.$inject=["$mdAria","$mdConstant","$timeout"],o.$inject=["$scope","$element","$mdListInkRipple"]}(),function(){function e(e){function n(e){e.addClass("md-menu");var t=e.children()[0];if(t.hasAttribute("ng-click")||(t=t.querySelector("[ng-click]")),t&&t.setAttribute("aria-haspopup","true"),2!=e.children().length)throw Error("Invalid HTML for md-menu. Expected two children elements.");return o}function o(e,n,o,r){var i=t.element('<div class="md-open-menu-container md-whiteframe-z2"></div>'),a=n.children()[1];i.append(a),r.init(i),e.$on("$destroy",function(){i.remove(),r.close()})}return{restrict:"E",require:"mdMenu",controller:"mdMenuCtrl",scope:!0,compile:n}}function n(e,t,n,o){var r,i,a=this;this.init=function(e){r=e,i=n[0].querySelector("[ng-click]")},this.open=function(t){t&&t.stopPropagation(),a.isOpen=!0,i.setAttribute("aria-expanded","true"),e.show({scope:o,mdMenuCtrl:a,element:r,target:n[0]})},o.$mdOpenMenu=this.open,this.close=function(t){a.isOpen&&(a.isOpen=!1,i.setAttribute("aria-expanded","false"),e.hide(),t||n.children()[0].focus())},this.positionMode=function(){var e=(t.mdPositionMode||"target").split(" ");return 1==e.length&&e.push(e[0]),{left:e[0],top:e[1]}},this.offsets=function(){var e=(t.mdOffset||"0 0").split(" ").map(parseFloat);if(2==e.length)return{left:e[0],top:e[1]};if(1==e.length)return{top:e[0],left:e[0]};throw Error("Invalid offsets specified. Please follow format <x, y> or <n>")}}t.module("material.components.menu",["material.core","material.components.backdrop"]).directive("mdMenu",e).controller("mdMenuCtrl",n),e.$inject=["$mdMenu"],n.$inject=["$mdMenu","$attrs","$element","$scope"]}(),function(){function o(o){function r(o,r,a,d,c,l){function m(e,n,i){function l(){if(!i.target)throw Error("$mdMenu.show() expected a target to animate from in options.target");t.extend(i,{alreadyOpen:!1,isRemoved:!1,target:t.element(i.target),parent:t.element(i.parent),menuContentEl:t.element(n[0].querySelector("md-menu-content")),backdrop:i.hasBackdrop&&a.createBackdrop(e,"md-menu-backdrop md-click-catcher")})}function m(){i.resizeFn=function(){f(n,i)},t.element(r).on("resize",i.resizeFn),t.element(r).on("orientationchange",i.resizeFn)}function u(){i.parent.append(n),n.removeClass("md-leave"),o(function(){o(function(){f(n,i),o(function(){n.addClass("md-active"),i.alreadyOpen=!0,n[0].style[c.CSS.TRANSFORM]=""})})})}function p(){n.addClass("md-clickable"),i.backdrop&&i.backdrop.on("click",function(t){t.preventDefault(),t.stopPropagation(),e.$apply(function(){i.mdMenuCtrl.close(!0)})}),i.menuContentEl.on("keydown",function(t){e.$apply(function(){switch(t.keyCode){case c.KEY_CODE.ESCAPE:i.mdMenuCtrl.close();break;case c.KEY_CODE.UP_ARROW:s(t,i.menuContentEl,i,-1);break;case c.KEY_CODE.DOWN_ARROW:s(t,i.menuContentEl,i,1)}})});var t=function(t){function n(){e.$apply(function(){i.mdMenuCtrl.close()})}function o(e,t){if(!e)return!1;for(var n,o=0;n=t[o];++o)for(var r,i=[n,"data-"+n,"x-"+n],a=0;r=i[a];++a)if(e.hasAttribute(r))return!0;return!1}var r=t.target;do{if(r==i.menuContentEl[0])return;if(o(r,["ng-click","ng-href","ui-sref"])){r.hasAttribute("disabled")||n();break}}while(r=r.parentNode)};i.menuContentEl[0].addEventListener("click",t,!0);var o=i.menuContentEl[0].querySelector("[md-menu-focus-target]");return o||(o=i.menuContentEl[0].firstElementChild.firstElementChild),o.focus(),function(){n.removeClass("md-clickable"),i.backdrop.off("click"),i.menuContentEl.off("keydown"),i.menuContentEl[0].removeEventListener("click",t,!0)}}return l(i),d.inherit(i.menuContentEl,i.target),m(),i.disableParentScroll&&(i.restoreScroll=a.disableScrollAround(i.element)),i.backdrop&&(d.inherit(i.backdrop,i.parent),i.parent.append(i.backdrop)),u(),h.waitTransitionEnd(n,{timeout:370})["finally"](function(e){return i.cleanupInteraction=p(),e})}function s(e,t,n,o){for(var r=a.getClosest(e.target,"MD-MENU-ITEM"),i=a.nodesToArray(t[0].children),d=i.indexOf(r),c=d+o;c>=0&&c<i.length;c+=o){var l=i[c].firstElementChild||i[c],m=u(l);if(m)break}}function u(e){return e&&-1!=e.getAttribute("tabindex")?(e.focus(),l[0].activeElement==e?!0:!1):void 0}function p(e,o,i){return i.isRemoved=!0,o.addClass("md-leave"),i.cleanupInteraction(),t.element(r).off("resize",i.resizeFn),t.element(r).off("orientationchange",i.resizeFn),i.resizeFn=n,h.waitTransitionEnd(o,{timeout:370})["finally"](function(){o.removeClass("md-active"),i.backdrop&&i.backdrop.remove(),o[0].parentNode===i.parent[0]&&i.parent[0].removeChild(o[0]),i.restoreScroll&&i.restoreScroll()})}function f(t,n){function o(e){e.top=Math.max(Math.min(e.top,g.bottom-m.offsetHeight),g.top),e.left=Math.max(Math.min(e.left,g.right-m.offsetWidth),g.left)}function r(){for(var t=0;t<s.children.length;++t)if("none"!=e.getComputedStyle(s.children[t]).display)return s.children[t]}if(!n.isRemoved){var a,d,l,m=t[0],s=t[0].firstElementChild,u=s.getBoundingClientRect(),p=n.parent[0],f=p.getBoundingClientRect(),h=n.target[0].querySelector("[md-menu-origin]")||n.target[0],b=h.getBoundingClientRect(),g={left:f.left+i,top:Math.max(f.top,0)+i,bottom:Math.max(f.bottom,Math.max(f.top,0)+f.height)-i,right:f.right-i},E=n.mdMenuCtrl.positionMode();if("target"==E.top||"target"==E.left||"target-right"==E.left){if(a=r(),!a)throw Error("Error positioning menu. No visible children.");a=a.firstElementChild||a,a=a.querySelector("[md-menu-align-target]")||a,d=a.getBoundingClientRect(),l={top:parseFloat(m.style.top||0),left:parseFloat(m.style.left||0)}}var v={},M="top ";switch(E.top){case"target":v.top=l.top+b.top-d.top;break;default:throw new Error('Invalid target mode "'+E.top+'" specified for md-menu on Y axis.')}switch(E.left){case"target":v.left=l.left+b.left-d.left,M+="left";break;case"target-right":v.left=b.right-u.width+(u.right-d.right),M+="right";break;default:throw new Error('Invalid target mode "'+E.left+'" specified for md-menu on X axis.')}var $=n.mdMenuCtrl.offsets();v.top+=$.top,v.left+=$.left,o(v),t.css({top:v.top+"px",left:v.left+"px"}),m.style[c.CSS.TRANSFORM_ORIGIN]=M,n.alreadyOpen||(m.style[c.CSS.TRANSFORM]="scale("+Math.min(b.width/m.offsetWidth,1)+","+Math.min(b.height/m.offsetHeight,1)+")")}}var h=a.dom.animator;return{parent:"body",onShow:m,onRemove:p,hasBackdrop:!0,disableParentScroll:!0,skipCompile:!0,preserveScope:!0,themable:!0}}var i=8;return r.$inject=["$$rAF","$window","$mdUtil","$mdTheming","$mdConstant","$document"],o("$mdMenu").setDefaults({methods:["target"],options:r})}t.module("material.components.menu").provider("$mdMenu",o),o.$inject=["$$interimElementProvider"]}(),function(){function e(e,t){function n(e){return e.attr("aria-valuemin",0),e.attr("aria-valuemax",100),e.attr("role","progressbar"),o}function o(n,o,i){t(o);var a=o[0],d=i.mdDiameter||48,c=d/48;a.style[e.CSS.TRANSFORM]="scale("+c+")",i.$observe("value",function(e){var t=r(e);o.attr("aria-valuenow",t)})}function r(e){return Math.max(0,Math.min(e||0,100))}return{restrict:"E",template:'<div class="md-spinner-wrapper"><div class="md-inner"><div class="md-gap"></div><div class="md-left"><div class="md-half-circle"></div></div><div class="md-right"><div class="md-half-circle"></div></div></div></div>',compile:n}}t.module("material.components.progressCircular",["material.core"]).directive("mdProgressCircular",e),e.$inject=["$mdConstant","$mdTheming"]}(),function(){function e(e,o,r){function i(e,t,n){return e.attr("aria-valuemin",0),e.attr("aria-valuemax",100),e.attr("role","progressbar"),a}function a(i,a,c){r(a);var l=a[0].querySelector(".md-bar1").style,m=a[0].querySelector(".md-bar2").style,s=t.element(a[0].querySelector(".md-container"));c.$observe("value",function(e){if("query"!=c.mdMode){var t=d(e);a.attr("aria-valuenow",t),m[o.CSS.TRANSFORM]=n[t]}}),c.$observe("mdBufferValue",function(e){l[o.CSS.TRANSFORM]=n[d(e)]}),e(function(){s.addClass("md-ready")})}function d(e){return e>100?100:0>e?0:Math.ceil(e||0)}return{restrict:"E",template:'<div class="md-container"><div class="md-dashed"></div><div class="md-bar md-bar1"></div><div class="md-bar md-bar2"></div></div>',compile:i}}t.module("material.components.progressLinear",["material.core"]).directive("mdProgressLinear",e),e.$inject=["$$rAF","$mdConstant","$mdTheming"];var n=function(){function e(e){var t=e/100,n=(e-100)/2;return"translateX("+n.toString()+"%) scale("+t.toString()+", 1)"}for(var t=new Array(101),n=0;101>n;n++)t[n]=e(n);return t}()}(),function(){function e(e,n,o,r){function i(i,a,d,c){function l(){a.hasClass("md-focused")||a.addClass("md-focused")}function m(o){var r=o.which||o.keyCode;switch(r){case n.KEY_CODE.LEFT_ARROW:case n.KEY_CODE.UP_ARROW:o.preventDefault(),s.selectPrevious(),l();break;case n.KEY_CODE.RIGHT_ARROW:case n.KEY_CODE.DOWN_ARROW:o.preventDefault(),s.selectNext(),l();break;case n.KEY_CODE.ENTER:var i=t.element(e.getClosest(a[0],"form"));i.length>0&&i.triggerHandler("submit")}}o(a);var s=c[0],u=c[1]||e.fakeNgModel();s.init(u),i.mouseActive=!1,a.attr({role:"radiogroup",tabIndex:a.attr("tabindex")||"0"}).on("keydown",m).on("mousedown",function(e){i.mouseActive=!0,r(function(){i.mouseActive=!1},100)}).on("focus",function(){i.mouseActive===!1&&s.$element.addClass("md-focused")}).on("blur",function(){s.$element.removeClass("md-focused")})}function a(e){this._radioButtonRenderFns=[],this.$element=e}function d(){return{init:function(e){this._ngModelCtrl=e,this._ngModelCtrl.$render=t.bind(this,this.render)},add:function(e){this._radioButtonRenderFns.push(e)},remove:function(e){var t=this._radioButtonRenderFns.indexOf(e);-1!==t&&this._radioButtonRenderFns.splice(t,1)},render:function(){this._radioButtonRenderFns.forEach(function(e){e()})},setViewValue:function(e,t){this._ngModelCtrl.$setViewValue(e,t),this.render()},getViewValue:function(){return this._ngModelCtrl.$viewValue},selectNext:function(){return c(this.$element,1)},selectPrevious:function(){return c(this.$element,-1)},setActiveDescendant:function(e){this.$element.attr("aria-activedescendant",e)}}}function c(n,o){var r=e.iterator(n[0].querySelectorAll("md-radio-button"),!0);if(r.count()){var i=function(e){return!t.element(e).attr("disabled")},a=n[0].querySelector("md-radio-button.md-checked"),d=r[0>o?"previous":"next"](a,i)||r.first();t.element(d).triggerHandler("click")}}return a.prototype=d(),{restrict:"E",controller:["$element",a],require:["mdRadioGroup","?ngModel"],link:{pre:i}}}function n(e,t,n){function o(o,i,a,d){function c(e){i[0].hasAttribute("disabled")||o.$apply(function(){d.setViewValue(a.value,e&&e.type)})}function l(){var e=d.getViewValue()==a.value;e!==s&&(s=e,i.attr("aria-checked",e),e?(i.addClass(r),d.setActiveDescendant(i.attr("id"))):i.removeClass(r))}function m(n,o){function r(){return a.id||"radio_"+t.nextUid()}o.ariaId=r(),n.attr({id:o.ariaId,role:"radio","aria-checked":"false"}),e.expectWithText(n,"aria-label")}var s;n(i),m(i,o),d.add(l),a.$observe("value",l),i.on("click",c).on("$destroy",function(){d.remove(l)})}var r="md-checked";return{restrict:"E",require:"^mdRadioGroup",transclude:!0,template:'<div class="md-container" md-ink-ripple md-ink-ripple-checkbox><div class="md-off"></div><div class="md-on"></div></div><div ng-transclude class="md-label"></div>',link:o}}t.module("material.components.radioButton",["material.core"]).directive("mdRadioGroup",e).directive("mdRadioButton",n),e.$inject=["$mdUtil","$mdConstant","$mdTheming","$timeout"],n.$inject=["$mdAria","$mdUtil","$mdTheming"]}(),function(){function e(e,o,r,i,a,d,c){function l(a,l){var m=t.element("<md-select-value><span></span></md-select-value>");if(m.append('<span class="md-select-icon" aria-hidden="true"></span>'),m.addClass("md-select-value"),m[0].hasAttribute("id")||m.attr("id","select_value_label_"+o.nextUid()),a.find("md-content").length||a.append(t.element("<md-content>").append(a.contents())),l.mdOnOpen&&a.find("md-content").prepend(t.element("<md-progress-circular>").attr("md-mode","indeterminate").attr("ng-hide","$$loadingAsyncDone").wrap("<div>").parent()),l.name){var s=t.element('<select class="md-visually-hidden">');s.attr({name:"."+l.name,"ng-model":l.ngModel,"aria-hidden":"true",tabindex:"-1"});var u=a.find("md-option");t.forEach(u,function(e){var n=t.element("<option>"+e.innerHTML+"</option>");e.hasAttribute("ng-value")?n.attr("ng-value",e.getAttribute("ng-value")):e.hasAttribute("value")&&n.attr("value",e.getAttribute("value")),s.append(n)}),a.parent().append(s)}var p='<div class="md-select-menu-container"><md-select-menu '+(t.isDefined(l.multiple)?"multiple":"")+">"+a.html()+"</md-select-menu></div>";return a.empty().append(m),l.tabindex=l.tabindex||"0",function(a,l,m,s){function u(){var e=l.attr("placeholder");!e&&$&&$.label&&(e=$.label.text()),i.expect(l,"aria-label",e)}function f(){x&&(_=_||x.find("md-select-menu").controller("mdSelectMenu"),A.setLabelText(_.selectedLabels()))}function h(){$&&$.setHasValue(_.selectedLabels().length>0||(l[0].validity||{}).badInput)}function b(){x=t.element(p);var e=x.find("md-select-menu");e.data("$ngModelController",T),e.data("$mdSelectController",A),N=a.$new(),r.inherit(x,l),x[0].setAttribute("class",x[0].getAttribute("class")+" "+l.attr("md-container-class")),x=d(x)(N),_=x.find("md-select-menu").controller("mdSelectMenu")}function g(e){var n=[32,13,38,40];if(-1!=n.indexOf(e.keyCode))e.preventDefault(),E(e);else if(e.keyCode<=90&&e.keyCode>=31){e.preventDefault();var o=_.optNodeForKeyboardSearch(e);if(!o)return;var r=t.element(o).controller("mdOption");_.isMultiple||_.deselect(Object.keys(_.selected)[0]),_.select(r.hashKey,r.value),_.refreshViewValue(),T.$render()}}function E(){a.$apply("isOpen = true"),e.show({scope:N,preserveScope:!0,skipCompile:!0,element:x,target:l[0],hasBackdrop:!0,loadingAsync:m.mdOnOpen?a.$eval(m.mdOnOpen)||!0:!1}).then(function(){v=!1})}var v,M,$=s[0],A=s[1],T=s[2],C=s[3],y=l.find("md-select-value"),w=t.isDefined(m.readonly);if($){if($.input)throw new Error("<md-input-container> can only have *one* child <input>, <textarea> or <select> element!");$.input=l,$.label||i.expect(l,"aria-label",l.attr("placeholder"));var k=$&&$.isErrorGetter||function(){return T.$invalid&&T.$touched};a.$watch(k,$.setInvalid)}var x,N,_;if(b(),r(l),m.name&&C){var H=l.parent()[0].querySelector('select[name=".'+m.name+'"]'),S=t.element(H).controller();S&&C.$removeControl(S)}var I=T.$render;T.$render=function(){I(),f(),h()},A.setLabelText=function(e){A.setIsPlaceholder(!e);var t=m.placeholder||($&&$.label?$.label.text():"");e=e||t||"";var n=y.children().eq(0);n.text(e)},A.setIsPlaceholder=function(e){e?(y.addClass("md-select-placeholder"),$&&$.label&&$.label.addClass("md-placeholder md-static")):(y.removeClass("md-select-placeholder"),$&&$.label&&$.label.removeClass("md-placeholder"))},w||l.on("focus",function(e){$&&$.element.hasClass("md-input-has-value")&&$.setFocused(!0)}).on("blur",function(e){$&&$.setFocused(!1),h()}),A.triggerClose=function(){c(m.mdOnClose)(a)},a.$$postDigest(function(){u(),f()});var O;m.$observe("ngMultiple",function(e){O&&O();var t=c(e);O=a.$watch(function(){return t(a)},function(e,t){(e!==n||t!==n)&&(e?l.attr("multiple","multiple"):l.removeAttr("multiple"),x&&(_.setMultiple(e),I=T.$render,T.$render=function(){I(),f()},_.refreshViewValue(),T.$render()))})}),m.$observe("disabled",function(e){"string"==typeof e&&(e=!0),(M===n||M!==e)&&(M=e,e?(l.attr({tabindex:-1,"aria-disabled":"true"}),l.off("click",E),l.off("keydown",g)):(l.attr({tabindex:m.tabindex,"aria-disabled":"false"}),l.on("click",E),l.on("keydown",g)))}),m.disabled||m.ngDisabled||(l.attr({tabindex:m.tabindex,"aria-disabled":"false"}),l.on("click",E),l.on("keydown",g));var D={role:"combobox","aria-expanded":"false"};l[0].hasAttribute("id")||(D.id="select_"+o.nextUid()),l.attr(D),a.$on("$destroy",function(){v?e.hide()["finally"](function(){x.remove()}):x.remove(),$&&($.setFocused(!1),$.setHasValue(!1),$.input=null)})}}return{restrict:"E",require:["^?mdInputContainer","mdSelect","ngModel","?^form"],compile:l,controller:function(){}}}function o(e,o,r){function i(e,n,i,a){function d(){n.attr({id:"select_menu_"+o.nextUid(),role:"listbox","aria-multiselectable":m.isMultiple?"true":"false"})}function c(e){(13==e.keyCode||32==e.keyCode)&&l(e)}function l(n){var r=o.getClosest(n.target,"md-option"),i=r&&t.element(r).data("$mdOptionController");if(r&&i){if(r.hasAttribute("disabled"))return n.stopImmediatePropagation(),!1;var a=m.hashGetter(i.value),d=t.isDefined(m.selected[a]);e.$apply(function(){m.isMultiple?d?m.deselect(a):m.select(a,i.value):d||(m.deselect(Object.keys(m.selected)[0]),m.select(a,i.value)),m.refreshViewValue()})}}var m=a[0],s=a[1];r(n),n.on("click",l),n.on("keypress",c),s&&m.init(s),d()}function a(r,i,a){function d(){var e=m.ngModel.$modelValue||m.ngModel.$viewValue;if(t.isArray(e)){var n=Object.keys(m.selected),o=e.map(m.hashGetter),r=n.filter(function(e){return-1===o.indexOf(e)});r.forEach(m.deselect),o.forEach(function(t,n){m.select(t,e[n])})}}function l(){var e=m.ngModel.$viewValue||m.ngModel.$modelValue;Object.keys(m.selected).forEach(m.deselect),m.select(m.hashGetter(e),e)}var m=this;m.isMultiple=t.isDefined(i.multiple),m.selected={},m.options={},r.$watch(function(){return m.options},function(){m.ngModel.$render()},!0);var s;m.setMultiple=function(e){function n(e,n){return t.isArray(e||n||[])}var o=m.ngModel;m.isMultiple=e,
s&&s(),m.isMultiple?(o.$validators["md-multiple"]=n,o.$render=d,r.$watchCollection(i.ngModel,function(e){n(e)&&d(e)})):(delete o.$validators["md-multiple"],o.$render=l)};var u,p,f,h="",b=300;m.optNodeForKeyboardSearch=function(e){u&&clearTimeout(u),u=setTimeout(function(){u=n,h="",f=n,p=n},b),h+=String.fromCharCode(e.keyCode);var o=new RegExp("^"+h,"i");p||(p=a.find("md-option"),f=new Array(p.length),t.forEach(p,function(e,t){f[t]=e.textContent.trim()}));for(var r=0;r<f.length;++r)if(o.test(f[r]))return p[r]},m.init=function(n){if(m.ngModel=n,n.$options&&n.$options.trackBy){var o={},i=e(n.$options.trackBy);m.hashGetter=function(e,t){return o.$value=e,i(t||r,o)}}else m.hashGetter=function(e){return t.isObject(e)?"object_"+(e.$$mdSelectId||(e.$$mdSelectId=++c)):e};m.setMultiple(m.isMultiple)},m.selectedLabels=function(){var e=o.nodesToArray(a[0].querySelectorAll("md-option[selected]"));return e.length?e.map(function(e){return e.textContent}).join(", "):""},m.select=function(e,t){var n=m.options[e];n&&n.setSelected(!0),m.selected[e]=t},m.deselect=function(e){var t=m.options[e];t&&t.setSelected(!1),delete m.selected[e]},m.addOption=function(e,n){if(t.isDefined(m.options[e]))throw new Error('Duplicate md-option values are not allowed in a select. Duplicate value "'+n.value+'" found.');m.options[e]=n,t.isDefined(m.selected[e])&&(m.select(e,n.value),m.refreshViewValue())},m.removeOption=function(e){delete m.options[e]},m.refreshViewValue=function(){var e,t=[];for(var n in m.selected)t.push((e=m.options[n])?e.value:m.selected[n]);m.ngModel.$setViewValue(m.isMultiple?t:t[0])}}return a.$inject=["$scope","$attrs","$element"],{restrict:"E",require:["mdSelectMenu","?ngModel"],controller:a,link:{pre:i}}}function r(e,n){function o(e,n){return e.append(t.element('<div class="md-text">').append(e.contents())),e.attr("tabindex",n.tabindex||"0"),r}function r(o,r,i,a){function d(e,t){var n=m.hashGetter(t,o),r=m.hashGetter(e,o);l.hashKey=r,l.value=e,m.removeOption(n,l),m.addOption(r,l)}function c(){var e={role:"option","aria-selected":"false"};r[0].hasAttribute("id")||(e.id="select_option_"+n.nextUid()),r.attr(e)}var l=a[0],m=a[1];t.isDefined(i.ngValue)?o.$watch(i.ngValue,d):t.isDefined(i.value)?d(i.value):o.$watch(function(){return r.text()},d),i.$observe("disabled",function(e){e?r.attr("tabindex","-1"):r.attr("tabindex","0")}),o.$$postDigest(function(){i.$observe("selected",function(e){t.isDefined(e)&&("string"==typeof e&&(e=!0),e?(m.isMultiple||m.deselect(Object.keys(m.selected)[0]),m.select(l.hashKey,l.value)):m.deselect(l.hashKey),m.refreshViewValue(),m.ngModel.$render())})}),e.attach(o,r),c(),o.$on("$destroy",function(){m.removeOption(l.hashKey,l)})}function i(e){this.selected=!1,this.setSelected=function(t){t&&!this.selected?e.attr({selected:"selected","aria-selected":"true"}):!t&&this.selected&&(e.removeAttr("selected"),e.attr("aria-selected","false")),this.selected=t}}return i.$inject=["$element"],{restrict:"E",require:["mdOption","^^mdSelectMenu"],controller:i,compile:o}}function i(){function e(e,n){var o=e.find("label");o.length||(o=t.element("<label>"),e.prepend(o)),n.label&&o.text(n.label)}return{restrict:"E",compile:e}}function a(e){function o(e,o,a,c,l,m,s,u){function p(r,i,d){function u(){d.target.attr("aria-expanded","true")}function p(){function t(e){f=d.selectEl[0].getElementsByTagName("md-option");var t,o=c.nodesToArray(f),r=o.indexOf(d.focusedNode);do-1===r?r=0:"next"===e&&r<o.length-1?r++:"prev"===e&&r>0&&r--,t=o[r],t.hasAttribute("disabled")&&(t=n);while(!t&&r<o.length-1&&r>0);t&&t.focus(),d.focusedNode=t}function r(){t("next")}function a(){t("prev")}function l(){m.isMultiple||(d.restoreFocus=!0,c.nextTick(function(){e.hide(m.ngModel.$viewValue)},!0))}if(!d.isRemoved){var m=d.selectEl.controller("mdSelectMenu")||{};i.addClass("md-clickable"),d.backdrop&&d.backdrop.on("click",function(t){t.preventDefault(),t.stopPropagation(),d.restoreFocus=!1,c.nextTick(e.hide,!0)}),d.selectEl.on("keydown",function(t){switch(t.keyCode){case o.KEY_CODE.SPACE:case o.KEY_CODE.ENTER:var n=c.getClosest(t.target,"md-option");n&&(d.selectEl.triggerHandler({type:"click",target:n}),t.preventDefault());break;case o.KEY_CODE.TAB:case o.KEY_CODE.ESCAPE:t.preventDefault(),d.restoreFocus=!0,c.nextTick(e.hide,!0)}}),d.selectEl.on("keydown",function(e){switch(e.keyCode){case o.KEY_CODE.UP_ARROW:return a();case o.KEY_CODE.DOWN_ARROW:return r();default:if(e.keyCode>=31&&e.keyCode<=90){var t=d.selectEl.controller("mdSelectMenu").optNodeForKeyboardSearch(e);d.focusedNode=t||d.focusedNode,t&&t.focus()}}}),d.selectEl.on("click",l),d.selectEl.on("keydown",function(e){(32==e.keyCode||13==e.keyCode)&&l()})}}if(!d.target)throw new Error('$mdSelect.show() expected a target element in options.target but got "'+d.target+'"!');t.extend(d,{isRemoved:!1,target:t.element(d.target),parent:t.element(d.parent),selectEl:i.find("md-select-menu"),contentEl:i.find("md-content"),backdrop:d.hasBackdrop&&c.createBackdrop(r,"md-select-backdrop md-click-catcher")}),d.resizeFn=function(){a(function(){a(function(){h(r,i,d)})})},t.element(m).on("resize",d.resizeFn),t.element(m).on("orientationchange",d.resizeFn),u(),i.removeClass("md-leave");var f=d.selectEl[0].getElementsByTagName("md-option");return d.loadingAsync&&d.loadingAsync.then?d.loadingAsync.then(function(){r.$$loadingAsyncDone=!0,a(function(){a(function(){d.isRemoved||h(r,i,d)})})}):d.loadingAsync&&(r.$$loadingAsyncDone=!0),d.disableParentScroll&&!c.getClosest(d.target,"MD-DIALOG")?d.restoreScroll=c.disableScrollAround(d.element):d.disableParentScroll=!1,d.backdrop&&(l.inherit(d.backdrop,d.target),d.parent.append(d.backdrop)),d.parent.append(i),a(function(){a(function(){d.isRemoved||h(r,i,d)})}),d.isRemoved?s.reject(!0):b.waitTransitionEnd(d.selectEl,{timeout:470})["finally"](function(){p()})}function f(e,o,r){r.isRemoved=!0,r.target.attr("aria-expanded","false"),r.selectEl.off("keydown"),t.element(m).off("resize",r.resizeFn),t.element(m).off("orientationchange",r.resizefn),r.resizeFn=n,o.addClass("md-leave").removeClass("md-clickable");var i=r.selectEl.controller("mdSelect");return i&&i.setLabelText(r.selectEl.controller("mdSelectMenu").selectedLabels()),r.backdrop&&r.backdrop.remove(),b.waitTransitionEnd(o,{timeout:370})["finally"](function(){i&&i.triggerClose(),o.removeClass("md-active"),o[0].parentNode===r.parent[0]&&r.parent[0].removeChild(o[0]),r.disableParentScroll&&r.restoreScroll(),r.restoreFocus&&r.target.focus()})}function h(e,t,n){var l,s=t[0],u=n.target[0].firstElementChild,p=n.parent[0],f=n.selectEl[0],h=n.contentEl[0],b=p.getBoundingClientRect(),g=u.getBoundingClientRect(),E=!1,v={left:b.left+d,top:d,bottom:b.height-d,right:b.width-d-(c.floatingScrollbars()?16:0)},M={top:g.top-v.top,left:g.left-v.left,right:v.right-(g.left+g.width),bottom:v.bottom-(g.top+g.height)},$=b.width-2*d,A=h.scrollHeight>h.offsetHeight,T=f.querySelector("md-option[selected]"),C=f.getElementsByTagName("md-option"),y=f.getElementsByTagName("md-optgroup");l=T?T:y.length?y[0]:C.length?C[0]:h.firstElementChild||h,h.offsetWidth>$&&(h.style["max-width"]=$+"px"),E&&(h.style["min-width"]=g.width+"px"),A&&f.classList.add("md-overflow");var w=l;"MD-OPTGROUP"===(w.tagName||"").toUpperCase()&&(w=C[0]||h.firstElementChild||h,l=w);var k=f.getBoundingClientRect(),x=i(l);if(l){var N=m.getComputedStyle(l);x.paddingLeft=parseInt(N.paddingLeft,10)||0,x.paddingRight=parseInt(N.paddingRight,10)||0}if(A){var _=h.offsetHeight/2;h.scrollTop=x.top+x.height/2-_,M.top<_?h.scrollTop=Math.min(x.top,h.scrollTop+_-M.top):M.bottom<_&&(h.scrollTop=Math.max(x.top+x.height-k.height,h.scrollTop-_+M.bottom))}var H,S,I;E?(H=g.left,S=g.top+g.height,I="50% 0",S+k.height>v.bottom&&(S=g.top-k.height,I="50% 100%")):(H=g.left+x.left-x.paddingLeft+2,S=Math.floor(g.top+g.height/2-x.height/2-x.top+h.scrollTop)+2,I=x.left+g.width/2+"px "+(x.top+x.height/2-h.scrollTop)+"px 0px",s.style.minWidth=g.width+x.paddingLeft+x.paddingRight+"px");var O=s.getBoundingClientRect();s.style.left=r(v.left,H,v.right-O.width)+"px",s.style.top=r(v.top,S,v.bottom-O.height)+"px",f.style[o.CSS.TRANSFORM_ORIGIN]=I,f.style[o.CSS.TRANSFORM]="scale("+Math.min(g.width/k.width,1)+","+Math.min(g.height/k.height,1)+")",a(function(){t.addClass("md-active"),f.style[o.CSS.TRANSFORM]="",w&&!w.hasAttribute("disabled")&&(n.focusedNode=w,w.focus())})}var b=c.dom.animator;return{parent:"body",onShow:p,onRemove:f,hasBackdrop:!0,disableParentScroll:!0,themable:!0}}function r(e,t,n){return Math.max(e,Math.min(t,n))}function i(e){return e?{left:e.offsetLeft,top:e.offsetTop,width:e.offsetWidth,height:e.offsetHeight}:{left:0,top:0,width:0,height:0}}return o.$inject=["$mdSelect","$mdConstant","$$rAF","$mdUtil","$mdTheming","$window","$q","$compile"],e("$mdSelect").setDefaults({methods:["target"],options:o})}var d=8,c=0;t.module("material.components.select",["material.core","material.components.backdrop"]).directive("mdSelect",e).directive("mdSelectMenu",o).directive("mdOption",r).directive("mdOptgroup",i).provider("$mdSelect",a),e.$inject=["$mdSelect","$mdUtil","$mdTheming","$mdAria","$interpolate","$compile","$parse"],o.$inject=["$parse","$mdUtil","$mdTheming"],r.$inject=["$mdButtonInkRipple","$mdUtil"],a.$inject=["$$interimElementProvider"]}(),function(){function e(e,n){return function(o){function r(){return e.when(o).then(function(e){return d=e,e})}var i,a="SideNav '"+o+"' is not available!",d=e.get(o);return d||e.notFoundError(o),i={isOpen:function(){return d&&d.isOpen()},isLockedOpen:function(){return d&&d.isLockedOpen()},toggle:function(){return d?d.toggle():n.reject(a)},open:function(){return d?d.open():n.reject(a)},close:function(){return d?d.close():n.reject(a)},then:function(e){var o=d?n.when(d):r();return o.then(e||t.noop)}}}}function o(){return{restrict:"A",require:"^mdSidenav",link:function(e,t,n,o){o.focusElement(t)}}}function r(e,o,r,i,a,d,c,l,m,s){function u(d,u,p,f){function h(e,t){d.isLockedOpen=e,e===t?u.toggleClass("md-locked-open",!!e):a[e?"addClass":"removeClass"](u,"md-locked-open"),w.toggleClass("md-locked-open",!!e)}function b(e){var t=u.parent(),n=f.focusElement();return t[e?"on":"off"]("keydown",v),w[e?"on":"off"]("click",M),e&&(A=s[0].activeElement),g(e),T=m.all([e?a.enter(w,t):a.leave(w),a[e?"removeClass":"addClass"](u,"md-closed")]).then(function(){d.isOpen&&n&&n.focus()})}function g(e){var o=u.parent();e&&!$?($=o.css("overflow"),o.css("overflow","hidden")):t.isDefined($)&&(o.css("overflow",$),$=n)}function E(e){if(d.isOpen==e)return m.when(!0);var t=m.defer();return d.isOpen=e,o.nextTick(function(){T.then(function(e){d.isOpen||(A&&A.focus(),A=null),t.resolve(e)})}),t.promise}function v(e){var t=e.keyCode===r.KEY_CODE.ESCAPE;return t?M(e):m.when(!0)}function M(e){return e.preventDefault(),e.stopPropagation(),f.close()}var $,A=null,T=m.when(!0),C=c(p.mdIsLockedOpen),y=function(){return C(d.$parent,{$media:function(t){return l.warn("$media is deprecated for is-locked-open. Use $mdMedia instead."),e(t)},$mdMedia:e})},w=o.createBackdrop(d,"md-sidenav-backdrop md-opaque ng-enter");u.on("$destroy",f.destroy),i.inherit(w,u),d.$watch(y,h),d.$watch("isOpen",b),f.$toggleOpen=E,f.focusElement(f.focusElement()||u)}return{restrict:"E",scope:{isOpen:"=?mdIsOpen"},controller:"$mdSidenavController",compile:function(e){return e.addClass("md-closed"),e.attr("tabIndex","-1"),u}}}function i(e,n,o,r,i){var a,d=this;d.isOpen=function(){return!!e.isOpen},d.isLockedOpen=function(){return!!e.isLockedOpen},d.open=function(){return d.$toggleOpen(!0)},d.close=function(){return d.$toggleOpen(!1)},d.toggle=function(){return d.$toggleOpen(!e.isOpen)},d.focusElement=function(e){return t.isDefined(e)&&(a=e),a},d.$toggleOpen=function(t){return i.when(e.isOpen=t)},d.destroy=r.register(d,o.mdComponentId)}t.module("material.components.sidenav",["material.core","material.components.backdrop"]).factory("$mdSidenav",e).directive("mdSidenav",r).directive("mdSidenavFocus",o).controller("$mdSidenavController",i),e.$inject=["$mdComponentRegistry","$q"],r.$inject=["$mdMedia","$mdUtil","$mdConstant","$mdTheming","$animate","$compile","$parse","$log","$q","$document"],i.$inject=["$scope","$element","$attrs","$mdComponentRegistry","$q"]}(),function(){function e(e,n,o,r,i,a,d,c,l){function m(e,t){return e.attr({tabIndex:0,role:"slider"}),o.expect(e,"aria-label"),s}function s(o,m,s,u){function p(){v(),T(),E()}function f(e){G=parseFloat(e),m.attr("aria-valuemin",e),p()}function h(e){X=parseFloat(e),m.attr("aria-valuemax",e),p()}function b(e){Q=parseFloat(e),E()}function g(e){m.attr("aria-disabled",!!e)}function E(){if(t.isDefined(s.mdDiscrete)&&!t.isUndefined(Q)){if(0>=Q){var e="Slider step value must be greater than zero when in discrete mode";throw l.error(e),new Error(e)}var o=Math.floor((X-G)/Q);if(!Z){Z=t.element('<canvas style="position:absolute;">'),U.append(Z);var r=n.getComputedStyle(U[0]);J=Z[0].getContext("2d"),J.fillStyle=r.backgroundColor||"black"}var i=M();Z[0].width=i.width,Z[0].height=i.height;for(var a,d=0;o>=d;d++)a=Math.floor(i.width*(d/o)),J.fillRect(a-1,0,2,i.height)}}function v(){ee=q[0].getBoundingClientRect()}function M(){return Y(),ee}function $(e){if(!m[0].hasAttribute("disabled")){var t;e.keyCode===i.KEY_CODE.LEFT_ARROW?t=-Q:e.keyCode===i.KEY_CODE.RIGHT_ARROW&&(t=Q),t&&((e.metaKey||e.ctrlKey||e.altKey)&&(t*=4),e.preventDefault(),e.stopPropagation(),o.$evalAsync(function(){A(u.$viewValue+t)}))}}function A(e){u.$setViewValue(C(y(e)))}function T(){isNaN(u.$viewValue)&&(u.$viewValue=u.$modelValue);var e=(u.$viewValue-G)/(X-G);o.modelValue=u.$viewValue,m.attr("aria-valuenow",u.$viewValue),w(e),z.text(u.$viewValue)}function C(e){return t.isNumber(e)?Math.max(G,Math.min(X,e)):void 0}function y(e){if(t.isNumber(e)){var n=Math.round(e/Q)*Q;return Math.round(1e3*n)/1e3}}function w(e){V.css("width",100*e+"%"),j.css("left",100*e+"%"),m.toggleClass("md-min",0===e)}function k(e){if(!F()){m.addClass("active"),m[0].focus(),v();var t=R(D(e.pointer.x)),n=C(y(t));o.$apply(function(){A(n),w(L(n))})}}function x(e){if(!F()){m.removeClass("dragging active");var t=R(D(e.pointer.x)),n=C(y(t));o.$apply(function(){A(n),T()})}}function N(e){F()||(te=!0,e.stopPropagation(),m.addClass("dragging"),S(e))}function _(e){te&&(e.stopPropagation(),S(e))}function H(e){te&&(e.stopPropagation(),te=!1)}function S(e){ne?O(e.pointer.x):I(e.pointer.x)}function I(e){o.$evalAsync(function(){A(R(D(e)))})}function O(e){var t=R(D(e)),n=C(y(t));w(D(e)),z.text(n)}function D(e){return Math.max(0,Math.min(1,(e-ee.left)/ee.width))}function R(e){return G+e*(X-G)}function L(e){return(e-G)/(X-G)}a(m),u=u||{$setViewValue:function(e){this.$viewValue=e,this.$viewChangeListeners.forEach(function(e){e()})},$parsers:[],$formatters:[],$viewChangeListeners:[]};var P=s.ngDisabled&&c(s.ngDisabled),F=P?function(){return P(o.$parent)}:t.noop,B=t.element(m[0].querySelector(".md-thumb")),z=t.element(m[0].querySelector(".md-thumb-text")),j=B.parent(),q=t.element(m[0].querySelector(".md-track-container")),V=t.element(m[0].querySelector(".md-track-fill")),U=t.element(m[0].querySelector(".md-track-ticks")),Y=r.throttle(v,5e3);t.isDefined(s.min)?s.$observe("min",f):f(0),t.isDefined(s.max)?s.$observe("max",h):h(100),t.isDefined(s.step)?s.$observe("step",b):b(1);var W=t.noop;s.ngDisabled&&(W=o.$parent.$watch(s.ngDisabled,g)),d.register(m,"drag"),m.on("keydown",$).on("$md.pressdown",k).on("$md.pressup",x).on("$md.dragstart",N).on("$md.drag",_).on("$md.dragend",H),setTimeout(p);var K=e.throttle(p);t.element(n).on("resize",K),o.$on("$destroy",function(){t.element(n).off("resize",K),W()}),u.$render=T,u.$viewChangeListeners.push(T),u.$formatters.push(C),u.$formatters.push(y);var G,X,Q,Z,J,ee={};v();var te=!1,ne=t.isDefined(s.mdDiscrete)}return{scope:{},require:"?ngModel",template:'<div class="md-slider-wrapper">        <div class="md-track-container">          <div class="md-track"></div>          <div class="md-track md-track-fill"></div>          <div class="md-track-ticks"></div>        </div>        <div class="md-thumb-container">          <div class="md-thumb"></div>          <div class="md-focus-thumb"></div>          <div class="md-focus-ring"></div>          <div class="md-sign">            <span class="md-thumb-text"></span>          </div>          <div class="md-disabled-thumb"></div>        </div>      </div>',compile:m}}t.module("material.components.slider",["material.core"]).directive("mdSlider",e),e.$inject=["$$rAF","$window","$mdAria","$mdUtil","$mdConstant","$mdTheming","$mdGesture","$parse","$log"]}(),function(){function e(e,o,r,i,a){function d(e){function t(e,t){t.addClass("md-sticky-clone"),t.css("top",b+"px");var n={element:e,clone:t};return h.items.push(n),p.parent().prepend(n.clone),f(),function(){h.items.forEach(function(t,n){t.element[0]===e[0]&&(h.items.splice(n,1),t.clone.remove())}),f()}}function r(){h.items.forEach(d),h.items=h.items.sort(function(e,t){return e.top<t.top?-1:1});for(var e,t=p.prop("scrollTop"),n=h.items.length-1;n>=0;n--)if(t>h.items[n].top){e=h.items[n];break}m(e)}function d(e){var t=e.element[0];for(e.top=0,e.left=0;t&&t!==p[0];)e.top+=t.offsetTop,e.left+=t.offsetLeft,t=t.offsetParent;e.height=e.element.prop("offsetHeight"),e.clone.css("margin-left",e.left+"px"),a.floatingScrollbars()&&e.clone.css("margin-right","0")}function c(){var e=p.prop("scrollTop"),t=e>(c.prevScrollTop||0);c.prevScrollTop=e,0===e?m(null):t&&h.next?h.next.top-e<=0?m(h.next):h.current&&(h.next.top-e<=h.next.height?u(h.current,h.next.top-h.next.height-e):u(h.current,null)):!t&&h.current&&(e<h.current.top&&m(h.prev),h.current&&h.next&&(e>=h.next.top-h.current.height?u(h.current,h.next.top-e-h.current.height):u(h.current,null)))}function m(e){if(h.current!==e){h.current&&(u(h.current,null),s(h.current,null)),e&&s(e,"active"),h.current=e;var t=h.items.indexOf(e);h.next=h.items[t+1],h.prev=h.items[t-1],s(h.next,"next"),s(h.prev,"prev")}}function s(e,t){e&&e.state!==t&&(e.state&&(e.clone.attr("sticky-prev-state",e.state),e.element.attr("sticky-prev-state",e.state)),e.clone.attr("sticky-state",t),e.element.attr("sticky-state",t),e.state=t)}function u(e,t){e&&(null===t||t===n?e.translateY&&(e.translateY=null,e.clone.css(o.CSS.TRANSFORM,"")):(e.translateY=t,e.clone.css(o.CSS.TRANSFORM,"translate3d("+e.left+"px,"+t+"px,0)")))}var p=e.$element,f=i.throttle(r);l(p),p.on("$scrollstart",f),p.on("$scroll",c);var h,b=p.prop("offsetTop");return h={prev:null,current:null,next:null,items:[],add:t,refreshElements:r}}function c(n){var o,r=t.element("<div>");e[0].body.appendChild(r[0]);for(var i=["sticky","-webkit-sticky"],a=0;a<i.length;++a)if(r.css({position:i[a],top:0,"z-index":2}),r.css("position")==i[a]){o=i[a];break}return r.remove(),o}function l(e){function t(){+a.now()-o>r?(n=!1,e.triggerHandler("$scrollend")):(e.triggerHandler("$scroll"),i(t))}var n,o,r=200;e.on("scroll touchmove",function(){n||(n=!0,i(t),e.triggerHandler("$scrollstart")),e.triggerHandler("$scroll"),o=+a.now()})}var m=c();return function(e,t,n){var o=t.controller("mdContent");if(o)if(m)t.css({position:m,top:0,"z-index":2});else{var r=o.$element.data("$$sticky");r||(r=d(o),o.$element.data("$$sticky",r));var i=r.add(t,n||t.clone());e.$on("$destroy",i)}}}t.module("material.components.sticky",["material.core","material.components.content"]).factory("$mdSticky",e),e.$inject=["$document","$mdConstant","$compile","$$rAF","$mdUtil"]}(),function(){function e(e,n,o){return{restrict:"E",replace:!0,transclude:!0,template:'<h2 class="md-subheader"><div class="md-subheader-inner"><span class="md-subheader-content"></span></div></h2>',compile:function(r,i,a){return function(r,i,d){function c(e){return t.element(e[0].querySelector(".md-subheader-content"))}o(i);var l=i[0].outerHTML;a(r,function(e){c(i).append(e)}),i.hasClass("md-no-sticky")||a(r,function(o){var a=n(t.element(l))(r);c(a).append(o),e(r,i,a)})}}}}t.module("material.components.subheader",["material.core","material.components.sticky"]).directive("mdSubheader",e),e.$inject=["$mdSticky","$compile","$mdTheming"]}(),function(){function e(e){function t(e){function t(t,r,i){var a=e(i[n]);r.on(o,function(e){t.$apply(function(){a(t,{$event:e})})})}return{restrict:"A",link:t}}var n="md"+e,o="$md."+e.toLowerCase();return t.$inject=["$parse"],t}t.module("material.components.swipe",["material.core"]).directive("mdSwipeLeft",e("SwipeLeft")).directive("mdSwipeRight",e("SwipeRight"))}(),function(){function e(e,n,o,r,i,a,d,c){function l(e,n){var r=m.compile(e,n);return e.addClass("md-dragging"),function(e,n,l,m){function s(t){h(e)||(t.stopPropagation(),n.addClass("md-dragging"),E={width:b.prop("offsetWidth")},n.removeClass("transition"))}function u(e){if(E){e.stopPropagation(),e.srcEvent&&e.srcEvent.preventDefault();var t=e.pointer.distanceX/E.width,n=m.$viewValue?1+t:t;n=Math.max(0,Math.min(1,n)),b.css(i.CSS.TRANSFORM,"translate3d("+100*n+"%,0,0)"),E.translate=n}}function p(e){if(E){e.stopPropagation(),n.removeClass("md-dragging"),b.css(i.CSS.TRANSFORM,"");var t=m.$viewValue?E.translate<.5:E.translate>.5;t&&f(!m.$viewValue),E=null}}function f(t){e.$apply(function(){m.$setViewValue(t),m.$render()})}m=m||o.fakeNgModel();var h=a(l.ngDisabled),b=t.element(n[0].querySelector(".md-thumb-container")),g=t.element(n[0].querySelector(".md-container"));d(function(){n.removeClass("md-dragging")}),r(e,n,l,m),t.isDefined(l.ngDisabled)&&e.$watch(h,function(e){n.attr("tabindex",e?-1:0)}),c.register(g,"drag"),g.on("$md.dragstart",s).on("$md.drag",u).on("$md.dragend",p);var E}}var m=e[0];return{restrict:"E",priority:210,transclude:!0,template:'<div class="md-container"><div class="md-bar"></div><div class="md-thumb-container"><div class="md-thumb" md-ink-ripple md-ink-ripple-checkbox></div></div></div><div ng-transclude class="md-label"></div>',require:"?ngModel",compile:l}}t.module("material.components.switch",["material.core","material.components.checkbox"]).directive("mdSwitch",e),e.$inject=["mdCheckboxDirective","$mdTheming","$mdUtil","$document","$mdConstant","$parse","$$rAF","$mdGesture"]}(),function(){t.module("material.components.tabs",["material.core","material.components.icon"])}(),function(){function e(){return{restrict:"E"}}function n(e){function t(e,t,o){function r(r,i,d){return i=o.extractElementByName(i,"md-toast"),n=d.content,i.addClass(d.position.split(" ").map(function(e){return"md-"+e}).join(" ")),d.parent.addClass(a(d.position)),d.onSwipe=function(e,n){i.addClass("md-"+e.type.replace("$md.","")),o.nextTick(t.cancel)},i.on("$md.swipeleft $md.swiperight",d.onSwipe),e.enter(i,d.parent)}function i(t,n,o){return n.off("$md.swipeleft $md.swiperight",o.onSwipe),o.parent.removeClass(a(o.position)),e.leave(n)}function a(e){return"md-toast-open-"+(e.indexOf("top")>-1?"top":"bottom")}return{onShow:r,onRemove:i,position:"bottom left",themable:!0,hideDelay:3e3}}var n,o="ok",r=e("$mdToast").setDefaults({methods:["position","hideDelay","capsule"],options:t}).addPreset("simple",{argOption:"content",methods:["content","action","highlightAction","theme","parent"],options:["$mdToast","$mdTheming",function(e,t){var r={template:['<md-toast md-theme="{{ toast.theme }}" ng-class="{\'md-capsule\': toast.capsule}">',"<span flex>{{ toast.content }}</span>",'<md-button class="md-action" ng-if="toast.action" ng-click="toast.resolve()" ng-class="{\'md-highlight\': toast.highlightAction}">',"{{ toast.action }}","</md-button>","</md-toast>"].join(""),controller:["$scope",function(t){var r=this;t.$watch(function(){return n},function(){r.content=n}),this.resolve=function(){e.hide(o)}}],theme:t.defaultTheme(),controllerAs:"toast",bindToController:!0};return r}]}).addMethod("updateContent",function(e){n=e});return t.$inject=["$animate","$mdToast","$mdUtil"],r}t.module("material.components.toast",["material.core","material.components.button"]).directive("mdToast",e).provider("$mdToast",n),n.$inject=["$$interimElementProvider"]}(),function(){function e(e,n,o,r,i,a,d,c,l){function m(m,p,f){function h(){t.isDefined(f.mdDelay)||(m.delay=s)}function b(){m.$on("$destroy",function(){m.visible=!1,p.remove(),t.element(n).off("resize",I)}),m.$watch("visible",function(e){e?C():y()})}function g(){k.attr("aria-label")||k.text().trim()||k.attr("aria-label",p.text().trim())}function E(){p.detach(),p.attr("role","tooltip")}function v(){for(var e=p.parent();e&&$("pointer-events","none",e[0]);)e=e.parent();return e}function M(){for(var e=p.parent()[0];e&&e!==d[0]&&e!==document.body;)e=e.parentNode;return e}function $(e,o,r){e=f.$normalize(e),r=r||p[0];var i=n.getComputedStyle(r);return t.isDefined(i[e])&&i[e]==o}function A(){var e=!1,o=function(){k.on("blur mouseleave touchend touchcancel",i),T(!0)},i=function(){var t=m.hasOwnProperty("autohide")?m.autohide:f.hasOwnProperty("mdAutohide");(t||e||r[0].activeElement!==k[0])&&(k.off("blur mouseleave touchend touchcancel",i),T(!1)),e=!1};k.on("mousedown",function(){e=!0}),k.on("focus mouseenter touchstart",o),t.element(n).on("resize",I)}function T(t){T.value=!!t,T.queued||(t?(T.queued=!0,e(function(){m.visible=T.value,T.queued=!1},m.delay)):i.nextTick(function(){m.visible=!1}))}function C(){return S.append(p),$("display","none")?(m.visible=!1,void p.detach()):(w(),void t.forEach([p,x,N],function(e){c.addClass(e,"md-show")}))}function y(){l.all([c.removeClass(N,"md-show"),c.removeClass(x,"md-show"),c.removeClass(p,"md-show")]).then(function(){m.visible||p.detach()})}function w(){function e(){var e="left"===_||"right"===_?2*Math.sqrt(Math.pow(o.width,2)+Math.pow(o.height/2,2)):2*Math.sqrt(Math.pow(o.width/2,2)+Math.pow(o.height,2)),t="left"===_?{left:100,top:50}:"right"===_?{left:0,top:50}:"top"===_?{left:50,top:100}:{left:50,top:0};x.css({width:e+"px",height:e+"px",left:t.left+"%",top:t.top+"%"})}function t(e){var t={left:e.left,top:e.top};return t.left=Math.min(t.left,S.prop("scrollWidth")-o.width-u),t.left=Math.max(t.left,u),t.top=Math.min(t.top,S.prop("scrollHeight")-o.height-u),t.top=Math.max(t.top,u),t}function n(e){return"left"===e?{left:r.left-o.width-u,top:r.top+r.height/2-o.height/2}:"right"===e?{left:r.left+r.width+u,top:r.top+r.height/2-o.height/2}:"top"===e?{left:r.left+r.width/2-o.width/2,top:r.top-o.height-u}:{left:r.left+r.width/2-o.width/2,top:r.top+r.height+u}}var o=i.offsetRect(p,S),r=i.offsetRect(k,S),a=n(_);_?a=t(a):a.top>p.prop("offsetParent").scrollHeight-o.height-u&&(a=t(n("top"))),p.css({top:a.top+"px",left:a.left+"px"}),e()}a(p);var k=v(),x=t.element(p[0].getElementsByClassName("md-background")[0]),N=t.element(p[0].getElementsByClassName("md-content")[0]),_=f.mdDirection,H=M(),S=t.element(H||document.body),I=o.throttle(function(){m.visible&&w()});h(),E(),A(),b(),g()}var s=300,u=8;return{restrict:"E",transclude:!0,priority:210,template:'        <div class="md-background"></div>        <div class="md-content" ng-transclude></div>',scope:{visible:"=?mdVisible",delay:"=?mdDelay",autohide:"=?mdAutohide"},link:m}}t.module("material.components.tooltip",["material.core"]).directive("mdTooltip",e),e.$inject=["$timeout","$window","$$rAF","$document","$mdUtil","$mdTheming","$rootElement","$animate","$q"]}(),function(){function e(){return{controller:o,template:n,compile:function(e,t){e.addClass("md-virtual-repeat-container").addClass(t.hasOwnProperty("mdOrientHorizontal")?"md-orient-horizontal":"md-orient-vertical")}}}function n(e){return'<div class="md-virtual-repeat-scroller"><div class="md-virtual-repeat-sizer"></div><div class="md-virtual-repeat-offsetter">'+e[0].innerHTML+"</div></div>"}function o(e,n,o,r){this.$scope=n,this.$element=o,this.$attrs=r,this.size=0,this.scrollSize=0,this.scrollOffset=0,this.horizontal=this.$attrs.hasOwnProperty("mdOrientHorizontal"),this.repeater=null,this.autoShrink=this.$attrs.hasOwnProperty("mdAutoShrink"),this.autoShrinkMin=parseInt(this.$attrs.mdAutoShrinkMin,10)||0,this.originalSize=null,this.scroller=o[0].getElementsByClassName("md-virtual-repeat-scroller")[0],this.sizer=this.scroller.getElementsByClassName("md-virtual-repeat-sizer")[0],this.offsetter=this.scroller.getElementsByClassName("md-virtual-repeat-offsetter")[0],e(t.bind(this,this.updateSize)),r.ngHide&&n.$watch(r.ngHide,t.bind(this,function(n){n||e(t.bind(this,this.updateSize))}))}function r(e){return{controller:i,priority:1e3,require:["mdVirtualRepeat","^^mdVirtualRepeatContainer"],restrict:"A",terminal:!0,transclude:"element",compile:function(t,n){var o=n.mdVirtualRepeat,r=o.match(/^\s*([\s\S]+?)\s+in\s+([\s\S]+?)\s*$/),i=r[1],a=e(r[2]),d=n.mdExtraName&&e(n.mdExtraName);return function(e,t,n,o,r){o[0].link_(o[1],r,i,a,d)}}}}function i(e,t,n,o,r,i){this.$scope=e,this.$element=t,this.$attrs=n,this.$browser=o,this.$document=r,this.$$rAF=i,this.browserCheckUrlChange=o.$$checkUrlChange,this.newStartIndex=0,this.newEndIndex=0,this.startIndex=0,this.endIndex=0,this.itemSize=e.$eval(n.mdItemSize)||null,this.isFirstRender=!0,this.itemsLength=0,this.blocks={},this.pooledBlocks=[]}t.module("material.components.virtualRepeat",["material.core"]).directive("mdVirtualRepeatContainer",e).directive("mdVirtualRepeat",r);var a=1533917,d=3;o.$inject=["$$rAF","$scope","$element","$attrs"],o.prototype.register=function(e){this.repeater=e,t.element(this.scroller).on("scroll wheel touchmove touchend",t.bind(this,this.handleScroll_))},o.prototype.isHorizontal=function(){return this.horizontal},o.prototype.getSize=function(){return this.size},o.prototype.setSize_=function(e){this.size=e,this.$element[0].style[this.isHorizontal()?"width":"height"]=e+"px"},o.prototype.updateSize=function(){this.originalSize||(this.size=this.isHorizontal()?this.$element[0].clientWidth:this.$element[0].clientHeight,this.repeater&&this.repeater.containerUpdated())},o.prototype.getScrollSize=function(){return this.scrollSize},o.prototype.sizeScroller_=function(e){var t=this.isHorizontal()?"width":"height",n=this.isHorizontal()?"height":"width";if(a>e)this.sizer.style[t]=e+"px";else{this.sizer.innerHTML="",this.sizer.style[t]="auto",this.sizer.style[n]="auto";var o=Math.floor(e/a),r=document.createElement("div");r.style[t]=a+"px",r.style[n]="1px";for(var i=0;o>i;i++)this.sizer.appendChild(r.cloneNode(!1));r.style[t]=e-o*a+"px",this.sizer.appendChild(r)}},o.prototype.autoShrink_=function(e){var t=Math.max(e,this.autoShrinkMin*this.repeater.getItemSize());this.autoShrink&&t!==this.size&&(t<(this.originalSize||this.size)?(this.originalSize||(this.originalSize=this.size),this.setSize_(t)):this.originalSize&&(this.setSize_(this.originalSize),this.originalSize=null))},o.prototype.setScrollSize=function(e){this.scrollSize!==e&&(this.sizeScroller_(e),this.autoShrink_(e),this.scrollSize=e)},o.prototype.getScrollOffset=function(){return this.scrollOffset},o.prototype.scrollTo=function(e){this.scroller[this.isHorizontal()?"scrollLeft":"scrollTop"]=e,this.handleScroll_()},o.prototype.resetScroll=function(){this.scrollTo(0)},o.prototype.handleScroll_=function(){var e=this.isHorizontal()?this.scroller.scrollLeft:this.scroller.scrollTop;if(e!==this.scrollOffset){var t=this.repeater.getItemSize();if(t){var n=Math.max(0,Math.floor(e/t)-d),o=this.isHorizontal()?"translateX(":"translateY(";o+=n*t+"px)",this.scrollOffset=e,this.offsetter.style.webkitTransform=o,this.offsetter.style.transform=o,this.repeater.containerUpdated()}}},r.$inject=["$parse"],i.$inject=["$scope","$element","$attrs","$browser","$document","$$rAF"],i.Block,i.prototype.link_=function(e,t,n,o,r){this.container=e,this.transclude=t,this.repeatName=n,this.repeatListExpression=o,this.extraName=r,this.sized=!1,this.container.register(this)},i.prototype.readItemSize_=function(){this.items=this.repeatListExpression(this.$scope),this.parentNode=this.$element[0].parentNode;var e=this.getBlock_(0);this.itemSize=e.element[0][this.container.isHorizontal()?"offsetWidth":"offsetHeight"]||null,this.blocks[0]=e,this.poolBlock_(0),this.itemSize&&this.containerUpdated()},i.prototype.containerUpdated=function(){return this.itemSize?(this.sized||(this.items=this.repeatListExpression(this.$scope)),this.sized||(this.sized=!0,this.$scope.$watchCollection(this.repeatListExpression,t.bind(this,this.virtualRepeatUpdate_))),this.updateIndexes_(),void((this.newStartIndex!==this.startIndex||this.newEndIndex!==this.endIndex||this.container.getScrollOffset()>this.container.getScrollSize())&&this.virtualRepeatUpdate_(this.items,this.items))):void this.$$rAF(t.bind(this,this.readItemSize_));

},i.prototype.getItemSize=function(){return this.itemSize},i.prototype.virtualRepeatUpdate_=function(e,n){var o=e?e.length:0,r=!1;if(o!==this.itemsLength&&(r=!0,this.itemsLength=o),this.items&&o<this.items.length&&0!==this.container.getScrollOffset())return this.items=e,void this.container.resetScroll();if(this.items=e,e!==n&&this.updateIndexes_(),this.parentNode=this.$element[0].parentNode,r&&this.container.setScrollSize(o*this.itemSize),this.isFirstRender){this.isFirstRender=!1;var i=this.$attrs.mdStartIndex?this.$scope.$eval(this.$attrs.mdStartIndex):0;this.container.scrollTo(i*this.itemSize)}Object.keys(this.blocks).forEach(function(e){var t=parseInt(e,10);(t<this.newStartIndex||t>=this.newEndIndex)&&this.poolBlock_(t)},this),this.$browser.$$checkUrlChange=t.noop;var a,d,c=[],l=[];for(a=this.newStartIndex;a<this.newEndIndex&&null==this.blocks[a];a++)d=this.getBlock_(a),this.updateBlock_(d,a),c.push(d);for(;null!=this.blocks[a];a++)this.updateBlock_(this.blocks[a],a);for(var m=a-1;a<this.newEndIndex;a++)d=this.getBlock_(a),this.updateBlock_(d,a),l.push(d);c.length&&this.parentNode.insertBefore(this.domFragmentFromBlocks_(c),this.$element[0].nextSibling),l.length&&this.parentNode.insertBefore(this.domFragmentFromBlocks_(l),this.blocks[m]&&this.blocks[m].element[0].nextSibling),this.$browser.$$checkUrlChange=this.browserCheckUrlChange,this.startIndex=this.newStartIndex,this.endIndex=this.newEndIndex},i.prototype.getBlock_=function(e){if(this.pooledBlocks.length)return this.pooledBlocks.pop();var n;return this.transclude(t.bind(this,function(t,o){n={element:t,"new":!0,scope:o},this.updateScope_(o,e),this.parentNode.appendChild(t[0])})),n},i.prototype.updateBlock_=function(e,t){this.blocks[t]=e,(e["new"]||e.scope.$index!==t||e.scope[this.repeatName]!==this.items[t])&&(e["new"]=!1,this.updateScope_(e.scope,t),this.$scope.$root.$$phase||e.scope.$digest())},i.prototype.updateScope_=function(e,t){e.$index=t,e[this.repeatName]=this.items&&this.items[t],this.extraName&&(e[this.extraName(this.$scope)]=this.items[t])},i.prototype.poolBlock_=function(e){this.pooledBlocks.push(this.blocks[e]),this.parentNode.removeChild(this.blocks[e].element[0]),delete this.blocks[e]},i.prototype.domFragmentFromBlocks_=function(e){var t=this.$document[0].createDocumentFragment();return e.forEach(function(e){t.appendChild(e.element[0])}),t},i.prototype.updateIndexes_=function(){var e=this.items?this.items.length:0,t=Math.ceil(this.container.getSize()/this.itemSize);this.newStartIndex=Math.max(0,Math.min(e-t,Math.floor(this.container.getScrollOffset()/this.itemSize))),this.newEndIndex=Math.min(e,this.newStartIndex+t+d),this.newStartIndex=Math.max(0,this.newStartIndex-d)}}(),function(){t.module("material.components.whiteframe",[])}(),function(){function e(e,n,o,r,i){var a=t.bind(null,o.supplant,"translate3d(0,{0}px,0)");return{restrict:"E",controller:t.noop,link:function(d,c,l){function m(){function t(t,n){c.parent()[0]===n.parent()[0]&&(u&&u.off("scroll",b),n.on("scroll",b),n.attr("scroll-shrink","true"),u=n,e(r))}function r(){s=c.prop("offsetHeight");var e=-s*h+"px";u.css("margin-top",e),u.css("margin-bottom",e),m()}function m(e){var t=e?e.target.scrollTop:f;g(),p=Math.min(s/h,Math.max(0,p+t-f)),c.css(n.CSS.TRANSFORM,a([-p*h])),u.css(n.CSS.TRANSFORM,a([(s-p)*h])),f=t,o.nextTick(function(){var e=c.hasClass("md-whiteframe-z1");e&&!p?i.removeClass(c,"md-whiteframe-z1"):!e&&p&&i.addClass(c,"md-whiteframe-z1")})}var s,u,p=0,f=0,h=l.mdShrinkSpeedFactor||.5,b=e.throttle(m),g=o.debounce(r,5e3);d.$on("$mdContentLoaded",t)}r(c),t.isDefined(l.mdScrollShrink)&&m()}}}t.module("material.components.toolbar",["material.core","material.components.content"]).directive("mdToolbar",e),e.$inject=["$$rAF","$mdConstant","$mdUtil","$mdTheming","$animate"]}(),function(){function e(e,o,a,d,c,l,m,s,u,p){function f(){a.initOptionalProperties(e,u,{searchText:null,selectedItem:null}),c(o),E(),a.nextTick(function(){M(),g(),b()})}function h(){function e(){var e=ne.ul.getBoundingClientRect(),n={};e.right>o.right-i&&(n.left=t.right-e.width+"px"),ne.$.ul.css(n)}if(!ne)return a.nextTick(h,!1);var t=ne.wrap.getBoundingClientRect(),n=ne.snap.getBoundingClientRect(),o=ne.root.getBoundingClientRect(),d=n.bottom-o.top,c=o.bottom-n.top,l=t.left-o.left,m=t.width,s={left:l+"px",minWidth:m+"px",maxWidth:Math.max(t.right-o.left,o.right-t.left)-i+"px"};d>c&&o.height-t.bottom-i<r?(s.top="auto",s.bottom=c+"px",s.maxHeight=Math.min(r,t.top-o.top-i)+"px"):(s.top=d+"px",s.bottom="auto",s.maxHeight=Math.min(r,o.bottom-t.bottom-i)+"px"),ne.$.ul.css(s),a.nextTick(e,!1)}function b(){ne.$.root.length&&(c(ne.$.ul),ne.$.ul.detach(),ne.$.root.append(ne.$.ul),m.pin&&m.pin(ne.$.ul,s))}function g(){e.autofocus&&ne.input.focus()}function E(){var n=parseInt(e.delay,10)||0;u.$observe("disabled",function(e){J.isDisabled=e}),u.$observe("required",function(e){J.isRequired=null!==e}),e.$watch("searchText",n?a.debounce(I,n):I),e.$watch("selectedItem",k),t.element(l).on("resize",h),e.$on("$destroy",v)}function v(){t.element(l).off("resize",h),ne.$.ul.remove()}function M(){ne={main:o[0],ul:o.find("ul")[0],input:o.find("input")[0],wrap:o.find("md-autocomplete-wrap")[0],root:document.body},ne.li=ne.ul.getElementsByTagName("li"),ne.snap=$(),ne.$=A(ne)}function $(){for(var e=o;e.length;e=e.parent())if(t.isDefined(e.attr("md-autocomplete-snap")))return e[0];return ne.wrap}function A(e){var n={};for(var o in e)e.hasOwnProperty(o)&&(n[o]=t.element(e[o]));return n}function T(e,t){!e&&t?(h(),ne&&a.nextTick(function(){a.disableScrollAround(ne.ul)},!1)):e&&!t&&a.nextTick(function(){a.enableScrolling()},!1)}function C(){re=!0}function y(){re=!1,ae||(J.hidden=!0)}function w(){ne.input.focus()}function k(t,n){t&&P(t).then(function(o){e.searchText=o,_(t,n)}),t!==n&&x()}function x(){t.isFunction(e.itemChange)&&e.itemChange(F(e.selectedItem))}function N(){t.isFunction(e.textChange)&&e.textChange()}function _(e,t){ie.forEach(function(n){n(e,t)})}function H(e){-1==ie.indexOf(e)&&ie.push(e)}function S(e){var t=ie.indexOf(e);-1!=t&&ie.splice(t,1)}function I(t,n){J.index=B(),t!==n&&P(e.selectedItem).then(function(o){t!==o&&(e.selectedItem=null,t!==n&&N(),q()?Q():(J.loading=!1,J.matches=[],J.hidden=z(),K()))})}function O(){ae=!1,re||(J.hidden=!0)}function D(){ae=!0,t.isString(e.searchText)||(e.searchText=""),e.minLength>0||(J.hidden=z(),J.hidden||Q())}function R(e){switch(e.keyCode){case d.KEY_CODE.DOWN_ARROW:if(J.loading)return;e.stopPropagation(),e.preventDefault(),J.index=Math.min(J.index+1,J.matches.length-1),X(),K();break;case d.KEY_CODE.UP_ARROW:if(J.loading)return;e.stopPropagation(),e.preventDefault(),J.index=J.index<0?J.matches.length-1:Math.max(0,J.index-1),X(),K();break;case d.KEY_CODE.TAB:case d.KEY_CODE.ENTER:if(J.hidden||J.loading||J.index<0||J.matches.length<1)return;e.stopPropagation(),e.preventDefault(),U(J.index);break;case d.KEY_CODE.ESCAPE:e.stopPropagation(),e.preventDefault(),Y(),J.matches=[],J.hidden=!0,J.index=B()}}function L(){return t.isNumber(e.minLength)?e.minLength:1}function P(t){function n(t){return t&&e.itemText?e.itemText(F(t)):null}return p.when(n(t)||t)}function F(e){if(!e)return n;var t={};return J.itemName&&(t[J.itemName]=e),t}function B(){return e.autoselect?0:-1}function z(){return q()&&J.matches.length?void 0:!0}function j(){return P(J.matches[J.index])}function q(){return t.isDefined(e.searchText)&&e.searchText.length>=L()}function V(e,t,n){Object.defineProperty(J,e,{get:function(){return n},set:function(e){var o=n;n=e,t(e,o)}})}function U(t){a.nextTick(function(){P(J.matches[t]).then(function(e){var t=ne.$.input.controller("ngModel");t.$setViewValue(e),t.$render()})["finally"](function(){e.selectedItem=J.matches[t],J.loading=!1,J.hidden=!0,J.index=0,J.matches=[]})},!1)}function Y(){e.searchText="",U(-1);var t=document.createEvent("CustomEvent");t.initCustomEvent("input",!0,!0,{value:e.searchText}),ne.input.dispatchEvent(t),ne.input.focus()}function W(n){function o(t){oe[i]=t,n===e.searchText&&(J.matches=t,J.hidden=z(),e.selectOnMatch&&Z(),K(),h())}var r=e.$parent.$eval(te),i=n.toLowerCase();t.isArray(r)?o(r):r&&a.nextTick(function(){J.loading=!0,r.success&&r.success(o),r.then&&r.then(o),r["finally"]&&r["finally"](function(){J.loading=!1})})}function K(){j().then(function(e){J.messages=[G(),e]})}function G(){if(de===J.matches.length)return"";switch(de=J.matches.length,J.matches.length){case 0:return"There are no matches available.";case 1:return"There is 1 match available.";default:return"There are "+J.matches.length+" matches available."}}function X(){if(ne.li[J.index]){var e=ne.li[J.index],t=e.offsetTop,n=t+e.offsetHeight,o=ne.ul.clientHeight;t<ne.ul.scrollTop?ne.ul.scrollTop=t:n>ne.ul.scrollTop+o&&(ne.ul.scrollTop=n-o)}}function Q(){var t=e.searchText,n=t.toLowerCase();!e.noCache&&oe[n]?(J.matches=oe[n],K()):W(t),ae&&(J.hidden=z())}function Z(){var t=e.searchText,n=J.matches,o=n[0];1===n.length&&P(o).then(function(e){t==e&&U(0)})}var J=this,ee=e.itemsExpr.split(/ in /i),te=ee[1],ne=null,oe={},re=!1,ie=[],ae=!1,de=0;return V("hidden",T,!0),J.scope=e,J.parent=e.$parent,J.itemName=ee[0],J.matches=[],J.loading=!1,J.hidden=!0,J.index=null,J.messages=[],J.id=a.nextUid(),J.isDisabled=null,J.isRequired=null,J.keydown=R,J.blur=O,J.focus=D,J.clear=Y,J.select=U,J.listEnter=C,J.listLeave=y,J.mouseUp=w,J.getCurrentDisplayValue=j,J.registerSelectedItemWatcher=H,J.unregisterSelectedItemWatcher=S,f()}t.module("material.components.autocomplete").controller("MdAutocompleteCtrl",e);var o=41,r=5.5*o,i=8;e.$inject=["$scope","$element","$mdUtil","$mdConstant","$mdTheming","$window","$animate","$rootElement","$attrs","$q"]}(),function(){function e(){return{controller:"MdAutocompleteCtrl",controllerAs:"$mdAutocompleteCtrl",scope:{inputName:"@mdInputName",inputMinlength:"@mdInputMinlength",inputMaxlength:"@mdInputMaxlength",searchText:"=?mdSearchText",selectedItem:"=?mdSelectedItem",itemsExpr:"@mdItems",itemText:"&mdItemText",placeholder:"@placeholder",noCache:"=?mdNoCache",selectOnMatch:"=?mdSelectOnMatch",itemChange:"&?mdSelectedItemChange",textChange:"&?mdSearchTextChange",minLength:"=?mdMinLength",delay:"=?mdDelay",autofocus:"=?mdAutofocus",floatingLabel:"@?mdFloatingLabel",autoselect:"=?mdAutoselect",menuClass:"@?mdMenuClass",inputId:"@?mdInputId"},template:function(e,t){function n(){var t=e.find("md-item-template").remove(),n=t.length?t.html():e.html();return t.length||e.empty(),n}function o(){var t=e.find("md-not-found").remove(),n=t.length?t.html():"";return n?'<li ng-if="!$mdAutocompleteCtrl.matches.length && !$mdAutocompleteCtrl.loading                       && !$mdAutocompleteCtrl.hidden"                   ng-hide="$mdAutocompleteCtrl.hidden"                   md-autocomplete-parent-scope>'+n+"</li>":""}function r(){return t.mdFloatingLabel?'            <md-input-container flex ng-if="floatingLabel">              <label>{{floatingLabel}}</label>              <input type="search"                  id="{{ inputId || \'fl-input-\' + $mdAutocompleteCtrl.id }}"                  name="{{inputName}}"                  autocomplete="off"                  ng-required="$mdAutocompleteCtrl.isRequired"                  ng-minlength="inputMinlength"                  ng-maxlength="inputMaxlength"                  ng-disabled="$mdAutocompleteCtrl.isDisabled"                  ng-model="$mdAutocompleteCtrl.scope.searchText"                  ng-keydown="$mdAutocompleteCtrl.keydown($event)"                  ng-blur="$mdAutocompleteCtrl.blur()"                  ng-focus="$mdAutocompleteCtrl.focus()"                  aria-owns="ul-{{$mdAutocompleteCtrl.id}}"                  aria-label="{{floatingLabel}}"                  aria-autocomplete="list"                  aria-haspopup="true"                  aria-activedescendant=""                  aria-expanded="{{!$mdAutocompleteCtrl.hidden}}"/>              <div md-autocomplete-parent-scope md-autocomplete-replace>'+d+"</div>            </md-input-container>":'            <input flex type="search"                id="{{ inputId || \'input-\' + $mdAutocompleteCtrl.id }}"                name="{{inputName}}"                ng-if="!floatingLabel"                autocomplete="off"                ng-required="$mdAutocompleteCtrl.isRequired"                ng-disabled="$mdAutocompleteCtrl.isDisabled"                ng-model="$mdAutocompleteCtrl.scope.searchText"                ng-keydown="$mdAutocompleteCtrl.keydown($event)"                ng-blur="$mdAutocompleteCtrl.blur()"                ng-focus="$mdAutocompleteCtrl.focus()"                placeholder="{{placeholder}}"                aria-owns="ul-{{$mdAutocompleteCtrl.id}}"                aria-label="{{placeholder}}"                aria-autocomplete="list"                aria-haspopup="true"                aria-activedescendant=""                aria-expanded="{{!$mdAutocompleteCtrl.hidden}}"/>            <button                type="button"                tabindex="-1"                ng-if="$mdAutocompleteCtrl.scope.searchText && !$mdAutocompleteCtrl.isDisabled"                ng-click="$mdAutocompleteCtrl.clear()">              <md-icon md-svg-icon="md-close"></md-icon>              <span class="md-visually-hidden">Clear</span>            </button>                '}var i=o(),a=n(),d=e.html();return'        <md-autocomplete-wrap            layout="row"            ng-class="{ \'md-whiteframe-z1\': !floatingLabel, \'md-menu-showing\': !$mdAutocompleteCtrl.hidden }"            role="listbox">          '+r()+'          <md-progress-linear              ng-if="$mdAutocompleteCtrl.loading && !$mdAutocompleteCtrl.hidden"              md-mode="indeterminate"></md-progress-linear>          <ul role="presentation"              class="md-autocomplete-suggestions md-whiteframe-z1 {{menuClass || \'\'}}"              id="ul-{{$mdAutocompleteCtrl.id}}"              ng-hide="$mdAutocompleteCtrl.hidden"              ng-mouseenter="$mdAutocompleteCtrl.listEnter()"              ng-mouseleave="$mdAutocompleteCtrl.listLeave()"              ng-mouseup="$mdAutocompleteCtrl.mouseUp()">            <li ng-repeat="(index, item) in $mdAutocompleteCtrl.matches"                ng-class="{ selected: index === $mdAutocompleteCtrl.index }"                ng-click="$mdAutocompleteCtrl.select(index)"                md-autocomplete-list-item="$mdAutocompleteCtrl.itemName">                '+a+"            </li>            "+i+'          </ul>        </md-autocomplete-wrap>        <aria-status            class="md-visually-hidden"            role="status"            aria-live="assertive">          <p ng-repeat="message in $mdAutocompleteCtrl.messages track by $index" ng-if="message">{{message}}</p>        </aria-status>'}}}t.module("material.components.autocomplete").directive("mdAutocomplete",e)}(),function(){function e(e,n,o){function r(e,t){i(e,t),n.on("$destroy",a)}function i(t,n){function r(){return o(n)(e)}m.watchers.push(e.$watch(t,function(e){m.term=e,d(e,m.template)})),m.watchers.push(e.$watch(r,function(e){m.template=e,d(m.term,e)}))}function a(){m.watchers.forEach(function(e){e()})}function d(){if(null!==m.term&&null!==m.template){var r=o(m.template)(e),i=t.element("<div>").text(r).html(),a=n.attr("md-highlight-flags")||"",d=l(m.term,a),c=i.replace(d,'<span class="highlight">$&</span>');n.html(c)}}function c(e){return e?e.replace(/[\\\^\$\*\+\?\.\(\)\|\{}\[\]]/g,"\\$&"):e}function l(e,t){var n="";return t.indexOf("^")>=1&&(n+="^"),n+=e,t.indexOf("$")>=1&&(n+="$"),new RegExp(c(n),t.replace(/[\$\^]/g,""))}var m=this;m.term=null,m.template=null,m.watchers=[],m.init=r}t.module("material.components.autocomplete").controller("MdHighlightCtrl",e),e.$inject=["$scope","$element","$interpolate"]}(),function(){function e(){return{terminal:!0,scope:!1,controller:"MdHighlightCtrl",compile:function(e,t){var n=e.html();return function(e,t,o,r){r.init(o.mdHighlightText,n)}}}}t.module("material.components.autocomplete").directive("mdHighlightText",e)}(),function(){function e(e,t){function n(n,o,r){var i=n.$parent.$mdAutocompleteCtrl,a=i.parent.$new(!1,i.parent),d=i.scope.$eval(r.mdAutocompleteListItem);a[d]=n.item,e(o.contents())(a),o.attr({role:"option",id:"item_"+t.nextUid()})}return{terminal:!0,link:n,scope:!1}}t.module("material.components.autocomplete").directive("mdAutocompleteListItem",e),e.$inject=["$compile","$mdUtil"]}(),function(){function e(e){function t(t,n,o){var r=t.$parent.$mdAutocompleteCtrl;e(n.contents())(r.parent),o.hasOwnProperty("mdAutocompleteReplace")&&(n.after(n.contents()),n.remove())}return{restrict:"A",terminal:!0,link:t,scope:!1}}t.module("material.components.autocomplete").directive("mdAutocompleteParentScope",e),e.$inject=["$compile"]}(),function(){function e(e){function o(o,r){return o.append(n),function(n,o,r,i){o.addClass("md-chip"),e(o),i&&t.element(o[0].querySelector(".md-chip-content")).on("blur",function(){i.selectedChip=-1})}}return{restrict:"E",require:"^?mdChips",compile:o}}t.module("material.components.chips").directive("mdChip",e);var n='    <span ng-if="!$mdChipsCtrl.readonly" class="md-visually-hidden">      {{$mdChipsCtrl.deleteHint}}    </span>';e.$inject=["$mdTheming"]}(),function(){function e(e){function t(t,n,o,r){n.on("click",function(e){t.$apply(function(){r.removeChip(t.$$replacedScope.$index)})}),e(function(){n.attr({tabindex:-1,ariaHidden:!0}),n.find("button").attr("tabindex","-1")})}return{restrict:"A",require:"^mdChips",scope:!1,link:t}}t.module("material.components.chips").directive("mdChipRemove",e),e.$inject=["$timeout"]}(),function(){function e(e,t){function n(t,n,o){var r=t.$parent.$mdChipsCtrl,i=r.parent.$new(!1,r.parent);i.$$replacedScope=t,i.$chip=t.$chip,i.$mdChipsCtrl=r,n.html(r.$scope.$eval(o.mdChipTransclude)),e(n.contents())(i)}return{restrict:"EA",terminal:!0,link:n,scope:!1}}t.module("material.components.chips").directive("mdChipTransclude",e),e.$inject=["$compile","$mdUtil"]}(),function(){function e(e,t,n,o,r){this.$timeout=r,this.$mdConstant=t,this.$scope=e,this.parent=e.$parent,this.$log=n,this.$element=o,this.ngModelCtrl=null,this.userInputNgModelCtrl=null,this.userInputElement=null,this.items=[],this.selectedChip=-1,this.deleteHint="Press delete to remove this chip.",this.deleteButtonLabel="Remove",this.chipBuffer="",this.useMdOnAppend=!1}t.module("material.components.chips").controller("MdChipsCtrl",e),e.$inject=["$scope","$mdConstant","$log","$element","$timeout"],e.prototype.inputKeydown=function(e){var t=this.getChipBuffer();switch(e.keyCode){case this.$mdConstant.KEY_CODE.ENTER:if(this.$scope.requireMatch||!t)break;e.preventDefault(),this.appendChip(t),this.resetChipBuffer();break;case this.$mdConstant.KEY_CODE.BACKSPACE:if(t)break;e.stopPropagation(),this.items.length&&this.selectAndFocusChipSafe(this.items.length-1)}},e.prototype.chipKeydown=function(e){if(!this.getChipBuffer())switch(e.keyCode){case this.$mdConstant.KEY_CODE.BACKSPACE:case this.$mdConstant.KEY_CODE.DELETE:if(this.selectedChip<0)return;e.preventDefault(),this.removeAndSelectAdjacentChip(this.selectedChip);break;case this.$mdConstant.KEY_CODE.LEFT_ARROW:e.preventDefault(),this.selectedChip<0&&(this.selectedChip=this.items.length),this.items.length&&this.selectAndFocusChipSafe(this.selectedChip-1);break;case this.$mdConstant.KEY_CODE.RIGHT_ARROW:e.preventDefault(),this.selectAndFocusChipSafe(this.selectedChip+1);break;case this.$mdConstant.KEY_CODE.ESCAPE:case this.$mdConstant.KEY_CODE.TAB:if(this.selectedChip<0)return;e.preventDefault(),this.onFocus()}},e.prototype.getPlaceholder=function(){var e=this.items.length&&(""==this.secondaryPlaceholder||this.secondaryPlaceholder);return e?this.placeholder:this.secondaryPlaceholder},e.prototype.removeAndSelectAdjacentChip=function(e){var n=this.getAdjacentChipIndex(e);this.removeChip(e),this.$timeout(t.bind(this,function(){this.selectAndFocusChipSafe(n)}))},e.prototype.resetSelectedChip=function(){this.selectedChip=-1},e.prototype.getAdjacentChipIndex=function(e){var t=this.items.length-1;return 0==t?-1:e==t?e-1:e},e.prototype.appendChip=function(e){this.items.indexOf(e)+1||(this.useMdOnAppend&&this.mdOnAppend&&(e=this.mdOnAppend({$chip:e})),this.items.push(e))},e.prototype.useMdOnAppendExpression=function(){this.useMdOnAppend=!0},e.prototype.getChipBuffer=function(){return this.userInputElement?this.userInputNgModelCtrl?this.userInputNgModelCtrl.$viewValue:this.userInputElement[0].value:this.chipBuffer},e.prototype.resetChipBuffer=function(){this.userInputElement?this.userInputNgModelCtrl?(this.userInputNgModelCtrl.$setViewValue(""),this.userInputNgModelCtrl.$render()):this.userInputElement[0].value="":this.chipBuffer=""},e.prototype.removeChip=function(e){this.items.splice(e,1)},e.prototype.removeChipAndFocusInput=function(e){this.removeChip(e),this.onFocus()},e.prototype.selectAndFocusChipSafe=function(e){return this.items.length?e===this.items.length?this.onFocus():(e=Math.max(e,0),e=Math.min(e,this.items.length-1),this.selectChip(e),void this.focusChip(e)):(this.selectChip(-1),void this.onFocus())},e.prototype.selectChip=function(e){e>=-1&&e<=this.items.length?this.selectedChip=e:this.$log.warn("Selected Chip index out of bounds; ignoring.")},e.prototype.selectAndFocusChip=function(e){this.selectChip(e),-1!=e&&this.focusChip(e)},e.prototype.focusChip=function(e){this.$element[0].querySelector('md-chip[index="'+e+'"] .md-chip-content').focus()},e.prototype.configureNgModel=function(e){this.ngModelCtrl=e;var t=this;e.$render=function(){t.items=t.ngModelCtrl.$viewValue}},e.prototype.onFocus=function(){var e=this.$element[0].querySelector("input");e&&e.focus(),this.resetSelectedChip()},e.prototype.onInputFocus=function(){this.inputHasFocus=!0,this.resetSelectedChip()},e.prototype.onInputBlur=function(){this.inputHasFocus=!1},e.prototype.configureUserInput=function(e){this.userInputElement=e;var n=e.controller("ngModel");n!=this.ngModelCtrl&&(this.userInputNgModelCtrl=n);var o=this.$scope,r=this;e.attr({tabindex:0}).on("keydown",function(e){o.$apply(t.bind(r,function(){r.inputKeydown(e)}))}).on("focus",t.bind(r,r.onInputFocus)).on("blur",t.bind(r,r.onInputBlur))},e.prototype.configureAutocomplete=function(e){e.registerSelectedItemWatcher(t.bind(this,function(e){e&&(this.appendChip(e),this.resetChipBuffer())})),this.$element.find("input").on("focus",t.bind(this,this.onInputFocus)).on("blur",t.bind(this,this.onInputBlur))},e.prototype.hasFocus=function(){return this.inputHasFocus||this.selectedChip>=0}}(),function(){function e(e,t,a,d,c){function l(n,l){function m(e){if(l.ngModel){var t=s[0].querySelector(e);return t&&t.outerHTML}}var s=l.$mdUserTemplate;l.$mdUserTemplate=null;var u=m("md-chips>*[md-chip-remove]")||i,p=m("md-chips>md-chip-template")||r,f=m("md-chips>md-autocomplete")||m("md-chips>input")||o,h=s.find("md-chip");return s[0].querySelector("md-chip-template>*[md-chip-remove]")&&d.warn("invalid placement of md-chip-remove within md-chip-template."),function(n,r,i,d){t.initOptionalProperties(n,l),e(r);var m=d[0];if(m.chipContentsTemplate=p,m.chipRemoveTemplate=u,m.chipInputTemplate=f,r.attr({ariaHidden:!0,tabindex:-1}).on("focus",function(){m.onFocus()}),l.ngModel&&(m.configureNgModel(r.controller("ngModel")),i.mdOnAppend&&m.useMdOnAppendExpression(),f!=o&&c(function(){0===f.indexOf("<md-autocomplete")&&m.configureAutocomplete(r.find("md-autocomplete").controller("mdAutocomplete")),m.configureUserInput(r.find("input"))})),h.length>0){var s=a(h)(n.$parent);c(function(){r.find("md-chips-wrap").prepend(s)})}}}return{template:function(e,t){t.$mdUserTemplate=e.clone();return n},require:["mdChips"],restrict:"E",controller:"MdChipsCtrl",controllerAs:"$mdChipsCtrl",bindToController:!0,compile:l,scope:{readonly:"=readonly",placeholder:"@",secondaryPlaceholder:"@",mdOnAppend:"&",deleteHint:"@",deleteButtonLabel:"@",requireMatch:"=?mdRequireMatch"}}}t.module("material.components.chips").directive("mdChips",e);var n='      <md-chips-wrap          ng-if="!$mdChipsCtrl.readonly || $mdChipsCtrl.items.length > 0"          ng-keydown="$mdChipsCtrl.chipKeydown($event)"          ng-class="{ \'md-focused\': $mdChipsCtrl.hasFocus() }"          class="md-chips">        <md-chip ng-repeat="$chip in $mdChipsCtrl.items"            index="{{$index}}"            ng-class="{\'md-focused\': $mdChipsCtrl.selectedChip == $index}">          <div class="md-chip-content"              tabindex="-1"              aria-hidden="true"              ng-focus="!$mdChipsCtrl.readonly && $mdChipsCtrl.selectChip($index)"              md-chip-transclude="$mdChipsCtrl.chipContentsTemplate"></div>          <div class="md-chip-remove-container"              md-chip-transclude="$mdChipsCtrl.chipRemoveTemplate"></div>        </md-chip>        <div ng-if="!$mdChipsCtrl.readonly && $mdChipsCtrl.ngModelCtrl"            class="md-chip-input-container"            md-chip-transclude="$mdChipsCtrl.chipInputTemplate"></div>        </div>      </md-chips-wrap>',o='        <input            tabindex="0"            placeholder="{{$mdChipsCtrl.getPlaceholder()}}"            aria-label="{{$mdChipsCtrl.getPlaceholder()}}"            ng-model="$mdChipsCtrl.chipBuffer"            ng-focus="$mdChipsCtrl.onInputFocus()"            ng-blur="$mdChipsCtrl.onInputBlur()"            ng-keydown="$mdChipsCtrl.inputKeydown($event)">',r="      <span>{{$chip}}</span>",i='      <button          class="md-chip-remove"          ng-if="!$mdChipsCtrl.readonly"          ng-click="$mdChipsCtrl.removeChipAndFocusInput($$replacedScope.$index)"          type="button"          aria-hidden="true"          tabindex="-1">        <md-icon md-svg-icon="md-close"></md-icon>        <span class="md-visually-hidden">          {{$mdChipsCtrl.deleteButtonLabel}}        </span>      </button>';e.$inject=["$mdTheming","$mdUtil","$compile","$log","$timeout"]}(),function(){function e(){this.selectedItem=null,this.searchText=""}t.module("material.components.chips").controller("MdContactChipsCtrl",e),e.prototype.queryContact=function(e){var n=this.contactQuery({$query:e});return this.filterSelected?n.filter(t.bind(this,this.filterSelectedContacts)):n},e.prototype.filterSelectedContacts=function(e){return-1==this.contacts.indexOf(e)}}(),function(){function e(e,t){function o(n,o){return function(n,r,i,a){t.initOptionalProperties(n,o),e(r),r.attr("tabindex","-1")}}return{template:function(e,t){return n},restrict:"E",controller:"MdContactChipsCtrl",controllerAs:"$mdContactChipsCtrl",bindToController:!0,compile:o,scope:{contactQuery:"&mdContacts",placeholder:"@",secondaryPlaceholder:"@",contactName:"@mdContactName",contactImage:"@mdContactImage",contactEmail:"@mdContactEmail",contacts:"=ngModel",requireMatch:"=?mdRequireMatch"}}}t.module("material.components.chips").directive("mdContactChips",e);var n='      <md-chips class="md-contact-chips"          ng-model="$mdContactChipsCtrl.contacts"          md-require-match="$mdContactChipsCtrl.requireMatch"          md-autocomplete-snap>          <md-autocomplete              md-menu-class="md-contact-chips-suggestions"              md-selected-item="$mdContactChipsCtrl.selectedItem"              md-search-text="$mdContactChipsCtrl.searchText"              md-items="item in $mdContactChipsCtrl.queryContact($mdContactChipsCtrl.searchText)"              md-item-text="$mdContactChipsCtrl.mdContactName"              md-no-cache="true"              md-autoselect              placeholder="{{$mdContactChipsCtrl.contacts.length == 0 ?                  $mdContactChipsCtrl.placeholder : $mdContactChipsCtrl.secondaryPlaceholder}}">            <div class="md-contact-suggestion">              <img                   ng-src="{{item[$mdContactChipsCtrl.contactImage]}}"                  alt="{{item[$mdContactChipsCtrl.contactName]}}" />              <span class="md-contact-name" md-highlight-text="$mdContactChipsCtrl.searchText">                {{item[$mdContactChipsCtrl.contactName]}}              </span>              <span class="md-contact-email" >{{item[$mdContactChipsCtrl.contactEmail]}}</span>            </div>          </md-autocomplete>          <md-chip-template>            <div class="md-contact-avatar">              <img                   ng-src="{{$chip[$mdContactChipsCtrl.contactImage]}}"                  alt="{{$chip[$mdContactChipsCtrl.contactName]}}" />            </div>            <div class="md-contact-name">              {{$chip[$mdContactChipsCtrl.contactName]}}            </div>          </md-chip-template>      </md-chips>';e.$inject=["$mdTheming","$mdUtil"]}(),function(){function e(){function e(e,n,o,r){if(r){var i=n.parent()[0].getElementsByTagName("md-tab"),a=Array.prototype.indexOf.call(i,n[0]),d=n.find("md-tab-body").eq(0).remove(),c=n.find("md-tab-label").eq(0).remove(),l=r.insertTab({scope:e,parent:e.$parent,index:a,element:n,template:d.html(),label:c.html()},a);e.select=e.select||t.noop,e.deselect=e.deselect||t.noop,e.$watch("active",function(e){e&&r.select(l.getIndex())}),e.$watch("disabled",function(){r.refreshIndex()}),e.$watch(function(){return Array.prototype.indexOf.call(i,n[0])},function(e){l.index=e,r.updateTabOrder()}),e.$on("$destroy",function(){r.removeTab(l)})}}return{require:"^?mdTabs",terminal:!0,compile:function(n,o){var r=n.find("md-tab-label"),i=n.find("md-tab-body");if(0==r.length&&(r=t.element("<md-tab-label></md-tab-label>"),o.label?r.text(o.label):r.append(n.contents())),0==i.length){var a=n.contents().detach();i=t.element("<md-tab-body></md-tab-body>"),i.append(a)}return n.append(r),i.html()&&n.append(i),e},scope:{active:"=?mdActive",disabled:"=?ngDisabled",select:"&?mdOnSelect",deselect:"&?mdOnDeselect"}}}t.module("material.components.tabs").directive("mdTab",e)}(),function(){function e(){return{require:"^?mdTabs",link:function(e,t,n,o){o&&o.attachRipple(e,t)}}}t.module("material.components.tabs").directive("mdTabItem",e)}(),function(){function e(){return{terminal:!0}}t.module("material.components.tabs").directive("mdTabLabel",e)}(),function(){function e(e){return{restrict:"A",compile:function(t,n){var o=e(n.mdTabScroll,null,!0);return function(e,t){t.on("mousewheel",function(t){e.$apply(function(){o(e,{$event:t})})})}}}}t.module("material.components.tabs").directive("mdTabScroll",e),e.$inject=["$parse"]}(),function(){function e(e,n,o,r,i,a,d,c,l,m){function s(){ie.selectedIndex=ie.selectedIndex||0,u(),f(),p(),m(n),a.nextTick(function(){ee(),X(),te(),ie.tabs[ie.selectedIndex]&&ie.tabs[ie.selectedIndex].scope.select(),me=!0,U()})}function u(){var e=c.$mdTabsTemplate,n=t.element(de.data);n.html(e),l(n.contents())(ie.parent),delete c.$mdTabsTemplate}function p(){t.element(o).on("resize",S),e.$on("$destroy",g)}function f(){e.$watch("$mdTabsCtrl.selectedIndex",y)}function h(e,t){var n=c.$normalize("md-"+e);t&&V(e,t),c.$observe(n,function(t){ie[e]=t})}function b(e,t){function n(t){ie[e]="false"!==t}var o=c.$normalize("md-"+e);t&&V(e,t),c.hasOwnProperty(o)&&n(c[o]),c.$observe(o,n)}function g(){le=!0,t.element(o).off("resize",S)}function E(e){t.element(de.wrapper).toggleClass("md-stretch-tabs",B()),te()}function v(e){ie.shouldCenterTabs=z()}function M(e,t){e!==t&&a.nextTick(ie.updateInkBarStyles)}function $(e,t){e!==t&&(ie.maxTabWidth=Y(),ie.shouldCenterTabs=z(),a.nextTick(function(){ie.maxTabWidth=Y(),X(ie.selectedIndex)}))}function A(e){n[e?"removeClass":"addClass"]("md-no-tab-content")}function T(n){var o=ie.shouldCenterTabs?"":"-"+n+"px";t.element(de.paging).css(r.CSS.TRANSFORM,"translate3d("+o+", 0, 0)"),e.$broadcast("$mdTabsPaginationChanged")}function C(e,t){e!==t&&de.tabs[e]&&(X(),G())}function y(t,n){t!==n&&(ie.selectedIndex=q(t),ie.lastSelectedIndex=n,ie.updateInkBarStyles(),ee(),X(t),e.$broadcast("$mdTabsChanged"),ie.tabs[n]&&ie.tabs[n].scope.deselect(),ie.tabs[t]&&ie.tabs[t].scope.select())}function w(){w.watcher||(w.watcher=e.$watch(function(){a.nextTick(function(){w.watcher&&n.prop("offsetParent")&&(w.watcher(),w.watcher=null,S())},!1)}))}function k(e){switch(e.keyCode){case r.KEY_CODE.LEFT_ARROW:e.preventDefault(),K(-1,!0);break;case r.KEY_CODE.RIGHT_ARROW:e.preventDefault(),K(1,!0);break;case r.KEY_CODE.SPACE:case r.KEY_CODE.ENTER:e.preventDefault(),ae||(ie.selectedIndex=ie.focusIndex);

}ie.lastClick=!1}function x(e){ae||(ie.focusIndex=ie.selectedIndex=e),ie.lastClick=!0,a.nextTick(function(){ie.tabs[e].element.triggerHandler("click")},!1)}function N(e){ie.shouldPaginate&&(e.preventDefault(),ie.offsetLeft=oe(ie.offsetLeft-e.wheelDelta))}function _(){var e,t,n=de.canvas.clientWidth,o=n+ie.offsetLeft;for(e=0;e<de.tabs.length&&(t=de.tabs[e],!(t.offsetLeft+t.offsetWidth>o));e++);ie.offsetLeft=oe(t.offsetLeft)}function H(){var e,t;for(e=0;e<de.tabs.length&&(t=de.tabs[e],!(t.offsetLeft+t.offsetWidth>=ie.offsetLeft));e++);ie.offsetLeft=oe(t.offsetLeft+t.offsetWidth-de.canvas.clientWidth)}function S(){e.$apply(function(){ie.lastSelectedIndex=ie.selectedIndex,ie.offsetLeft=oe(ie.offsetLeft),a.nextTick(ie.updateInkBarStyles,!1),a.nextTick(U)})}function I(e){t.element(de.inkBar).toggleClass("ng-hide",e)}function O(e){n.toggleClass("md-dynamic-height",e)}function D(e){if(!le){var t=ie.selectedIndex,n=ie.tabs.splice(e.getIndex(),1)[0];J(),ie.selectedIndex===t&&(n.scope.deselect(),ie.tabs[ie.selectedIndex]&&ie.tabs[ie.selectedIndex].scope.select()),a.nextTick(function(){U(),ie.offsetLeft=oe(ie.offsetLeft)})}}function R(e,n){var o=me,r={getIndex:function(){return ie.tabs.indexOf(i)},isActive:function(){return this.getIndex()===ie.selectedIndex},isLeft:function(){return this.getIndex()<ie.selectedIndex},isRight:function(){return this.getIndex()>ie.selectedIndex},shouldRender:function(){return!ie.noDisconnect||this.isActive()},hasFocus:function(){return!ie.lastClick&&ie.hasFocus&&this.getIndex()===ie.focusIndex},id:a.nextUid()},i=t.extend(r,e);return t.isDefined(n)?ie.tabs.splice(n,0,i):ie.tabs.push(i),Q(),Z(),a.nextTick(function(){U(),o&&ie.autoselect&&a.nextTick(function(){a.nextTick(function(){x(ie.tabs.indexOf(i))})})}),i}function L(){var e={};return e.wrapper=n[0].getElementsByTagName("md-tabs-wrapper")[0],e.data=n[0].getElementsByTagName("md-tab-data")[0],e.canvas=e.wrapper.getElementsByTagName("md-tabs-canvas")[0],e.paging=e.canvas.getElementsByTagName("md-pagination-wrapper")[0],e.tabs=e.paging.getElementsByTagName("md-tab-item"),e.dummies=e.canvas.getElementsByTagName("md-dummy-tab"),e.inkBar=e.paging.getElementsByTagName("md-ink-bar")[0],e.contentsWrapper=n[0].getElementsByTagName("md-tabs-content-wrapper")[0],e.contents=e.contentsWrapper.getElementsByTagName("md-tab-content"),e}function P(){return ie.offsetLeft>0}function F(){var e=de.tabs[de.tabs.length-1];return e&&e.offsetLeft+e.offsetWidth>de.canvas.clientWidth+ie.offsetLeft}function B(){switch(ie.stretchTabs){case"always":return!0;case"never":return!1;default:return!ie.shouldPaginate&&o.matchMedia("(max-width: 600px)").matches}}function z(){return ie.centerTabs&&!ie.shouldPaginate}function j(){if(ie.noPagination||!me)return!1;var e=Math.min(n.prop("clientWidth"),ie.maxTabWidth);return t.forEach(de.dummies,function(t){e-=t.offsetWidth}),0>e}function q(e){if(-1===e)return-1;var t,n,o=Math.max(ie.tabs.length-e,e);for(t=0;o>=t;t++){if(n=ie.tabs[e+t],n&&n.scope.disabled!==!0)return n.getIndex();if(n=ie.tabs[e-t],n&&n.scope.disabled!==!0)return n.getIndex()}return e}function V(e,t,n){Object.defineProperty(ie,e,{get:function(){return n},set:function(e){var o=n;n=e,t&&t(e,o)}})}function U(){ie.shouldPaginate=j()}function Y(){return n.prop("clientWidth")}function W(){var e=ie.tabs[ie.selectedIndex],t=ie.tabs[ie.focusIndex];ie.tabs=ie.tabs.sort(function(e,t){return e.index-t.index}),ie.selectedIndex=ie.tabs.indexOf(e),ie.focusIndex=ie.tabs.indexOf(t)}function K(e,t){var n,o=t?"focusIndex":"selectedIndex",r=ie[o];for(n=r+e;ie.tabs[n]&&ie.tabs[n].scope.disabled;n+=e);ie.tabs[n]&&(ie[o]=n)}function G(){de.dummies[ie.focusIndex].focus()}function X(e){if(null==e&&(e=ie.focusIndex),de.tabs[e]&&!ie.shouldCenterTabs){var t=de.tabs[e],n=t.offsetLeft,o=t.offsetWidth+n;ie.offsetLeft=Math.max(ie.offsetLeft,oe(o-de.canvas.clientWidth)),ie.offsetLeft=Math.min(ie.offsetLeft,oe(n))}}function Q(){ce.forEach(function(e){a.nextTick(e)}),ce=[]}function Z(){var e=!1;t.forEach(ie.tabs,function(t){t.template&&(e=!0)}),ie.hasContent=e}function J(){ie.selectedIndex=q(ie.selectedIndex),ie.focusIndex=q(ie.focusIndex)}function ee(){if(!ie.dynamicHeight)return n.css("height","");if(!ie.tabs.length)return ce.push(ee);var e=de.contents[ie.selectedIndex],t=e?e.offsetHeight:0,o=de.wrapper.offsetHeight,r=t+o,i=n.prop("clientHeight");i!==r&&(ae=!0,d.animate(n,{height:i+"px"},{height:r+"px"}).then(function(){n.css("height",""),ae=!1}))}function te(){if(de.tabs[ie.selectedIndex]){if(!ie.tabs.length)return ce.push(ie.updateInkBarStyles);if(!n.prop("offsetParent"))return w();var e,o=ie.selectedIndex,r=de.paging.offsetWidth,i=de.tabs[o],d=i.offsetLeft,c=r-d-i.offsetWidth;ie.shouldCenterTabs&&(e=Array.prototype.slice.call(de.tabs).reduce(function(e,t){return e+t.offsetWidth},0),r>e&&a.nextTick(te,!1)),ne(),t.element(de.inkBar).css({left:d+"px",right:c+"px"})}}function ne(){var e=ie.selectedIndex,n=ie.lastSelectedIndex,o=t.element(de.inkBar);t.isNumber(n)&&o.toggleClass("md-left",n>e).toggleClass("md-right",e>n)}function oe(e){if(!de.tabs.length||!ie.shouldPaginate)return 0;var t=de.tabs[de.tabs.length-1],n=t.offsetLeft+t.offsetWidth;return e=Math.max(0,e),e=Math.min(n-de.canvas.clientWidth,e)}function re(e,n){var o={colorElement:t.element(de.inkBar)};i.attach(e,n,o)}var ie=this,ae=!1,de=L(),ce=[],le=!1,me=!1;h("stretchTabs",E),V("focusIndex",C,ie.selectedIndex||0),V("offsetLeft",T,0),V("hasContent",A,!1),V("maxTabWidth",M,Y()),V("shouldPaginate",$,!1),b("noInkBar",I),b("dynamicHeight",O),b("noPagination"),b("swipeContent"),b("noDisconnect"),b("autoselect"),b("centerTabs",v),b("enableDisconnect"),ie.scope=e,ie.parent=e.$parent,ie.tabs=[],ie.lastSelectedIndex=null,ie.hasFocus=!1,ie.lastClick=!0,ie.shouldCenterTabs=z(),ie.updatePagination=a.debounce(U,100),ie.redirectFocus=G,ie.attachRipple=re,ie.insertTab=R,ie.removeTab=D,ie.select=x,ie.scroll=N,ie.nextPage=_,ie.previousPage=H,ie.keydown=k,ie.canPageForward=F,ie.canPageBack=P,ie.refreshIndex=J,ie.incrementIndex=K,ie.updateInkBarStyles=a.debounce(te,100),ie.updateTabOrder=a.debounce(W,100),s()}t.module("material.components.tabs").controller("MdTabsController",e),e.$inject=["$scope","$element","$window","$mdConstant","$mdTabInkRipple","$mdUtil","$animate","$attrs","$compile","$mdTheming"]}(),function(){function e(){return{scope:{selectedIndex:"=?mdSelected"},template:function(e,t){return t.$mdTabsTemplate=e.html(),'        <md-tabs-wrapper>          <md-tab-data></md-tab-data>          <md-prev-button              tabindex="-1"              role="button"              aria-label="Previous Page"              aria-disabled="{{!$mdTabsCtrl.canPageBack()}}"              ng-class="{ \'md-disabled\': !$mdTabsCtrl.canPageBack() }"              ng-if="$mdTabsCtrl.shouldPaginate"              ng-click="$mdTabsCtrl.previousPage()">            <md-icon md-svg-icon="md-tabs-arrow"></md-icon>          </md-prev-button>          <md-next-button              tabindex="-1"              role="button"              aria-label="Next Page"              aria-disabled="{{!$mdTabsCtrl.canPageForward()}}"              ng-class="{ \'md-disabled\': !$mdTabsCtrl.canPageForward() }"              ng-if="$mdTabsCtrl.shouldPaginate"              ng-click="$mdTabsCtrl.nextPage()">            <md-icon md-svg-icon="md-tabs-arrow"></md-icon>          </md-next-button>          <md-tabs-canvas              tabindex="0"              aria-activedescendant="tab-item-{{$mdTabsCtrl.tabs[$mdTabsCtrl.focusIndex].id}}"              ng-focus="$mdTabsCtrl.redirectFocus()"              ng-class="{                  \'md-paginated\': $mdTabsCtrl.shouldPaginate,                  \'md-center-tabs\': $mdTabsCtrl.shouldCenterTabs              }"              ng-keydown="$mdTabsCtrl.keydown($event)"              role="tablist">            <md-pagination-wrapper                ng-class="{ \'md-center-tabs\': $mdTabsCtrl.shouldCenterTabs }"                md-tab-scroll="$mdTabsCtrl.scroll($event)">              <md-tab-item                  tabindex="-1"                  class="md-tab"                  style="max-width: {{ $mdTabsCtrl.maxTabWidth + \'px\' }}"                  ng-repeat="tab in $mdTabsCtrl.tabs"                  role="tab"                  aria-controls="tab-content-{{::tab.id}}"                  aria-selected="{{tab.isActive()}}"                  aria-disabled="{{tab.scope.disabled || \'false\'}}"                  ng-click="$mdTabsCtrl.select(tab.getIndex())"                  ng-class="{                      \'md-active\':    tab.isActive(),                      \'md-focused\':   tab.hasFocus(),                      \'md-disabled\':  tab.scope.disabled                  }"                  ng-disabled="tab.scope.disabled"                  md-swipe-left="$mdTabsCtrl.nextPage()"                  md-swipe-right="$mdTabsCtrl.previousPage()"                  md-template="::tab.label"                  md-scope="::tab.parent"></md-tab-item>              <md-ink-bar></md-ink-bar>            </md-pagination-wrapper>            <div class="md-visually-hidden md-dummy-wrapper">              <md-dummy-tab                  class="md-tab"                  tabindex="-1"                  id="tab-item-{{::tab.id}}"                  role="tab"                  aria-controls="tab-content-{{::tab.id}}"                  aria-selected="{{tab.isActive()}}"                  aria-disabled="{{tab.scope.disabled || \'false\'}}"                  ng-focus="$mdTabsCtrl.hasFocus = true"                  ng-blur="$mdTabsCtrl.hasFocus = false"                  ng-repeat="tab in $mdTabsCtrl.tabs"                  md-template="::tab.label"                  md-scope="::tab.parent"></md-dummy-tab>            </div>          </md-tabs-canvas>        </md-tabs-wrapper>        <md-tabs-content-wrapper ng-show="$mdTabsCtrl.hasContent && $mdTabsCtrl.selectedIndex >= 0">          <md-tab-content              id="tab-content-{{::tab.id}}"              role="tabpanel"              aria-labelledby="tab-item-{{::tab.id}}"              md-swipe-left="$mdTabsCtrl.swipeContent && $mdTabsCtrl.incrementIndex(1)"              md-swipe-right="$mdTabsCtrl.swipeContent && $mdTabsCtrl.incrementIndex(-1)"              ng-if="$mdTabsCtrl.hasContent"              ng-repeat="(index, tab) in $mdTabsCtrl.tabs"              ng-class="{                \'md-no-transition\': $mdTabsCtrl.lastSelectedIndex == null,                \'md-active\':        tab.isActive(),                \'md-left\':          tab.isLeft(),                \'md-right\':         tab.isRight(),                \'md-no-scroll\':     $mdTabsCtrl.dynamicHeight              }">            <div                md-template="::tab.template"                md-connected-if="tab.isActive()"                md-scope="::tab.parent"                ng-if="$mdTabsCtrl.enableDisconnect || tab.shouldRender()"></div>          </md-tab-content>        </md-tabs-content-wrapper>      '},controller:"MdTabsController",controllerAs:"$mdTabsCtrl",bindToController:!0}}t.module("material.components.tabs").directive("mdTabs",e)}(),function(){function e(e,t){function n(n,o,r,i){function a(){n.$watch("connected",function(e){e===!1?d():c()}),n.$on("$destroy",c)}function d(){i.enableDisconnect&&t.disconnectScope(l)}function c(){i.enableDisconnect&&t.reconnectScope(l)}if(i){var l=i.enableDisconnect?n.compileScope.$new():n.compileScope;return o.html(n.template),e(o.contents())(l),o.on("DOMSubtreeModified",function(){i.updatePagination(),i.updateInkBarStyles()}),t.nextTick(a)}}return{restrict:"A",link:n,scope:{template:"=mdTemplate",connected:"=?mdConnectedIf",compileScope:"=mdScope"},require:"^?mdTabs"}}t.module("material.components.tabs").directive("mdTemplate",e),e.$inject=["$compile","$mdUtil"]}(),function(){t.module("material.core").constant("$MD_THEME_CSS","/* mixin definition ; sets LTR and RTL within the same style call */md-backdrop {  background-color: '{{background-900-0.0}}'; }  md-backdrop.md-opaque.md-THEME_NAME-theme {    background-color: '{{background-900-0.48}}'; }  md-backdrop.md-opaque.md-THEME_NAME-theme.ng-enter {    background-color: '{{background-900-0.0}}'; }    md-backdrop.md-opaque.md-THEME_NAME-theme.ng-enter.md-opaque.md-THEME_NAME-theme.ng-enter-active {      background-color: '{{background-900-0.48}}'; }  md-backdrop.md-opaque.md-THEME_NAME-theme.ng-leave.md-opaque.md-THEME_NAME-theme.ng-leave-active {    background-color: '{{background-900-0.0}}'; }md-autocomplete.md-THEME_NAME-theme {  background: '{{background-50}}'; }  md-autocomplete.md-THEME_NAME-theme[disabled] {    background: '{{background-100}}'; }  md-autocomplete.md-THEME_NAME-theme button md-icon path {    fill: '{{background-600}}'; }  md-autocomplete.md-THEME_NAME-theme button:after {    background: '{{background-600-0.3}}'; }.md-autocomplete-suggestions.md-THEME_NAME-theme {  background: '{{background-50}}'; }  .md-autocomplete-suggestions.md-THEME_NAME-theme li {    color: '{{background-900}}'; }    .md-autocomplete-suggestions.md-THEME_NAME-theme li .highlight {      color: '{{background-600}}'; }    .md-autocomplete-suggestions.md-THEME_NAME-theme li:hover, .md-autocomplete-suggestions.md-THEME_NAME-theme li.selected {      background: '{{background-200}}'; }a.md-button.md-THEME_NAME-theme, .md-button.md-THEME_NAME-theme {  border-radius: 3px; }  a.md-button.md-THEME_NAME-theme:not([disabled]):hover, .md-button.md-THEME_NAME-theme:not([disabled]):hover {    background-color: '{{background-500-0.2}}'; }  a.md-button.md-THEME_NAME-theme:not([disabled]).md-focused, .md-button.md-THEME_NAME-theme:not([disabled]).md-focused {    background-color: '{{background-500-0.2}}'; }  a.md-button.md-THEME_NAME-theme:not([disabled]).md-icon-button:hover, .md-button.md-THEME_NAME-theme:not([disabled]).md-icon-button:hover {    background-color: transparent; }  a.md-button.md-THEME_NAME-theme.md-fab, .md-button.md-THEME_NAME-theme.md-fab {    border-radius: 50%;    background-color: '{{accent-color}}';    color: '{{accent-contrast}}'; }    a.md-button.md-THEME_NAME-theme.md-fab md-icon, .md-button.md-THEME_NAME-theme.md-fab md-icon {      color: '{{accent-contrast}}'; }    a.md-button.md-THEME_NAME-theme.md-fab:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-fab:not([disabled]):hover {      background-color: '{{accent-color}}'; }    a.md-button.md-THEME_NAME-theme.md-fab:not([disabled]).md-focused, .md-button.md-THEME_NAME-theme.md-fab:not([disabled]).md-focused {      background-color: '{{accent-A700}}'; }  a.md-button.md-THEME_NAME-theme.md-icon-button, .md-button.md-THEME_NAME-theme.md-icon-button {    border-radius: 50%; }  a.md-button.md-THEME_NAME-theme.md-primary, .md-button.md-THEME_NAME-theme.md-primary {    color: '{{primary-color}}'; }    a.md-button.md-THEME_NAME-theme.md-primary.md-raised, a.md-button.md-THEME_NAME-theme.md-primary.md-fab, .md-button.md-THEME_NAME-theme.md-primary.md-raised, .md-button.md-THEME_NAME-theme.md-primary.md-fab {      color: '{{primary-contrast}}';      background-color: '{{primary-color}}'; }      a.md-button.md-THEME_NAME-theme.md-primary.md-raised:not([disabled]) md-icon, a.md-button.md-THEME_NAME-theme.md-primary.md-fab:not([disabled]) md-icon, .md-button.md-THEME_NAME-theme.md-primary.md-raised:not([disabled]) md-icon, .md-button.md-THEME_NAME-theme.md-primary.md-fab:not([disabled]) md-icon {        color: '{{primary-contrast}}'; }      a.md-button.md-THEME_NAME-theme.md-primary.md-raised:not([disabled]):hover, a.md-button.md-THEME_NAME-theme.md-primary.md-fab:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-primary.md-raised:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-primary.md-fab:not([disabled]):hover {        background-color: '{{primary-color}}'; }      a.md-button.md-THEME_NAME-theme.md-primary.md-raised:not([disabled]).md-focused, a.md-button.md-THEME_NAME-theme.md-primary.md-fab:not([disabled]).md-focused, .md-button.md-THEME_NAME-theme.md-primary.md-raised:not([disabled]).md-focused, .md-button.md-THEME_NAME-theme.md-primary.md-fab:not([disabled]).md-focused {        background-color: '{{primary-600}}'; }    a.md-button.md-THEME_NAME-theme.md-primary:not([disabled]) md-icon, .md-button.md-THEME_NAME-theme.md-primary:not([disabled]) md-icon {      color: '{{primary-color}}'; }  a.md-button.md-THEME_NAME-theme.md-fab, .md-button.md-THEME_NAME-theme.md-fab {    border-radius: 50%;    background-color: '{{accent-color}}';    color: '{{accent-contrast}}'; }    a.md-button.md-THEME_NAME-theme.md-fab:not([disabled]) .md-icon, .md-button.md-THEME_NAME-theme.md-fab:not([disabled]) .md-icon {      color: '{{accent-contrast}}'; }    a.md-button.md-THEME_NAME-theme.md-fab:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-fab:not([disabled]):hover {      background-color: '{{accent-color}}'; }    a.md-button.md-THEME_NAME-theme.md-fab:not([disabled]).md-focused, .md-button.md-THEME_NAME-theme.md-fab:not([disabled]).md-focused {      background-color: '{{accent-A700}}'; }  a.md-button.md-THEME_NAME-theme.md-raised, .md-button.md-THEME_NAME-theme.md-raised {    color: '{{background-contrast}}';    background-color: '{{background-50}}'; }    a.md-button.md-THEME_NAME-theme.md-raised:not([disabled]) .md-icon, .md-button.md-THEME_NAME-theme.md-raised:not([disabled]) .md-icon {      color: '{{background-contrast}}'; }    a.md-button.md-THEME_NAME-theme.md-raised:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-raised:not([disabled]):hover {      background-color: '{{background-50}}'; }    a.md-button.md-THEME_NAME-theme.md-raised:not([disabled]).md-focused, .md-button.md-THEME_NAME-theme.md-raised:not([disabled]).md-focused {      background-color: '{{background-200}}'; }  a.md-button.md-THEME_NAME-theme.md-warn, .md-button.md-THEME_NAME-theme.md-warn {    color: '{{warn-color}}'; }    a.md-button.md-THEME_NAME-theme.md-warn.md-raised, a.md-button.md-THEME_NAME-theme.md-warn.md-fab, .md-button.md-THEME_NAME-theme.md-warn.md-raised, .md-button.md-THEME_NAME-theme.md-warn.md-fab {      color: '{{warn-contrast}}';      background-color: '{{warn-color}}'; }      a.md-button.md-THEME_NAME-theme.md-warn.md-raised:not([disabled]) md-icon, a.md-button.md-THEME_NAME-theme.md-warn.md-fab:not([disabled]) md-icon, .md-button.md-THEME_NAME-theme.md-warn.md-raised:not([disabled]) md-icon, .md-button.md-THEME_NAME-theme.md-warn.md-fab:not([disabled]) md-icon {        color: '{{warn-contrast}}'; }      a.md-button.md-THEME_NAME-theme.md-warn.md-raised:not([disabled]):hover, a.md-button.md-THEME_NAME-theme.md-warn.md-fab:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-warn.md-raised:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-warn.md-fab:not([disabled]):hover {        background-color: '{{warn-color}}'; }      a.md-button.md-THEME_NAME-theme.md-warn.md-raised:not([disabled]).md-focused, a.md-button.md-THEME_NAME-theme.md-warn.md-fab:not([disabled]).md-focused, .md-button.md-THEME_NAME-theme.md-warn.md-raised:not([disabled]).md-focused, .md-button.md-THEME_NAME-theme.md-warn.md-fab:not([disabled]).md-focused {        background-color: '{{warn-700}}'; }    a.md-button.md-THEME_NAME-theme.md-warn:not([disabled]) md-icon, .md-button.md-THEME_NAME-theme.md-warn:not([disabled]) md-icon {      color: '{{warn-color}}'; }  a.md-button.md-THEME_NAME-theme.md-accent, .md-button.md-THEME_NAME-theme.md-accent {    color: '{{accent-color}}'; }    a.md-button.md-THEME_NAME-theme.md-accent.md-raised, a.md-button.md-THEME_NAME-theme.md-accent.md-fab, .md-button.md-THEME_NAME-theme.md-accent.md-raised, .md-button.md-THEME_NAME-theme.md-accent.md-fab {      color: '{{accent-contrast}}';      background-color: '{{accent-color}}'; }      a.md-button.md-THEME_NAME-theme.md-accent.md-raised:not([disabled]) md-icon, a.md-button.md-THEME_NAME-theme.md-accent.md-fab:not([disabled]) md-icon, .md-button.md-THEME_NAME-theme.md-accent.md-raised:not([disabled]) md-icon, .md-button.md-THEME_NAME-theme.md-accent.md-fab:not([disabled]) md-icon {        color: '{{accent-contrast}}'; }      a.md-button.md-THEME_NAME-theme.md-accent.md-raised:not([disabled]):hover, a.md-button.md-THEME_NAME-theme.md-accent.md-fab:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-accent.md-raised:not([disabled]):hover, .md-button.md-THEME_NAME-theme.md-accent.md-fab:not([disabled]):hover {        background-color: '{{accent-color}}'; }      a.md-button.md-THEME_NAME-theme.md-accent.md-raised:not([disabled]).md-focused, a.md-button.md-THEME_NAME-theme.md-accent.md-fab:not([disabled]).md-focused, .md-button.md-THEME_NAME-theme.md-accent.md-raised:not([disabled]).md-focused, .md-button.md-THEME_NAME-theme.md-accent.md-fab:not([disabled]).md-focused {        background-color: '{{accent-700}}'; }    a.md-button.md-THEME_NAME-theme.md-accent:not([disabled]) md-icon, .md-button.md-THEME_NAME-theme.md-accent:not([disabled]) md-icon {      color: '{{accent-color}}'; }  a.md-button.md-THEME_NAME-theme[disabled], a.md-button.md-THEME_NAME-theme.md-raised[disabled], a.md-button.md-THEME_NAME-theme.md-fab[disabled], a.md-button.md-THEME_NAME-theme.md-accent[disabled], a.md-button.md-THEME_NAME-theme.md-warn[disabled], .md-button.md-THEME_NAME-theme[disabled], .md-button.md-THEME_NAME-theme.md-raised[disabled], .md-button.md-THEME_NAME-theme.md-fab[disabled], .md-button.md-THEME_NAME-theme.md-accent[disabled], .md-button.md-THEME_NAME-theme.md-warn[disabled] {    color: '{{foreground-3}}';    cursor: not-allowed; }    a.md-button.md-THEME_NAME-theme[disabled] md-icon, a.md-button.md-THEME_NAME-theme.md-raised[disabled] md-icon, a.md-button.md-THEME_NAME-theme.md-fab[disabled] md-icon, a.md-button.md-THEME_NAME-theme.md-accent[disabled] md-icon, a.md-button.md-THEME_NAME-theme.md-warn[disabled] md-icon, .md-button.md-THEME_NAME-theme[disabled] md-icon, .md-button.md-THEME_NAME-theme.md-raised[disabled] md-icon, .md-button.md-THEME_NAME-theme.md-fab[disabled] md-icon, .md-button.md-THEME_NAME-theme.md-accent[disabled] md-icon, .md-button.md-THEME_NAME-theme.md-warn[disabled] md-icon {      color: '{{foreground-3}}'; }  a.md-button.md-THEME_NAME-theme.md-raised[disabled], a.md-button.md-THEME_NAME-theme.md-fab[disabled], .md-button.md-THEME_NAME-theme.md-raised[disabled], .md-button.md-THEME_NAME-theme.md-fab[disabled] {    background-color: '{{foreground-4}}'; }  a.md-button.md-THEME_NAME-theme[disabled], .md-button.md-THEME_NAME-theme[disabled] {    background-color: transparent; }md-bottom-sheet.md-THEME_NAME-theme {  background-color: '{{background-50}}';  border-top-color: '{{background-300}}'; }  md-bottom-sheet.md-THEME_NAME-theme.md-list md-list-item {    color: '{{foreground-1}}'; }  md-bottom-sheet.md-THEME_NAME-theme .md-subheader {    background-color: '{{background-50}}'; }  md-bottom-sheet.md-THEME_NAME-theme .md-subheader {    color: '{{foreground-1}}'; }md-card.md-THEME_NAME-theme {  background-color: '{{background-color}}';  border-radius: 2px; }  md-card.md-THEME_NAME-theme .md-card-image {    border-radius: 2px 2px 0 0; }md-checkbox.md-THEME_NAME-theme .md-ripple {  color: '{{accent-600}}'; }md-checkbox.md-THEME_NAME-theme.md-checked .md-ripple {  color: '{{background-600}}'; }md-checkbox.md-THEME_NAME-theme.md-checked.md-focused .md-container:before {  background-color: '{{accent-color-0.26}}'; }md-checkbox.md-THEME_NAME-theme .md-icon {  border-color: '{{foreground-2}}'; }md-checkbox.md-THEME_NAME-theme.md-checked .md-icon {  background-color: '{{accent-color-0.87}}'; }md-checkbox.md-THEME_NAME-theme.md-checked .md-icon:after {  border-color: '{{background-200}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-primary .md-ripple {  color: '{{primary-600}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-primary.md-checked .md-ripple {  color: '{{background-600}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-primary .md-icon {  border-color: '{{foreground-2}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-primary.md-checked .md-icon {  background-color: '{{primary-color-0.87}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-primary.md-checked.md-focused .md-container:before {  background-color: '{{primary-color-0.26}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-primary.md-checked .md-icon:after {  border-color: '{{background-200}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-warn .md-ripple {  color: '{{warn-600}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-warn .md-icon {  border-color: '{{foreground-2}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-warn.md-checked .md-icon {  background-color: '{{warn-color-0.87}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-warn.md-checked.md-focused:not([disabled]) .md-container:before {  background-color: '{{warn-color-0.26}}'; }md-checkbox.md-THEME_NAME-theme:not([disabled]).md-warn.md-checked .md-icon:after {  border-color: '{{background-200}}'; }md-checkbox.md-THEME_NAME-theme[disabled] .md-icon {  border-color: '{{foreground-3}}'; }md-checkbox.md-THEME_NAME-theme[disabled].md-checked .md-icon {  background-color: '{{foreground-3}}'; }md-checkbox.md-THEME_NAME-theme[disabled] .md-label {  color: '{{foreground-3}}'; }md-chips.md-THEME_NAME-theme .md-chips {  box-shadow: 0 1px '{{background-300}}'; }  md-chips.md-THEME_NAME-theme .md-chips.md-focused {    box-shadow: 0 2px '{{primary-color}}'; }md-chips.md-THEME_NAME-theme .md-chip {  background: '{{background-300}}';  color: '{{background-800}}'; }  md-chips.md-THEME_NAME-theme .md-chip.md-focused {    background: '{{primary-color}}';    color: '{{primary-contrast}}'; }    md-chips.md-THEME_NAME-theme .md-chip.md-focused md-icon {      color: '{{primary-contrast}}'; }md-chips.md-THEME_NAME-theme md-chip-remove .md-button md-icon path {  fill: '{{background-500}}'; }.md-contact-suggestion span.md-contact-email {  color: '{{background-400}}'; }md-content.md-THEME_NAME-theme {  color: '{{foreground-1}}';  background-color: '{{background-color}}'; }md-dialog.md-THEME_NAME-theme {  border-radius: 4px;  background-color: '{{background-color}}'; }  md-dialog.md-THEME_NAME-theme.md-content-overflow .md-actions {    border-top-color: '{{foreground-4}}'; }md-divider.md-THEME_NAME-theme {  border-top-color: '{{foreground-4}}'; }md-icon.md-THEME_NAME-theme {  color: '{{foreground-2}}'; }  md-icon.md-THEME_NAME-theme.md-primary {    color: '{{primary-color}}'; }  md-icon.md-THEME_NAME-theme.md-accent {    color: '{{accent-color}}'; }  md-icon.md-THEME_NAME-theme.md-warn {    color: '{{warn-color}}'; }md-input-container.md-THEME_NAME-theme .md-input {  color: '{{foreground-1}}';  border-color: '{{foreground-4}}';  text-shadow: '{{foreground-shadow}}'; }  md-input-container.md-THEME_NAME-theme .md-input::-webkit-input-placeholder, md-input-container.md-THEME_NAME-theme .md-input::-moz-placeholder, md-input-container.md-THEME_NAME-theme .md-input:-moz-placeholder, md-input-container.md-THEME_NAME-theme .md-input:-ms-input-placeholder {    color: '{{foreground-3}}'; }md-input-container.md-THEME_NAME-theme > md-icon {  color: '{{foreground-1}}'; }md-input-container.md-THEME_NAME-theme label, md-input-container.md-THEME_NAME-theme .md-placeholder {  text-shadow: '{{foreground-shadow}}';  color: '{{foreground-3}}'; }md-input-container.md-THEME_NAME-theme ng-messages, md-input-container.md-THEME_NAME-theme [ng-message], md-input-container.md-THEME_NAME-theme [data-ng-message], md-input-container.md-THEME_NAME-theme [x-ng-message] {  color: '{{warn-500}}'; }md-input-container.md-THEME_NAME-theme:not(.md-input-invalid).md-input-has-value label {  color: '{{foreground-2}}'; }md-input-container.md-THEME_NAME-theme:not(.md-input-invalid).md-input-focused .md-input {  border-color: '{{primary-500}}'; }md-input-container.md-THEME_NAME-theme:not(.md-input-invalid).md-input-focused label {  color: '{{primary-500}}'; }md-input-container.md-THEME_NAME-theme:not(.md-input-invalid).md-input-focused md-icon {  color: '{{primary-500}}'; }md-input-container.md-THEME_NAME-theme:not(.md-input-invalid).md-input-focused.md-accent .md-input {  border-color: '{{accent-500}}'; }md-input-container.md-THEME_NAME-theme:not(.md-input-invalid).md-input-focused.md-accent label {  color: '{{accent-500}}'; }md-input-container.md-THEME_NAME-theme:not(.md-input-invalid).md-input-focused.md-warn .md-input {  border-color: '{{warn-500}}'; }md-input-container.md-THEME_NAME-theme:not(.md-input-invalid).md-input-focused.md-warn label {  color: '{{warn-500}}'; }md-input-container.md-THEME_NAME-theme.md-input-invalid .md-input {  border-color: '{{warn-500}}'; }md-input-container.md-THEME_NAME-theme.md-input-invalid.md-input-focused label {  color: '{{warn-500}}'; }md-input-container.md-THEME_NAME-theme.md-input-invalid ng-message, md-input-container.md-THEME_NAME-theme.md-input-invalid data-ng-message, md-input-container.md-THEME_NAME-theme.md-input-invalid x-ng-message, md-input-container.md-THEME_NAME-theme.md-input-invalid [ng-message], md-input-container.md-THEME_NAME-theme.md-input-invalid [data-ng-message], md-input-container.md-THEME_NAME-theme.md-input-invalid [x-ng-message], md-input-container.md-THEME_NAME-theme.md-input-invalid .md-char-counter {  color: '{{warn-500}}'; }md-input-container.md-THEME_NAME-theme .md-input[disabled], [disabled] md-input-container.md-THEME_NAME-theme .md-input {  border-bottom-color: transparent;  color: '{{foreground-3}}';  background-image: linear-gradient(to right, '{{foreground-3}}' 0%, '{{foreground-3}}' 33%, transparent 0%);  background-image: -ms-linear-gradient(left, transparent 0%, '{{foreground-3}}' 100%); }md-list.md-THEME_NAME-theme md-list-item.md-2-line .md-list-item-text h3, md-list.md-THEME_NAME-theme md-list-item.md-2-line .md-list-item-text h4, md-list.md-THEME_NAME-theme md-list-item.md-3-line .md-list-item-text h3, md-list.md-THEME_NAME-theme md-list-item.md-3-line .md-list-item-text h4 {  color: '{{foreground-1}}'; }md-list.md-THEME_NAME-theme md-list-item.md-2-line .md-list-item-text p, md-list.md-THEME_NAME-theme md-list-item.md-3-line .md-list-item-text p {  color: '{{foreground-2}}'; }md-list.md-THEME_NAME-theme .md-proxy-focus.md-focused div.md-no-style {  background-color: '{{background-100}}'; }md-list.md-THEME_NAME-theme md-list-item > md-icon {  color: '{{foreground-2}}'; }  md-list.md-THEME_NAME-theme md-list-item > md-icon.md-highlight {    color: '{{primary-color}}'; }    md-list.md-THEME_NAME-theme md-list-item > md-icon.md-highlight.md-accent {      color: '{{accent-color}}'; }md-list.md-THEME_NAME-theme md-list-item button {  background-color: '{{background-color}}'; }  md-list.md-THEME_NAME-theme md-list-item button.md-button:not([disabled]):hover {    background-color: '{{background-color}}'; }md-menu-content.md-THEME_NAME-theme {  background-color: '{{background-color}}'; }  md-menu-content.md-THEME_NAME-theme md-menu-divider {    background-color: '{{foreground-4}}'; }md-progress-circular.md-THEME_NAME-theme {  background-color: transparent; }  md-progress-circular.md-THEME_NAME-theme .md-inner .md-gap {    border-top-color: '{{primary-color}}';    border-bottom-color: '{{primary-color}}'; }  md-progress-circular.md-THEME_NAME-theme .md-inner .md-left .md-half-circle, md-progress-circular.md-THEME_NAME-theme .md-inner .md-right .md-half-circle {    border-top-color: '{{primary-color}}'; }  md-progress-circular.md-THEME_NAME-theme .md-inner .md-right .md-half-circle {    border-right-color: '{{primary-color}}'; }  md-progress-circular.md-THEME_NAME-theme .md-inner .md-left .md-half-circle {    border-left-color: '{{primary-color}}'; }  md-progress-circular.md-THEME_NAME-theme.md-warn .md-inner .md-gap {    border-top-color: '{{warn-color}}';    border-bottom-color: '{{warn-color}}'; }  md-progress-circular.md-THEME_NAME-theme.md-warn .md-inner .md-left .md-half-circle, md-progress-circular.md-THEME_NAME-theme.md-warn .md-inner .md-right .md-half-circle {    border-top-color: '{{warn-color}}'; }  md-progress-circular.md-THEME_NAME-theme.md-warn .md-inner .md-right .md-half-circle {    border-right-color: '{{warn-color}}'; }  md-progress-circular.md-THEME_NAME-theme.md-warn .md-inner .md-left .md-half-circle {    border-left-color: '{{warn-color}}'; }  md-progress-circular.md-THEME_NAME-theme.md-accent .md-inner .md-gap {    border-top-color: '{{accent-color}}';    border-bottom-color: '{{accent-color}}'; }  md-progress-circular.md-THEME_NAME-theme.md-accent .md-inner .md-left .md-half-circle, md-progress-circular.md-THEME_NAME-theme.md-accent .md-inner .md-right .md-half-circle {    border-top-color: '{{accent-color}}'; }  md-progress-circular.md-THEME_NAME-theme.md-accent .md-inner .md-right .md-half-circle {    border-right-color: '{{accent-color}}'; }  md-progress-circular.md-THEME_NAME-theme.md-accent .md-inner .md-left .md-half-circle {    border-left-color: '{{accent-color}}'; }md-progress-linear.md-THEME_NAME-theme .md-container {  background-color: '{{primary-100}}'; }md-progress-linear.md-THEME_NAME-theme .md-bar {  background-color: '{{primary-color}}'; }md-progress-linear.md-THEME_NAME-theme.md-warn .md-container {  background-color: '{{warn-100}}'; }md-progress-linear.md-THEME_NAME-theme.md-warn .md-bar {  background-color: '{{warn-color}}'; }md-progress-linear.md-THEME_NAME-theme.md-accent .md-container {  background-color: '{{accent-100}}'; }md-progress-linear.md-THEME_NAME-theme.md-accent .md-bar {  background-color: '{{accent-color}}'; }md-progress-linear.md-THEME_NAME-theme[md-mode=buffer].md-warn .md-bar1 {  background-color: '{{warn-100}}'; }md-progress-linear.md-THEME_NAME-theme[md-mode=buffer].md-warn .md-dashed:before {  background: radial-gradient('{{warn-100}}' 0%, '{{warn-100}}' 16%, transparent 42%); }md-progress-linear.md-THEME_NAME-theme[md-mode=buffer].md-accent .md-bar1 {  background-color: '{{accent-100}}'; }md-progress-linear.md-THEME_NAME-theme[md-mode=buffer].md-accent .md-dashed:before {  background: radial-gradient('{{accent-100}}' 0%, '{{accent-100}}' 16%, transparent 42%); }md-radio-button.md-THEME_NAME-theme .md-off {  border-color: '{{foreground-2}}'; }md-radio-button.md-THEME_NAME-theme .md-on {  background-color: '{{accent-color-0.87}}'; }md-radio-button.md-THEME_NAME-theme.md-checked .md-off {  border-color: '{{accent-color-0.87}}'; }md-radio-button.md-THEME_NAME-theme.md-checked .md-ink-ripple {  color: '{{accent-color-0.87}}'; }md-radio-button.md-THEME_NAME-theme .md-container .md-ripple {  color: '{{accent-600}}'; }md-radio-group.md-THEME_NAME-theme:not([disabled]) .md-primary .md-on, md-radio-group.md-THEME_NAME-theme:not([disabled]).md-primary .md-on, md-radio-button.md-THEME_NAME-theme:not([disabled]) .md-primary .md-on, md-radio-button.md-THEME_NAME-theme:not([disabled]).md-primary .md-on {  background-color: '{{primary-color-0.87}}'; }md-radio-group.md-THEME_NAME-theme:not([disabled]) .md-primary .md-checked .md-off, md-radio-group.md-THEME_NAME-theme:not([disabled]) .md-primary.md-checked .md-off, md-radio-group.md-THEME_NAME-theme:not([disabled]).md-primary .md-checked .md-off, md-radio-group.md-THEME_NAME-theme:not([disabled]).md-primary.md-checked .md-off, md-radio-button.md-THEME_NAME-theme:not([disabled]) .md-primary .md-checked .md-off, md-radio-button.md-THEME_NAME-theme:not([disabled]) .md-primary.md-checked .md-off, md-radio-button.md-THEME_NAME-theme:not([disabled]).md-primary .md-checked .md-off, md-radio-button.md-THEME_NAME-theme:not([disabled]).md-primary.md-checked .md-off {  border-color: '{{primary-color-0.87}}'; }md-radio-group.md-THEME_NAME-theme:not([disabled]) .md-primary .md-checked .md-ink-ripple, md-radio-group.md-THEME_NAME-theme:not([disabled]) .md-primary.md-checked .md-ink-ripple, md-radio-group.md-THEME_NAME-theme:not([disabled]).md-primary .md-checked .md-ink-ripple, md-radio-group.md-THEME_NAME-theme:not([disabled]).md-primary.md-checked .md-ink-ripple, md-radio-button.md-THEME_NAME-theme:not([disabled]) .md-primary .md-checked .md-ink-ripple, md-radio-button.md-THEME_NAME-theme:not([disabled]) .md-primary.md-checked .md-ink-ripple, md-radio-button.md-THEME_NAME-theme:not([disabled]).md-primary .md-checked .md-ink-ripple, md-radio-button.md-THEME_NAME-theme:not([disabled]).md-primary.md-checked .md-ink-ripple {  color: '{{primary-color-0.87}}'; }md-radio-group.md-THEME_NAME-theme:not([disabled]) .md-primary .md-container .md-ripple, md-radio-group.md-THEME_NAME-theme:not([disabled]).md-primary .md-container .md-ripple, md-radio-button.md-THEME_NAME-theme:not([disabled]) .md-primary .md-container .md-ripple, md-radio-button.md-THEME_NAME-theme:not([disabled]).md-primary .md-container .md-ripple {  color: '{{primary-600}}'; }md-radio-group.md-THEME_NAME-theme:not([disabled]) .md-warn .md-on, md-radio-group.md-THEME_NAME-theme:not([disabled]).md-warn .md-on, md-radio-button.md-THEME_NAME-theme:not([disabled]) .md-warn .md-on, md-radio-button.md-THEME_NAME-theme:not([disabled]).md-warn .md-on {  background-color: '{{warn-color-0.87}}'; }md-radio-group.md-THEME_NAME-theme:not([disabled]) .md-warn .md-checked .md-off, md-radio-group.md-THEME_NAME-theme:not([disabled]) .md-warn.md-checked .md-off, md-radio-group.md-THEME_NAME-theme:not([disabled]).md-warn .md-checked .md-off, md-radio-group.md-THEME_NAME-theme:not([disabled]).md-warn.md-checked .md-off, md-radio-button.md-THEME_NAME-theme:not([disabled]) .md-warn .md-checked .md-off, md-radio-button.md-THEME_NAME-theme:not([disabled]) .md-warn.md-checked .md-off, md-radio-button.md-THEME_NAME-theme:not([disabled]).md-warn .md-checked .md-off, md-radio-button.md-THEME_NAME-theme:not([disabled]).md-warn.md-checked .md-off {  border-color: '{{warn-color-0.87}}'; }md-radio-group.md-THEME_NAME-theme:not([disabled]) .md-warn .md-checked .md-ink-ripple, md-radio-group.md-THEME_NAME-theme:not([disabled]) .md-warn.md-checked .md-ink-ripple, md-radio-group.md-THEME_NAME-theme:not([disabled]).md-warn .md-checked .md-ink-ripple, md-radio-group.md-THEME_NAME-theme:not([disabled]).md-warn.md-checked .md-ink-ripple, md-radio-button.md-THEME_NAME-theme:not([disabled]) .md-warn .md-checked .md-ink-ripple, md-radio-button.md-THEME_NAME-theme:not([disabled]) .md-warn.md-checked .md-ink-ripple, md-radio-button.md-THEME_NAME-theme:not([disabled]).md-warn .md-checked .md-ink-ripple, md-radio-button.md-THEME_NAME-theme:not([disabled]).md-warn.md-checked .md-ink-ripple {  color: '{{warn-color-0.87}}'; }md-radio-group.md-THEME_NAME-theme:not([disabled]) .md-warn .md-container .md-ripple, md-radio-group.md-THEME_NAME-theme:not([disabled]).md-warn .md-container .md-ripple, md-radio-button.md-THEME_NAME-theme:not([disabled]) .md-warn .md-container .md-ripple, md-radio-button.md-THEME_NAME-theme:not([disabled]).md-warn .md-container .md-ripple {  color: '{{warn-600}}'; }md-radio-group.md-THEME_NAME-theme[disabled], md-radio-button.md-THEME_NAME-theme[disabled] {  color: '{{foreground-3}}'; }  md-radio-group.md-THEME_NAME-theme[disabled] .md-container .md-off, md-radio-button.md-THEME_NAME-theme[disabled] .md-container .md-off {    border-color: '{{foreground-3}}'; }  md-radio-group.md-THEME_NAME-theme[disabled] .md-container .md-on, md-radio-button.md-THEME_NAME-theme[disabled] .md-container .md-on {    border-color: '{{foreground-3}}'; }md-radio-group.md-THEME_NAME-theme.md-focused:not(:empty) .md-checked .md-container:before {  background-color: '{{accent-color-0.26}}'; }md-radio-group.md-THEME_NAME-theme.md-focused:not(:empty) .md-checked:not([disabled]).md-primary .md-container:before {  background-color: '{{primary-color-0.26}}'; }md-radio-group.md-THEME_NAME-theme.md-focused:not(:empty) .md-checked.md-primary .md-container:before {  background-color: '{{warn-color-0.26}}'; }md-select.md-THEME_NAME-theme .md-select-value {  border-bottom-color: '{{foreground-4}}'; }  md-select.md-THEME_NAME-theme .md-select-value.md-select-placeholder {    color: '{{foreground-3}}'; }md-select.md-THEME_NAME-theme.ng-invalid.ng-dirty .md-select-label {  color: '{{warn-500}}' !important;  border-bottom-color: '{{warn-500}}' !important; }md-select.md-THEME_NAME-theme:not([disabled]):focus .md-select-value {  border-bottom-color: '{{primary-color}}';  color: '{{ foreground-1 }}'; }  md-select.md-THEME_NAME-theme:not([disabled]):focus .md-select-value.md-select-placeholder {    color: '{{ foreground-1 }}'; }md-select.md-THEME_NAME-theme:not([disabled]):focus.md-accent .md-select-value {  border-bottom-color: '{{accent-color}}'; }md-select.md-THEME_NAME-theme:not([disabled]):focus.md-warn .md-select-value {  border-bottom-color: '{{warn-color}}'; }md-select.md-THEME_NAME-theme[disabled] .md-select-value {  color: '{{foreground-3}}'; }  md-select.md-THEME_NAME-theme[disabled] .md-select-value.md-select-placeholder {    color: '{{foreground-3}}'; }md-select-menu.md-THEME_NAME-theme md-option[disabled] {  color: '{{foreground-3}}'; }md-select-menu.md-THEME_NAME-theme md-optgroup {  color: '{{foreground-2}}'; }  md-select-menu.md-THEME_NAME-theme md-optgroup md-option {    color: '{{foreground-1}}'; }md-select-menu.md-THEME_NAME-theme md-option[selected] {  color: '{{primary-500}}'; }  md-select-menu.md-THEME_NAME-theme md-option[selected]:focus {    color: '{{primary-600}}'; }  md-select-menu.md-THEME_NAME-theme md-option[selected].md-accent {    color: '{{accent-500}}'; }    md-select-menu.md-THEME_NAME-theme md-option[selected].md-accent:focus {      color: '{{accent-600}}'; }md-select-menu.md-THEME_NAME-theme md-option:focus:not([selected]) {  background: '{{background-200}}'; }md-sidenav.md-THEME_NAME-theme {  background-color: '{{background-color}}'; }md-slider.md-THEME_NAME-theme .md-track {  background-color: '{{foreground-3}}'; }md-slider.md-THEME_NAME-theme .md-track-ticks {  background-color: '{{foreground-4}}'; }md-slider.md-THEME_NAME-theme .md-focus-thumb {  background-color: '{{foreground-2}}'; }md-slider.md-THEME_NAME-theme .md-focus-ring {  border-color: '{{foreground-4}}'; }md-slider.md-THEME_NAME-theme .md-disabled-thumb {  border-color: '{{background-color}}'; }md-slider.md-THEME_NAME-theme.md-min .md-thumb:after {  background-color: '{{background-color}}'; }md-slider.md-THEME_NAME-theme .md-track.md-track-fill {  background-color: '{{accent-color}}'; }md-slider.md-THEME_NAME-theme .md-thumb:after {  border-color: '{{accent-color}}';  background-color: '{{accent-color}}'; }md-slider.md-THEME_NAME-theme .md-sign {  background-color: '{{accent-color}}'; }  md-slider.md-THEME_NAME-theme .md-sign:after {    border-top-color: '{{accent-color}}'; }md-slider.md-THEME_NAME-theme .md-thumb-text {  color: '{{accent-contrast}}'; }md-slider.md-THEME_NAME-theme.md-warn .md-track.md-track-fill {  background-color: '{{warn-color}}'; }md-slider.md-THEME_NAME-theme.md-warn .md-thumb:after {  border-color: '{{warn-color}}';  background-color: '{{warn-color}}'; }md-slider.md-THEME_NAME-theme.md-warn .md-sign {  background-color: '{{warn-color}}'; }  md-slider.md-THEME_NAME-theme.md-warn .md-sign:after {    border-top-color: '{{warn-color}}'; }md-slider.md-THEME_NAME-theme.md-warn .md-thumb-text {  color: '{{warn-contrast}}'; }md-slider.md-THEME_NAME-theme.md-primary .md-track.md-track-fill {  background-color: '{{primary-color}}'; }md-slider.md-THEME_NAME-theme.md-primary .md-thumb:after {  border-color: '{{primary-color}}';  background-color: '{{primary-color}}'; }md-slider.md-THEME_NAME-theme.md-primary .md-sign {  background-color: '{{primary-color}}'; }  md-slider.md-THEME_NAME-theme.md-primary .md-sign:after {    border-top-color: '{{primary-color}}'; }md-slider.md-THEME_NAME-theme.md-primary .md-thumb-text {  color: '{{primary-contrast}}'; }md-slider.md-THEME_NAME-theme[disabled] .md-thumb:after {  border-color: '{{foreground-3}}'; }md-slider.md-THEME_NAME-theme[disabled]:not(.md-min) .md-thumb:after {  background-color: '{{foreground-3}}'; }.md-subheader.md-THEME_NAME-theme {  color: '{{ foreground-2-0.23 }}';  background-color: '{{background-color}}'; }  .md-subheader.md-THEME_NAME-theme.md-primary {    color: '{{primary-color}}'; }  .md-subheader.md-THEME_NAME-theme.md-accent {    color: '{{accent-color}}'; }  .md-subheader.md-THEME_NAME-theme.md-warn {    color: '{{warn-color}}'; }md-switch.md-THEME_NAME-theme .md-thumb {  background-color: '{{background-50}}'; }md-switch.md-THEME_NAME-theme .md-bar {  background-color: '{{background-500}}'; }md-switch.md-THEME_NAME-theme.md-checked .md-thumb {  background-color: '{{accent-color}}'; }md-switch.md-THEME_NAME-theme.md-checked .md-bar {  background-color: '{{accent-color-0.5}}'; }md-switch.md-THEME_NAME-theme.md-checked.md-focused .md-thumb:before {  background-color: '{{accent-color-0.26}}'; }md-switch.md-THEME_NAME-theme.md-checked.md-primary .md-thumb {  background-color: '{{primary-color}}'; }md-switch.md-THEME_NAME-theme.md-checked.md-primary .md-bar {  background-color: '{{primary-color-0.5}}'; }md-switch.md-THEME_NAME-theme.md-checked.md-primary.md-focused .md-thumb:before {  background-color: '{{primary-color-0.26}}'; }md-switch.md-THEME_NAME-theme.md-checked.md-warn .md-thumb {  background-color: '{{warn-color}}'; }md-switch.md-THEME_NAME-theme.md-checked.md-warn .md-bar {  background-color: '{{warn-color-0.5}}'; }md-switch.md-THEME_NAME-theme.md-checked.md-warn.md-focused .md-thumb:before {  background-color: '{{warn-color-0.26}}'; }md-switch.md-THEME_NAME-theme[disabled] .md-thumb {  background-color: '{{background-400}}'; }md-switch.md-THEME_NAME-theme[disabled] .md-bar {  background-color: '{{foreground-4}}'; }md-tabs.md-THEME_NAME-theme md-tabs-wrapper {  background-color: transparent;  border-color: '{{foreground-4}}'; }md-tabs.md-THEME_NAME-theme .md-paginator md-icon {  color: '{{primary-color}}'; }md-tabs.md-THEME_NAME-theme md-ink-bar {  color: '{{accent-color}}';  background: '{{accent-color}}'; }md-tabs.md-THEME_NAME-theme .md-tab {  color: '{{foreground-2}}'; }  md-tabs.md-THEME_NAME-theme .md-tab[disabled] {    color: '{{foreground-3}}'; }  md-tabs.md-THEME_NAME-theme .md-tab.md-active, md-tabs.md-THEME_NAME-theme .md-tab.md-focused {    color: '{{primary-color}}'; }  md-tabs.md-THEME_NAME-theme .md-tab.md-focused {    background: '{{primary-color-0.1}}'; }  md-tabs.md-THEME_NAME-theme .md-tab .md-ripple-container {    color: '{{accent-100}}'; }md-tabs.md-THEME_NAME-theme.md-accent > md-tabs-wrapper {  background-color: '{{accent-color}}'; }  md-tabs.md-THEME_NAME-theme.md-accent > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]) {    color: '{{accent-100}}'; }    md-tabs.md-THEME_NAME-theme.md-accent > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-active, md-tabs.md-THEME_NAME-theme.md-accent > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-focused {      color: '{{accent-contrast}}'; }    md-tabs.md-THEME_NAME-theme.md-accent > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-focused {      background: '{{accent-contrast-0.1}}'; }  md-tabs.md-THEME_NAME-theme.md-accent > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-ink-bar {    color: '{{primary-600-1}}';    background: '{{primary-600-1}}'; }md-tabs.md-THEME_NAME-theme.md-primary > md-tabs-wrapper {  background-color: '{{primary-color}}'; }  md-tabs.md-THEME_NAME-theme.md-primary > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]) {    color: '{{primary-100}}'; }    md-tabs.md-THEME_NAME-theme.md-primary > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-active, md-tabs.md-THEME_NAME-theme.md-primary > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-focused {      color: '{{primary-contrast}}'; }    md-tabs.md-THEME_NAME-theme.md-primary > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-focused {      background: '{{primary-contrast-0.1}}'; }md-tabs.md-THEME_NAME-theme.md-warn > md-tabs-wrapper {  background-color: '{{warn-color}}'; }  md-tabs.md-THEME_NAME-theme.md-warn > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]) {    color: '{{warn-100}}'; }    md-tabs.md-THEME_NAME-theme.md-warn > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-active, md-tabs.md-THEME_NAME-theme.md-warn > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-focused {      color: '{{warn-contrast}}'; }    md-tabs.md-THEME_NAME-theme.md-warn > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-focused {      background: '{{warn-contrast-0.1}}'; }md-toolbar > md-tabs.md-THEME_NAME-theme > md-tabs-wrapper {  background-color: '{{primary-color}}'; }  md-toolbar > md-tabs.md-THEME_NAME-theme > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]) {    color: '{{primary-100}}'; }    md-toolbar > md-tabs.md-THEME_NAME-theme > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-active, md-toolbar > md-tabs.md-THEME_NAME-theme > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-focused {      color: '{{primary-contrast}}'; }    md-toolbar > md-tabs.md-THEME_NAME-theme > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-focused {      background: '{{primary-contrast-0.1}}'; }md-toolbar.md-accent > md-tabs.md-THEME_NAME-theme > md-tabs-wrapper {  background-color: '{{accent-color}}'; }  md-toolbar.md-accent > md-tabs.md-THEME_NAME-theme > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]) {    color: '{{accent-100}}'; }    md-toolbar.md-accent > md-tabs.md-THEME_NAME-theme > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-active, md-toolbar.md-accent > md-tabs.md-THEME_NAME-theme > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-focused {      color: '{{accent-contrast}}'; }    md-toolbar.md-accent > md-tabs.md-THEME_NAME-theme > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-focused {      background: '{{accent-contrast-0.1}}'; }  md-toolbar.md-accent > md-tabs.md-THEME_NAME-theme > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-ink-bar {    color: '{{primary-600-1}}';    background: '{{primary-600-1}}'; }md-toolbar.md-warn > md-tabs.md-THEME_NAME-theme > md-tabs-wrapper {  background-color: '{{warn-color}}'; }  md-toolbar.md-warn > md-tabs.md-THEME_NAME-theme > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]) {    color: '{{warn-100}}'; }    md-toolbar.md-warn > md-tabs.md-THEME_NAME-theme > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-active, md-toolbar.md-warn > md-tabs.md-THEME_NAME-theme > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-focused {      color: '{{warn-contrast}}'; }    md-toolbar.md-warn > md-tabs.md-THEME_NAME-theme > md-tabs-wrapper > md-tabs-canvas > md-pagination-wrapper > md-tab-item:not([disabled]).md-focused {      background: '{{warn-contrast-0.1}}'; }md-toast.md-THEME_NAME-theme {  background-color: #323232;  color: '{{background-50}}'; }  md-toast.md-THEME_NAME-theme .md-button {    color: '{{background-50}}'; }    md-toast.md-THEME_NAME-theme .md-button.md-highlight {      color: '{{primary-A200}}'; }      md-toast.md-THEME_NAME-theme .md-button.md-highlight.md-accent {        color: '{{accent-A200}}'; }      md-toast.md-THEME_NAME-theme .md-button.md-highlight.md-warn {        color: '{{warn-A200}}'; }md-tooltip.md-THEME_NAME-theme {  color: '{{background-A100}}'; }  md-tooltip.md-THEME_NAME-theme .md-background {    background-color: '{{foreground-2}}'; }md-toolbar.md-THEME_NAME-theme {  background-color: '{{primary-color}}';  color: '{{primary-contrast}}'; }  md-toolbar.md-THEME_NAME-theme md-icon {    color: '{{primary-contrast}}'; }  md-toolbar.md-THEME_NAME-theme .md-button {    color: '{{primary-contrast}}'; }  md-toolbar.md-THEME_NAME-theme.md-accent {    background-color: '{{accent-color}}';    color: '{{accent-contrast}}'; }  md-toolbar.md-THEME_NAME-theme.md-warn {    background-color: '{{warn-color}}';    color: '{{warn-contrast}}'; }");

}()}(window,window.angular);